# #
# $Date: 1995/05/17 08:44:20 $ $Author: kg $ $Revision: 1.15 $ #
# #
# frankp, 13/06/94 #

#++

MatrixCat  --  represents the category of matrices

MatrixCat(R)

R - the coefficient domain (a Rng)

The category MatrixCat(R) represents all matrices over the Rng R.

The method "dimen" has to return the dimension of a matrix in form of
a list [nrows,ncols].

The method "new" of a respected domain of these category has to define
a m times n matrix by "this::new( m,n )". This is necessary for
method "_mult" of this category to define a new matrix of a certain dimension.

The methods "_index", "set_index" and "dimen" need the internal representation
of a matrix. Therefore these methods have to be implemented in a respected
domain.

Methods:
coeffRing          : returns the coefficient Rng
_mult(A,B,..)      : computes A*B*..
_plus(A,B,..)      : computes A+B+..
negate(A)          : returns -A
minus(A,B)         : computes A-B
iszero(A)          : returns true iff A is zero
equal(A,B)         : returns true iff A=B
++#

MatrixCat := CategoryConstructor(
# name #
    MatrixCat,
# arguments #
    [ R ],
# local variables #
    [],
# initialisation #
    (if args(0) <> 1 then error("wrong no of args") end_if;
     if R::hasProp(Rng) <> TRUE then
	error("coefficients must be from a Rng")
    end_if),
# super-categories #
    [ SetCat ],
# axioms #
    [ ],
# #
# basis methods #
    "_index", "set_index", "dimen", 
# #
# coeffRing #
    "coeffRing" = R,
# #
# _plus() #
    "_plus" = proc()
        local a, b, x, y, r, c, k, i;
    begin
        b := [args()];
        a := _plus(op(select(b,fun( bool(domtype(args(1))<>this)))));
        b := select(b,fun( bool(domtype(args(1))=this) ));

	x := b[1];
        r := this::dimen(x); c := r[2]; r := r[1];
	for k from 2 to nops(b) do
	    y := b[k];
	    if [r,c] <> this::dimen(y) then
		error("dimensions don't match")
	    end_if;
	    for i from 1 to r do
		( x[i,j] := R::_plus( x[i,j],y[i,j] ) ) $ hold(j)=1..c
	    end_for
	end_for;

        if type(a) = "_plus" then # flat operands of a #
            hold(_plus)(op(a),x)
        elif a = 0 then
            x
        else
            hold(_plus)(a,x)
        end_if
    end_proc,
# #
# _mult() #
    "_mult" = proc()
        local a, b, x, y, m, i, j, cy, cx, rx, p;
    begin
        b := [args()];
        a := _mult( op(select(b,fun( bool(domtype(args(1))<>this) ))) );
        b := select(b,fun( bool(domtype(args(1))=this) ));

        x := b[1];
	rx := this::dimen(x); cx := rx[2]; rx := rx[1];
        for m from 2 to nops(b) do
            y := b[m];
	    cy := this::dimen(y);
            if cx <> cy[1] then 
		error("dimensions don't match") 
	    end_if;
            cy := cy[2];
	    p := this::new( rx,cy );
	    for i from 1 to rx do
		for j from 1 to cy do
		    p[i,j] := R::_plus(R::_mult(x[i,k],y[k,j]) $ hold(k)=1..cx)
		end_for
	    end_for;
	    x := p;
	    cx := cy
        end_for;

        if type(a) = "_mult" then # flat operands of a #
            hold(_mult)(op(a),x)
        elif domtype(a) = DOM_INT then
            if a = 0 then
                new(this,rx,cx,array(1..rx,1..cx,[[Rzero $ cx] $ rx]))
            elif a = 1 then x
            elif a = -1 then this::negate(x)
            elif a > 0 then this::_plus(x $ a)
            else
                this::negate( this::_plus(x $ -a) )
            end_if
        else
            hold(_mult)(a,x)
        end_if
    end_proc,
# #
# negate() #
    "negate" = proc(a)
	local r, c, i, n;
    begin
	r := this::dimen(a); c := r[2]; r := r[1];
	n := a;
	for i from 1 to r do
	    (n[i,j] := R::negate(a[i,j])) $ hold(j)=1..c
	end_for;
	n
    end_proc,
# #
# minus() #
    "minus" = fun( this::_plus( args(1),this::negate(args(2)) ) ),
# #
# iszero() #
    "iszero" = proc(a)
	local r, c, i, j;
    begin
	r := this::dimen(a); c := r[2]; r := r[1];
	for i from 1 to r do
	    for j from 1 to c do
		if not R::iszero(a[i,j]) then return( FALSE ) end_if
	    end_for
	end_for;
	TRUE
    end_proc,
# #
# equal() #
    "equal" = fun(
	(if this::dimen(args(1)) <> this::dimen(args(2)) then 
	     FALSE
	 else
	     this::iszero( this::_plus( args(1),this::negate(args(2)) ) )
	 end_if)
    )
):

