# $Date: 1995/05/17 15:57:53 $ $Author: kg $ $Revision: 1.6 $ #
#++
HomogeneousFiniteCollectionCat -- the category of homogeneous finite collections

HomogeneousFiniteCollectionCat(Dom)

A homogeneous finite collection is a finite collection where each element is
from the same domain Dom.

Entries:-
elemDom - the domain where the elements are from
++#

HomogeneousFiniteCollectionCat:= CategoryConstructor(
    HomogeneousFiniteCollectionCat,
    [ Dom ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if Dom::hasProp(SetCat) <> TRUE then error("not a set") end_if ),
    [ FiniteCollectionCat,
      ( if Dom::hasProp(OrderedSet) then OrderedSet end_if ) ],
    [ ],
    
    "elemDom" = Dom,
    
    "_less" = (if Dom::hasProp(OrderedSet) then
	    # order elements lexicographically #
	    proc(x,y) local i; begin
	    	for i from 1 to min(this::nops(x), this::nops(y)) do
	    	    if not Dom::equal(this::_index(x,i), this::_index(y,i)) then
	    	    	return(bool(Dom::_less(this::_index(x,i), this::_index(y,i))))
	    	    end_if
	    	end_for;
	    	bool(this::nops(x) < this::nops(y))
	    end_proc
    end_if)
    
):

