# $Date: 1995/05/17 08:43:59 $ $Author: kg $ $Revision: 1.8 $ #
#++
CancellationAbelianMonoid -- the category of abelian monoids with cancellation

An CancellationAbelianMonoid is a AbelianMonoid where the cancellation
law holds, ie. a+b = a+c implies b = c.

Methods:-
minus(x,y)   - returns z such that y+z = x or FAIL if z dosn't exist. The
	       result is unique due to the cancellation law.
negate(x)    - returns minus(0,x)
intmult(x,i) - returns x+x+...x (i times) if i is an positive integer, 0 if
	       i=0 and intmult(negate(x),-i) if i is a negative integer
++#

CancellationAbelianMonoid:= CategoryConstructor(
    CancellationAbelianMonoid,
    [],
    [],
    NIL,
    [ AbelianMonoid ],
    [],

    "minus", 
    
    "iszero" = (if this::hasProp(normalRep) then
        AbelianMonoid::iszero
    else
        toBeDefined
    end_if),

    "equal" = proc(x,y) begin
	x:= this::minus(x, y);
	if x = FAIL then FALSE else this::iszero(x) end_if
    end_proc,

    "negate" = proc(x) begin this::minus(this::zero, x) end_proc,

    "intmult" = domains::repeatedSquaring(this, "_plus", "zero", "negate")

)():

