#
stirling2 -- Stirling numbers of the second kind

Calling Sequence:

   stirling2(n, m)

Parameters:

   n, m -- non-negative integer

Synopsis:
                     m
                   -----
               1   \        (m - k)  / m \    n
  S2(n,m) =  ----   )   (-1)         |   |   k
              m!   /                 \ k /
                   -----
                   k = 0

           n - 1
           -----
           \     / n - 1 \ 
         =  )    |       | * S2(k, m-1)
           /     \   k   /
           ----
           k = 0
          
         = m * S2(n-1, m) + S2(n-1, m-1)

  S2(n,m) = 0 f.a m > n, S2(n, 0) = 0 , S2(n,n) = S2(n,1) = 1 f.a. n > 0

           
  stirling2(n, m) is the number of ways of partitioning
  a set of n elements into m non-empty subsets.

See also:

  stirling1, binomial
#
  
combinat::stirling2 := proc(n, m) 
   option remember;
begin
   if testargs() then
      if args(0) <> 2 then
         error("Two arguments expected.")
      elif not testtype(m, Type::NonNegInt) or
           not testtype(n, Type::NonNegInt) then
           error(" Arguments must be non negativ integers.")
      end_if
   end_if;

   if m = 0 or m > n then 
      0
   elif m = n or m = 1 then
      1
   elif n = m+1 then 
      binomial(n,2)
   else
      1/fact(m)*_plus((-1)^(m-k)*binomial(m,k)*k^n $ k=0..m)
   end_if

end_proc:

