# $Date: 1995/01/17 13:13:12 $  $Author: olli $  $Revision: 1.1 $ #
# 23.3.93, kamo
 permute(n) - permutations of a list

If n is an integer, then permute(n) returns a list with all permutations of [1,...,n]. 
If n is a list, a list of all permutations of n is returned.

#
combinat::permute:= proc(n)
	local list,perm;
	begin
	perm := proc(list)
	local i, elem, result, res;
	begin 
		if nops(list) = 2 then
			return([[op(list,1),op(list,2)],[op(list,2),op(list,1)]])
		end_if;
		result := [];
		for i from 1 to nops(list) do
			elem := list[i]:
			res := perm(subsop(list, i=null()));
			result := result.map(res, append, elem);
		end_for;
		result;
	end_proc;

	if testtype(n,DOM_INT) then
		if n < 0 then
			error("argument must be a list or a non-negative integer!");
		end_if;
		case n 
		 	of 0 do return([[]]); break;
			of 1 do return([[1]]); break;
			otherwise list := [$1..n];
		end_case;
	else
		list := n;
	end_if;

	if not testtype(list,DOM_LIST) then
		error("argument must be a list or a non-negative integer!");
	end_if;
	if args(0) <> 1 then 
		error("wrong number of arguments !");
	end_if;
	
	perm(list);
end_proc:
