#
| This file contains the definition of the
| procedure kdv_two(), describing the so
| called two soliton solution of the Korte-
| weg-de Vries equation. The third and fourth
| parameters describe the asymptotic veloci-
| ties of the interacting waves.
|
| At the end of this file an example plot 
| command has been added.
|
| Author: T.S.
#

kdv_two := proc(x, t, c1, c2)

local e1, e2, a12, e12, f, fx, fxx;

begin
  e1  := exp(c1*x - c1^3*t):
  e2  := exp(c2*x - c2^3*t):
  a12 := ((c1-c2)/(c1+c2))^2:
  e12 := a12*e1*e2:

  f   := 1 +      e1 +        e2 +             e12:
  fx  :=   +   c1*e1 +     c2*e2 +     (c1+c2)*e12:
  fxx :=     c1^2*e1 +   c2^2*e2 +   (c1+c2)^2*e12:

  (fxx*f - fx^2)/f^2:
end_proc:

#
| example plot command
| 
| Change the asymptotic speeds (i.e. the third and
| fourth parameter of the procedure kdv_two()) to
| calculate different two soliton solutions.
#

  plot3d(Axes = None, Scaling = UnConstrained,
         [Mode = Surface,
               [u, v, hold(30*kdv_two(2*u, 2*v, 1/2, 4/5))],
               u = [-15, 15], v = [-15, 15], Grid = [50, 50],
               Smoothness = [1, 0],
               Style = [ColorPatches, AndMesh],
               Color = [Height, [0,0, 65335],[0,65335,65335]]]);
 


