#
| This file contains the definition of the procedure
| burg_two(), describing a solution of the so called
| Burgers equation. This solution shows two single
| waves merging together to a single wave.
|
| The third and fourth parameters determine the asym-
| ptotic velocities of the two waves.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

burg_two := proc(x, t, c1, c2)

local e1, e2, f, fx;

begin

  e1   := exp(c1*(x + c1*t)):
  e2   := exp(c2*(x + c2*t)):

  f    := 1 +    e1 +    e2:
  fx   :=     c1*e1 + c2*e2:

  (fx/f):

end_proc:

#
| example plot command
#

plot3d(Axes = Box, Ticks = 0,
       [Mode = Surface,
             [u, v, hold(8*burg_two(u,v,1/2,1))],
             u = [-10, 20], v = [-20, 10],
             Grid = [30, 30], Style = [ColorPatches, AndMesh]]);
