#
| This file contains the definition of the procedure
| burg_int(), describing the interacting solitons of
| the corresponding solution in example burg_two.mu.
|
| The third and fourth parameters determine the asym-
| ptotic velocities of the two waves.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

burg_int := proc(x, t, c1, c2)

local e1, e2, f, fc;

begin

  e1   := exp(c1*(x + c1*t)):
  e2   := exp(c2*(x + c2*t)):

  f    := 1 +    e1 +    e2:
  fc   :=     c1*e1:

  (fc/f):

end_proc:

#
| example plot command
| 
| Exchange the third and fourth parameter and
| you will get the second interacting soliton.
#

plot3d(Axes = Box, Ticks = 0,
       [Mode = Surface,
             [u, v, hold(8*burg_int(u,v,1,1/2))],
             u = [-10, 20], v = [-20, 10],
             Grid = [30, 30], Style = [ColorPatches, AndMesh]]);
