cube     := proc(x, y, z, edge)
begin
    polygon(point(x,y,z), point(x+edge, y, z), 
            point(x+edge, y+edge, z)),
    polygon(point(x,y,z), point(x, y+edge, z), 
            point(x+edge, y+edge, z)),
    polygon(point(x,y,z+edge), point(x+edge, y, z+edge), 
            point(x+edge, y+edge, z+edge)),
    polygon(point(x,y,z+edge), point(x, y+edge, z+edge), 
            point(x+edge, y+edge, z+edge)),
    polygon(point(x, y, z), point(x, y+edge, z),
            point(x, y+edge, z+edge)),
    polygon(point(x, y, z), point(x, y, z+edge),
            point(x, y+edge, z+edge)),
    polygon(point(x+edge, y, z), point(x+edge, y+edge, z),
            point(x+edge, y+edge, z+edge)),
    polygon(point(x+edge, y, z), point(x+edge, y, z+edge),
            point(x+edge, y+edge, z+edge)),
    polygon(point(x, y, z), point(x+edge, y, z),
            point(x+edge, y, z+edge)),
    polygon(point(x, y, z), point(x, y, z+edge),
            point(x+edge, y, z+edge)),
    polygon(point(x, y+edge, z), point(x+edge, y+edge, z),
            point(x+edge, y+edge, z+edge)),
    polygon(point(x, y+edge, z), point(x, y+edge, z+edge),
            point(x+edge, y+edge, z+edge))
end_proc:

cube_rec := proc(x, y, z, edge, n)
local newx, newy, newz, new_edge;
begin
    if  n = 0 then
        cube(x, y, z, edge):
    else
       new_edge := edge/3.0:
       cube_rec(x, y, z, new_edge, n-1),
       cube_rec(x+2*new_edge, y, z, new_edge, n-1),
       cube_rec(x, y, z+2*new_edge, new_edge, n-1),
       cube_rec(x+2*new_edge, y, z+2*new_edge, new_edge, n-1),
       cube_rec(x, y+2*new_edge, z, new_edge, n-1),
       cube_rec(x+2*new_edge, y+2*new_edge, z, new_edge, n-1),
       cube_rec(x, y+2*new_edge, z+2*new_edge, new_edge, n-1),
       cube_rec(x+2*new_edge, y+2*new_edge, z+2*new_edge, new_edge, n-1),
       cube_rec(x+new_edge, y+new_edge, z+new_edge, new_edge, n-1);
    end_if:
end_proc:

plot3d(Axes = None, CameraPoint = [0.5, -1.0, 0.5],
       [Mode = List, [cube_rec(0,0,0,1,2)]]);
