#
| This file contains the definitions of the three
| procedures hel_x(), hel_y() and hel_z(), descri-
| bing the coordinates of a threedimensional mini-
| mal surface, the so called helicoid.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

hel_x := proc(u, v, alpha, theta)
begin
  alpha*cosh(u)*cos(v)*cos(theta) + alpha*sinh(u)*sin(v)*sin(theta):
end_proc:

hel_y := proc(u, v, alpha, theta)
begin
  -alpha*cosh(u)*sin(v)*cos(theta) + alpha*sinh(u)*cos(v)*sin(theta):
end_proc:

hel_z := proc(u, v, alpha, theta)
begin
  3*alpha*u*cos(theta) + 3*alpha*v*sin(theta):
end_proc:

#
| example plot command
|
| Change the fourth parameter of the functions
| and you will get a catenoid.
#

plot3d(Axes = None, Scaling = UnConstrained,
       [Mode = Surface,
             [hold(hel_x(u,v,1,PI/2)),
              hold(hel_y(u,v,1,PI/2)),
              hold(hel_z(u,v,1,PI/2))],
              u = [-PI,PI], v= [-PI,PI],
              Grid = [30,30], Style = [ColorPatches, AndMesh]
       ]);

