#
| This file contains the definitions of the three
| procedures ennr_x(), ennr_y() and ennr_z(), des-
| cribing the coordinates of higher order minimal
| surfaces, called higher order Enneper minimal
| surfaces.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

#
| We use the following files
#

read("complex.mu"):
read("radial.mu"):

ennr_x := proc(u,v,n)
local w;
begin
  w := u + I*v:
  real(0.5*(w-w^(2*n+1)/(2*n+1))):
end_proc:

ennr_y := proc(u,v,n)
local w;
begin
  w := u + I*v:
  real(0.5*I*(w+w^(2*n+1)/(2*n+1))):
end_proc:

ennr_z := proc(u,v,n)
local w;
begin
  w := u + I*v:
  real((w^(n+1))/(n+1)):
end_proc:

#
| example plot command
|
| Change the third parameter and you will
| get higher order Enneper surfaces.
#

 plot3d(Axes = None, Scaling = UnConstrained,
        [Mode = Surface, 
              [hold(ennr_x(U(u,v),V(u,v),1)),
               hold(ennr_y(U(u,v),V(u,v),1)),
               hold(ennr_z(U(u,v),V(u,v),1))
              ],
             u = [0,PI], v = [-1.2, 1.2],
             Grid = [30, 30], Smoothness = [0, 0],
             Color = [Height, [65335,0,0],[65335,40000,0]],
             Style = [ColorPatches, AndULine]]);

