#
| This file contains the definitions of the three
| procedures cat_x(), cat_y() and cat_z(), descri-
| bing the coordinates of a minimal surface, the 
| so called catenoid.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

cat_x := proc(u, v, alpha, theta)
begin
  alpha*cosh(u)*cos(v)*cos(theta) + alpha*sinh(u)*sin(v)*sin(theta):
end_proc:

cat_y := proc(u, v, alpha, theta)
begin
  -alpha*cosh(u)*sin(v)*cos(theta) + alpha*sinh(u)*cos(v)*sin(theta):
end_proc:

cat_z := proc(u, v, alpha, theta)
begin
  3*alpha*u*cos(theta) + 3*alpha*v*sin(theta):
end_proc:

#
| example plot command
| creates a 3d-image of a catenoid.
|
| Change the fourth parameter from 0
| to PI/2 and you will get a helicoid.
#

plot3d(Axes = None, Scaling = UnConstrained,
       [Mode = Surface,
             [hold(cat_x(u,v,1,0)),
              hold(cat_y(u,v,1,0)),
              hold(cat_z(u,v,1,0))],
              u = [-PI,PI], v= [-PI,PI],
              Grid = [30,30], Style = [ColorPatches, AndMesh]
       ]);

