tree := proc(x1, y1, x2, y2, angle, delta_length, n)
local length, x3, y3, x4, y4, old_angle;
begin
    if n = 0 then
        polygon(point(x1, y1), point(x2, y2));
    else
        length := sqrt((x1-x2)^2+(y1-y2)^2)*delta_length:
        old_angle := winkel(x1,y1, x2, y2);
        x3     := x2 + delta_length*length*cos(old_angle-angle);
        y3     := y2 + delta_length*length*sin(old_angle-angle);
        x4     := x2 + delta_length*length*cos(old_angle+angle);
        y4     := y2 + delta_length*length*sin(old_angle+angle):
        tree(x1, y1, x2, y2, 0, 0, 0), 
        tree(x2, y2, x3, y3, angle, delta_length, n-1),
        tree(x2, y2, x4, y4, angle, delta_length, n-1);
    end_if:
end_proc:

winkel := proc(x1, y1, x2, y2)
local lengthx, lengthy, lenght, winkel;
begin
  lengthx := (x2-x1):
  lengthy := (y2-y1):
  length  := sqrt(lengthx^2 + lengthy^2):
  if lengthy <> 0 then
      winkel  := sign(lengthy)*acos(float(lengthx/length)):
  else
      winkel  := acos(float(lengthx/length)):
  end_if:
end_proc:

plot2d(Axes = None,
       [Mode=List,[tree(0,0,0,0.5,float(PI/7), 0.8, 10)],
       Color = [Height, [0,0,1], [0,1,0]]]);
