#
| user-defined pointlists
#

sierpinski_triangle := proc(pointa, pointb, pointc, n)
local x, y, newpointa, newpointb, newpointc;
begin
    if n = 0 then
        polygon(pointa, pointb, pointc, Filled = TRUE):
    else
        x := op(pointa,1) + (op(pointb,1) - op(pointa,1))/2:
        y := op(pointa,2) + (op(pointb,2) - op(pointa,2))/2:
        newpointa := point(x,y):
        x := op(pointb,1) + (op(pointc,1) - op(pointb,1))/2:
        y := op(pointb,2) + (op(pointc,2) - op(pointb,2))/2:
        newpointb := point(x,y):
        x := op(pointc,1) + (op(pointa,1) - op(pointc,1))/2:
        y := op(pointc,2) + (op(pointa,2) - op(pointc,2))/2:
        newpointc := point(x,y):
        sierpinski_triangle(pointa, newpointa, newpointc, n-1),
        sierpinski_triangle(pointb, newpointb, newpointa, n-1),
        sierpinski_triangle(pointc, newpointc, newpointb, n-1):
    end_if:
end_proc:
       
a := point(-1, 0):
b := point( 1, 0):
c := point( 0, 2):

plot2d(Axes = None,
            [Mode = List, [sierpinski_triangle(a, b, c, 7)],
             Color = [Height]
            ]);
