
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define RETURN_STR "\255\128"
extern int errno;
extern char *sys_errlist[];

int main(int argc, char *argv[])
{
	struct sockaddr_in sin;
	struct hostent *phe;
	struct servent *pse;
	struct protoent *ppe;
	int s;
	char buf[512];
	int size;
	fd_set fdvar;
	struct timeval tv;
	
	char hostname[64] = "127.0.0.1";
	char port[20] = "9006";
	
	switch (argc) {
		case 3:
			strncpy(port, argv[2], 20);
			/* fal through */
		case 2:
			strncpy(hostname, argv[1], 64);
			break;
		case 1:
			break;
		default:
			printf("Usage %s [[<hostname>] <port>]\n", argv[0]);
			exit(1);
			break;
	}

	if ( (phe = gethostbyname(hostname)) != NULL)	
		bcopy(phe->h_addr, (char*)&sin.sin_addr, phe->h_length);
	else if ( (sin.sin_addr.s_addr = inet_addr(hostname)) == INADDR_NONE)
		{
			fprintf(stderr, "%s: Cannot resolve hostname %s. (%s)\n", argv[0], hostname, sys_errlist[errno]);
			exit(1);
		}
					
	if ( (pse = getservbyname(port, "tcp")) != NULL)
		sin.sin_port = pse->s_port;
	else if ( (sin.sin_port = htons((u_short)atoi(port))) == 0)
		{
			fprintf(stderr, "%s: Cannot find port %s. (%s)\n", argv[0], port, sys_errlist[errno]);
			exit(1);
		}
		
	if( (ppe = getprotobyname("udp")) == 0)
	{
		perror("getprotobyname");
		exit(1);
	}
	
	if( (s = socket(PF_INET, SOCK_DGRAM, ppe->p_proto)) < 0)
	{
		perror("socket");
		exit(1);
	}
	

	printf("RSPF Daemon Client v0.2, Copyright (C) 1995 Craig Small vk2xlz\n");
	printf("rspfc comes with ABSOLUTELY NO WARRANTY\n");
	printf("This is free software, and you are welcome to redistribute it\n");
	printf("under certain conditions outlined in GNU General Public License\n\n");
	printf("Using server %s:%s\n", hostname, port);
	
	while(1)
	{
		printf(">");
		fgets(buf, 512, stdin);
		sendto(s, buf, strlen(buf), 0, (struct sockaddr*)&sin, sizeof(sin));
		
		/* Read the response */
		while(1)
		{
			FD_ZERO(&fdvar);
			FD_SET(s, &fdvar);
			
			tv.tv_sec = 30;
			tv.tv_usec = 0;
			
			if (select(s+1, &fdvar, (fd_set*)NULL, (fd_set*)NULL, &tv) < 0)
				continue;
			
			if (FD_ISSET(s, &fdvar))
			{
				if ( (size = read(s, buf, 512)) < 0)
				{
					printf("No response from server\n");
					break;
				}
			
				if (strncmp(RETURN_STR, buf, 2) == 0)
					break;
				puts(buf);				
			} else {
				printf("Server response timed out\n");
				close(s);
				return 0;
			}
		}
	}
	close(s);
}
	
	