/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.1                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/30/95                                             */
/* Description  : all functions for the file-selector                  */
/*                                                                     */
/* Functions    : grav_file_selector()                                 */
/*                grav_draw_selector()                                 */
/*                grav_undraw_selector()                               */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <ncurses.h>
#include "standard.h"
#include "gbm.h"
#include "defines.h"
#include "keys.h"

int grav_draw_selector(int, int, int, int, DIRTAB []);
int grav_undraw_selector(int, int, int, int, DIRTAB []);


int grav_file_selector(int use_color, int *page, int max_files, int *index, int *count_tagged, DIRTAB dirtab[])
{
   int  local;
   int  key;
   int  line;
   int  column;
   int  rc;
   int  loop_again;
   int  window_flag;
   char temp[21];

   loop_again    = TRUE;
   window_flag   = FALSE;
 
   /*
    * here we calculate the line and column of the file at we will
    * put the selector
    */
    
   local = *index - ((*index / 28) * 28);
   line  = local / 2;
   
   if (line * 2 == local)
      column = POS_LEFT;
   else
      column = POS_RIGHT;

   
   /*
    * and from here, we will do a loop and get every key pressed....
    */
    
   do
   {
      grav_draw_selector(use_color, line, column, *index, dirtab);
      refresh();
      
      key = getch();
      
      grav_undraw_selector(use_color, line, column, *index, dirtab);

      if (window_flag == FALSE)
      {
         if (use_color)
            attron(COLOR_PAIR(WHITE_ON_BLUE));
         else
            attroff(A_REVERSE);
            
         mvaddstr(17,53,"                        ");
         mvaddstr(18,53,"                        ");
         mvaddstr(19,53,"                        ");
         mvaddstr(20,53,"                        ");
         mvaddstr(21,53,"                        ");
         window_flag = TRUE;
      }
      
      switch(key)
      {
      case 9:         rc         = DO_INPUT;
                      loop_again = FALSE;
                      break;

      case KEY_F(1):  rc         = DO_HELP;
                      loop_again = FALSE;
                      break;
      
      
      case KEY_m:
      case KEY_M:
      case 43:        rc         = DO_INC_MODE;
                      loop_again = FALSE;
                      break;

      case 45:        rc         = DO_DEC_MODE;
                      loop_again = FALSE;
                      break;
      
      case KEY_i:
      case KEY_I:     if (dirtab[*index].filetype == IS_FILE)
                      {
                         rc         = DO_INFO;
                         loop_again = FALSE;
                      }
                      break;

      case KEY_p:
      case KEY_P:     rc         = DO_PRINT;
                      loop_again = FALSE;
                      break;

      case KEY_F(10):
      case KEY_q:
      case KEY_Q:     rc         = DO_QUIT;    
                      loop_again = FALSE;
                      break;

      case KEY_IC:
      case KEY_SPACE: if (dirtab[*index].filetype != IS_DIRECTORY)
                      {
                         if (dirtab[*index].tagged == TRUE)
                         {
                            dirtab[*index].tagged = FALSE;
                            *count_tagged = *count_tagged - 1;
                         }
                         else
                         {
                            dirtab[*index].tagged = TRUE;
                            *count_tagged = *count_tagged + 1;
                         }
                         
                         grav_undraw_selector(use_color, line, column, *index, dirtab);
                      }
                      /*
                       * here we will put _NO_ break!! the fileselector
                       * will be moved one file down if we tagged a file
                       */
                  
      case KEY_DOWN:  
      case      106:                
      case       74:  if (*index + 2 <= max_files - 1)
                      {
                         *index = *index + 2;
                         line++;
                      }
                      if (line > 13)
                      {
                         *page = *page + 1;
                         line = 0;
                         grav_show_directory(use_color, *page, max_files, dirtab);
                      }
                      break;
      
      case KEY_UP:    
      case    107:                
      case     75:    if (*index - 2 >= 0)
                      {
                         *index = *index - 2;
                         line--;
                      }
                      if (line < 0)
                      {
                         *page = *page - 1;
                         line = 13;
                         grav_show_directory(use_color, *page, max_files, dirtab);
                      }                      
                      break;
      
      case KEY_LEFT:  
      case      104:  
      case       72:  if (column == POS_RIGHT)
                      {
                         *index = *index -1;
                         column = POS_LEFT;
                      }
                      break;
      
      case KEY_RIGHT: 
      case       108:               
      case        76: if (column == POS_LEFT)
                      {
                         if (*index + 1 <= max_files - 1)
                         {
                            *index = *index + 1;
                            column = POS_RIGHT;
                         }
                      }
                      break;   

      case KEY_ENTER: if (dirtab[*index].filetype == IS_DIRECTORY)
                         rc = DO_CHDIR;
                      else
                      {
                         if (*count_tagged == 0)
                         {
                            *count_tagged         = 1;
                            dirtab[*index].tagged = TRUE;
                         }
                         rc = DO_VIEW;
                      }
                      loop_again = FALSE;
                      break;
      }
   
   }
   while(loop_again == TRUE);

   return(rc);
}

int grav_draw_selector(int use_color, int line, int column, int index, DIRTAB dirtab[])
{
   char temp[21];
   
   strcpy(temp, " ");

   if (dirtab[index].filetype == IS_DIRECTORY)
   {
      strcat(temp,"<");
      strncat(temp,dirtab[index].filename,18);
      strcat(temp,">");
   }
   else
   {
      strncat(temp,dirtab[index].filename,20);
   }

   if(strlen(temp)<20)
      strncat(temp,BLANK60,21-strlen(temp));   

   strcat(temp, " ");

   if (dirtab[index].tagged == FALSE)
   {
      if (use_color)
         attron(COLOR_PAIR(WHITE_ON_BLACK));
      else
         attron(A_NORMAL);
         
      mvaddstr(line+8, column-1, temp);
   }
   else
   {
      attron(A_BOLD);
      
      if (use_color)
         attron(COLOR_PAIR(YELLOW_ON_BLACK));
      else
         attron(A_NORMAL);
         
      mvaddstr(line+8, column-1, temp);
      attroff(A_BOLD);
   }

   return(TRUE);
}

int grav_undraw_selector(int use_color, int line, int column, int index, DIRTAB dirtab[])
{
   char temp[21];
   
   strcpy(temp, " ");
      
   if (dirtab[index].filetype == IS_DIRECTORY)
   {
      strcat(temp,"<");
      strncat(temp,dirtab[index].filename,18);
      strcat(temp,">");
   }
   else
   {
      strncat(temp,dirtab[index].filename,20);
   }

   if(strlen(temp)<20)
      strncat(temp,BLANK60,21-strlen(temp));
                 
   strcat(temp, " ");

   if (dirtab[index].tagged == FALSE)
   {
      if (use_color)
         attron(COLOR_PAIR(BLACK_ON_CYAN));
      else
         attron(A_REVERSE);
         
      mvaddstr(line+8, column-1, temp);
   }
   else
   {
      attron(A_BOLD);
      
      if (use_color)
         attron(COLOR_PAIR(YELLOW_ON_CYAN));
      else
         attron(A_REVERSE);
         
      mvaddstr(line+8, column-1, temp);
      attroff(A_BOLD);
   }

   if (use_color == FALSE)
      attroff(A_REVERSE);

   return(TRUE);
}
