#
# This is Makefile, part of the source code for
#
# BMV version 1.1
# copyright by Jan Kybic, 26th July 1994
#
# modified by wbader@csee.lehigh.edu
#
# Jan Kybic, Prosecka 681, Praha 9, Czech Republic, <kybic@earn.cvut.cz>
#                                   or temporarily  <jkybic@vipunen.hut.fi>
#
# BMV is a very simple viewer of images in the pbm(5)-raw format
#     and front end for GhostScript		
#     based on Svgalib library for Linux
#
# BMV is distributed under GNU GPL (General Public License),
#   you can obtain a copy from many FTP sites if you are interested in details
#
#
#
#
#
# This Makefile is really a simple one, but no complexity is needed.
# You must be root and you must be in the source code directory.
# Type  'make bmv' or 'make all' if you want to build BMV.
# After you have tried it, type 'make install' and it sets the sticky bit
# on it and moves the binary to DESTDIR
# If you enter 'make clean' it removes the object files

SOURCES=bmv.c displ.c gsinterf.c vgasco.c console.c
OBJECTS=bmv.o displ.o gsinterf.o vgasco.o console.o
HEADERS=bmv.h

SRCDIR=bmv-1.0a
# DESTDIR=/usr/bin
DESTDIR=/usr/local/bin

GSNAME=/u/william/gs3.22/gs.gcc
GSDIR=/u/william/gs3.22

CC=gcc -m486 -I. \
	-Wall -Wtraditional -Wpointer-arith -Wcast-qual -Wwrite-strings \
	-Wmissing-prototypes -Wnested-externs \
	-DGSNAME=\"$(GSNAME)\" -DGSDIR=\"$(GSDIR)\" -DUSE_WIN=0 -DWIN_USE_CONSOLE=1 \
	-Dboolean=int
DEFS=LINUX
CFLAGS= -O3 -m486 -fomit-frame-pointer
# CFLAGS= -g
# LIBS= -lvga
LIBS= -lx -lm -lmalloc -lsc_s -lc_s -Xlinker -z

# build the program
#all:	bmv clean
all:	bmv

# install the program
install: bmv clean
	chmod +s bmv
	mv bmv /usr/bin/bmv
	
# linking
bmv:  	$(OBJECTS)
	$(CC) $(CFLAGS) -o bmv $(OBJECTS) $(LIBS)

# Clean removes objects
clean:	
	rm *.o

$(OBJECTS): 	$(HEADERS)
