#  LAST EDIT: Fri Apr 15 14:19:44 1994 by ekki(@prakinf.tu-ilmenau.de)

set DATE "15/04/94"
set RELEASE "0.70"

# constructor commands:

#default:
set CMD {} 

if {$CLASS == "Ellipsoid"} { set CMD {1 1 1} }
if {$CLASS == "Sphere"} { set CMD {1} }
if {$CLASS == "Spline"} { set CMD {1 {{0 0 0}} {} {}} }
if {$CLASS == "Plane"} { set CMD {1 2 3 4} }
if {$CLASS == "Polygon"} { set CMD {1 {{0 0 0}} {} {}} }
if {$CLASS == "Polymarker"} { set CMD {1 {{0 0 0}} {} {}} }
if {$CLASS == "Polyline"} { set CMD {1 {{0 0 0}} {} {}} }
if {$CLASS == "Polyhedra"} { set CMD {1 3 {{0 1 2}} {{0 0 0} {0 0 0} {0 0 0}} {} {}} }
if {$CLASS == "OFFPolygon"} { set CMD ignore } 
if {$CLASS == "OFFQuadmesh"} { set CMD ignore } 
if {$CLASS == "Quader"} { set CMD {1 1 1} } 
if {$CLASS == "Quadmesh"} { set CMD { 1 1 {{0 0 0}} {} {} }} 
if {$CLASS == "Quadric"} { set CMD {{1 1 1} {0 0 0} {0 0 0} -1} } 
if {$CLASS == "OneRayCamera"} { set CMD {{0 0 5} {0 0 -1}} }
if {$CLASS == "LookatCamera" || $CLASS == "RayImageLookatCamera"} { set CMD {{1 1 1} {0 0 0}} }
if {$CLASS == "ImageRecorder"} { set CMD {fuck} }
if {$CLASS == "PixmapDisplay"} { set CMD {1 1} }
if {$CLASS == "FileDevice"} { set CMD {0 0} }
if {$CLASS == "Torus"} { set CMD {1 1} }
if {$CLASS == "Cone"} { set CMD {1 1} }
if {$CLASS == "OBAPrimitive"} { set CMD {ignore} }
if {$CLASS == "Cylinder"} { set CMD {1 1} }
if {$CLASS == "SGIImage"} { set CMD noname.rgb }
if {$CLASS == "TargaImage"} { set CMD noname.tga }
if {$CLASS == "Text"} { set CMD {Hi { 0 0 0} }}
if {$CLASS == "UniColorTexture" || $CLASS == "NoiseTexture" } { set CMD {{ 0 0 0} }}
if {$CLASS == "TruncTexture"} { NoiseTexture t1 { 1 1 1 }; set CMD {t1}}
if {$CLASS == "WoodTexture" || $CLASS == "TurbulenceTexture" || $CLASS == "CheckerTexture" || $CLASS == "GridTexture" || $CLASS == "InterpolationTexture" || $CLASS == "MarbleTexture" } { 
    NoiseTexture t1 {1 1 1}; set CMD {t1 t1}
}
if {$CLASS == "XLinearMarbleTexture" || $CLASS == "XCubicMarbleTexture" } {
    NoiseTexture t1 { 1 1 1}; set CMD {t1 t1 t1 t1}
}
if {$CLASS == "IOM_Pixmap"} {set CMD {. fill}}

catch "source $env(GOOD_ROOT_DIR)/packages/scient/bin/document.tcl"

# general stuff:

proc getData {} {
    global CMD CLASS CONSTRUCTOR DESCRIPTION METHODS KEYWORDS
    set CONSTRUCTOR [$CLASS ?]
    eval "$CLASS _object $CMD"
    set METHODS [_object ?]
    set DESCRIPTION [_object -get_description]
    set KEYWORDS [_object -get_keywords]
}

proc getParams {param desc} {
    set name {}
    set d {}
    # remove "."  "," ";" ":":
    foreach w [split $desc {, . ;}] { set d "$d $w" }
    set l {}
    set i 1
    foreach p $param {
	# find symbolic name of the parameter:
	foreach w $d {
	    if {[llength $w ] > 2 
		&& [lindex $w 0] == "ARG"
		&& [lindex $w 1] == $i
	    } { set name [lindex $w 2] }
	}
	set l "$l $name\[$p\]"
	incr i 
    }
    return $l
}

proc getDescription desc {
  set result {}
  while 1 {
    set pos [string first "\{" $desc ]
    if {$pos > -1 } {
      set result "$result {0 {[string range $desc 0 [expr $pos-1]]}}"
      set pos2 [string first "\}" $desc ]
      set tmp [string range $desc [expr $pos+1] [expr $pos2-1]]
	set result "$result {1 {[lindex $tmp 2]}}"
        set desc [string range $desc [expr $pos2+1] [expr [string length $desc]-1]]
    } { return "$result {0 {$desc}}" }
  }
}

# output dependend stuff:

############# NROFF ##################

proc nroffMthd { f desc} {
    foreach d $desc {
	if {[lindex $d 0] == 1 } {puts $f "\\fB[lindex $d 1]\\fR" nonewline } {
	    puts $f [lindex $d 1]  nonewline }
    }
    puts $f ""
}

proc nroffParams {f params} {
  foreach p $params { puts $f ".I $p" }
}
 
proc 2nroff {} {
    global CLASS CONSTRUCTOR DESCRIPTION METHODS KEYWORDS RELEASE DATE
    set f stdout
    puts $f ".TH \"$CLASS\" YART \"$DATE\" \"YART \- Release $RELEASE\""
    puts $f ".if n .nr I 2"
    puts $f "Save paper! Don't print out this manpage.\n\n"
    puts $f ".SH CLASS\n$CLASS"
    puts $f ".SH DESCRIPTION\n$DESCRIPTION\n"
    puts $f ".SH CONSTRUCTOR\(S\)"
    foreach mthd $CONSTRUCTOR {
	puts $f ".PP\n.SS $CLASS"
	puts $f ".I $CLASS"
	nroffParams $f [getParams [lindex $mthd 1] [lindex $mthd 2]]
	puts $f ""
	nroffMthd $f [getDescription [lindex $mthd 2]]
    }
    puts $f ".SH METHODS\(S\)"
    foreach mthd $METHODS {
	puts $f ".PP\n.SS [lindex $mthd 0]"
	puts $f ".PP\n.I <obj> [lindex $mthd 0]"
	nroffParams $f [getParams [lindex $mthd 1] [lindex $mthd 2]]
	puts $f ""
	nroffMthd $f [getDescription [lindex $mthd 2]]
    }
    puts $f ".SH KEYWORDS\n[lsort $KEYWORDS]\n"
    puts $f ".SH AUTHOR\n.LP\nekki@prakinf.tu-ilmenau.de"
}

############# HTML ##################

proc htmlMthd { f desc} {
    foreach d $desc {
	if {[lindex $d 0] == 1 } {puts $f "*[lindex $d 1]*" } {
	    puts $f [lindex $d 1] }
    }
}

proc htmlParams {f params} {
  foreach p $params { puts $f "$p" }
}
 
proc 2html {} {
    global CLASS CONSTRUCTOR DESCRIPTION METHODS KEYWORDS
    set f stdout
    puts $f "<TITLE>YART class $CLASS</TITLE>"
    puts $f "The YART class $CLASS"
    puts $f "<H1>DESCRIPTION</H1>\n$DESCRIPTION\n"
    puts $f "<H1>CONSTRUCTOR(S)</H1>"
    foreach mthd $CONSTRUCTOR {
	puts $f "<H2>$CLASS</H2>"
	puts $f "<H3>$CLASS"
	htmlParams $f [getParams [lindex $mthd 1] [lindex $mthd 2]]
	puts $f "</H3>\n<P>"
	htmlMthd $f [getDescription [lindex $mthd 2]]
    }
    puts $f "<H1>METHODS(S)</H1>"
    foreach mthd $METHODS {
	puts $f "<H2>[lindex $mthd 0]</H2>"
	puts $f "<H3> <obj> [lindex $mthd 0]"
	htmlParams $f [getParams [lindex $mthd 1] [lindex $mthd 2]]
	puts $f "</H3>"
	htmlMthd $f [getDescription [lindex $mthd 2]]
    }
    puts $f "<H1>KEYWORDS</H1>\n[lsort $KEYWORDS]\n"
    puts $f "<H1>AUTHOR\n</H1>\nekki@prakinf.tu-ilmenau.de"
}

###########################################################################################################

getData

if {$MODE == "NROFF"} 2nroff
if {$MODE == "HTML"} 2html

exit
