#
# Copyright (c) 1993 Eric Schenk.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
# SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
#

tkwm_widget::setdefaults toplevel icontoplevel {
    {-width width Width 64}
    {-height height Height 64}
    {-bitmap bitmap Bitmap {}}
    {-manager manager Manager tkwmDefaultIconManager}
    {-opaqueMove opaqueMove OpaqueMove 0}
    {-opaqueResize opaqueResize OpaqueResize 0}
    {-constrained constrained Constrained 0}
}

proc icontoplevel {var args} {
    tkwm_widget::initialconfigure icontoplevel Icon $var args
    return $var
}

proc icontoplevel::create {var} {
    upvar "#0" $var data
    bind $var <Destroy> [list icontoplevel::destroy $var]
    set data(mapped) 0
}

proc icontoplevel::destroy {var} {
    upvar "#0" $var data
    catch {$data(-manager) remove $var}
    tkwm_widget::destroy $var
}

proc icontoplevel::command-map {var args} {
    upvar "#0" $var data
    set data(mapped) 1
    $data(-manager) map $var
}

proc icontoplevel::command-unmap {var args} {
    upvar "#0" $var data
    set data(mapped) 0
    $data(-manager) unmap $var
}

proc icontoplevel::config-opaqueMove {var option} {}
proc icontoplevel::config-opaqueResize {var option} {}
proc icontoplevel::config-constrained {var option} {}
proc icontoplevel::config-use_WM_STATE {var option} {}
proc icontoplevel::config-manager {var option} {
    upvar "#0" $var data
    catch {$data(-manager) remove $var}
    set data(-manager) $option
    if $data(mapped) {$data(-manager) map $var}
}
proc icontoplevel::config-height {var option} {
    upvar "#0" $var data
    wm geometry $var $data(-width)x$option
    update
    $data(-manager) refresh $var
}
proc icontoplevel::config-width {var option} {
    upvar "#0" $var data
    wm geometry $var ${option}x$data(-height)
    update
    $data(-manager) refresh $var
}
proc icontoplevel::config-bitmap {var option} {
    catch {
	$var.plug.label config -bitmap $option
    }
}

proc make_icon_plug {name} {
    upvar "#0" $name icondata
    upvar "#0" $icondata(root) data


    handleError {
	set icon_window [$icondata(root-plug) info icon_window]
	set icon_pixmap [$icondata(root-plug) info icon_pixmap]
    } {
	# this client is an internal window, not a client
	# we can't do icon window's for internal clients right now...
	set icon_window ??
	set icon_pixmap [wm iconbitmap $icondata(root)]
    }

    if {$icon_window != "??"} {
	tkwm plug $name.plug $icon_window -setgrid 1
        $icondata(root-plug) configure -iconwin $icon_window
    } else {
	# adjust the width and height to account for the 1 pixel border
        # the label widget will force on us.
        wm grid $name 0 0 1 1
	set bitmap [get_resource_value $name bitmap Bitmap]
	if {$bitmap == ""} {set bitmap $icon_pixmap}
	if {$bitmap == ""} {set bitmap question}
        frame $name.plug
	handleError {
	    label $name.plug.label -bor 0 -padx 0 -pady 0 -bitmap $bitmap
	} {
	    label $name.plug.label -bor 0 -padx 0 -pady 0 -bitmap question
	}
	place $name.plug.label -relx 0.5 -rely 0.5 -anchor c
    }
}

proc create_icon_window {client} {
    upvar #0 $client data
    set name $data(res_name).icon
    upvar #0 $name icondata
    set data(icon) $name
    set data(icon.decoration) $name.decoration
    set icondata(root) $client
    set icondata(root-plug) $client.plug
    set icondata(decoration) $name.decoration
    set icondata(res_name) $name

    handleError {
	set icon_name [$client.plug info icon_name]
	set icon_x [$client.plug info icon_x]
	set icon_y [$client.plug info icon_y]
    } {
	# This is an internal client
	set icon_name [wm iconname $client]
        set icon_x ??
	set icon_y ??
	scan [wm iconposition $client] icon_x icon_y
    }

    icontoplevel $name
    wm withdraw $name
    handleError {
	set inside [tkwm_icon_frame $icondata(decoration) \
			-title $icon_name]
    } {
	catch {destroy $icondata(decoration)}
	set inside [frame $icondata(decoration) \
			-relief ridge \
			-borderwidth 5 \
			-cursor "top_left_arrow"]
	tkerror "User icon decoration code failed"
    }
    make_icon_plug $name
    pack $icondata(decoration) -expand 1 -fill both
    pack $name.plug -in $inside -expand 1 -fill both

    set width [get_resource_value $name width Width]
    set height [get_resource_value $name height Height]

    if {$icon_x!="??" && $icon_y!="??"} {
	wm geometry $name ${width}x$height+$icon_x+$icon_y
    } else {
	wm geometry $name ${width}x$height+[winfo rootx $client]+[winfo rooty $client]
    }
    noisyCatch {icon_bindings $name}

    # make sure the icon size is known.
    update idletasks
}
