/* Copyright (c) 1992 Regents of the University of California */
#ifndef lint
static char SCCSid[] = "@(#)ra_skel.c 2.4 12/17/92 LBL";
#endif
/*  Philip R. Thompson, 4/93
 *  Computer Resource Lab.
 *  School of Architecture and Planning, MIT
 *  Quick an dirty jof of converting Radiance images to the
 *  Utah Raster Toolkit format (rle).
 *  Note: No support for comments although both file formats support
 *  them.
 */
#define RLELIB
#include  <stdio.h>
#include  "color.h"
#include  "resolu.h"
#ifdef RLELIB
#include "rle.h"
#endif
#include "standard.h"

static double  gam = 2.2;           /* gam correction */
static int  bradj = 0;              /* brightness adjustment */
static char  *progname = NULL;
static int  xmax, ymax;


static void quiterr(err)        /* print message and exit */
char  *err;
{
    if (err != NULL)
        fprintf(stderr, "%s: %s\n", progname, err);
    exit(1);
}

/* convert 24-bit scanlines to Radiance pic */
static int Rle2Ra(argc, argv)
int argc;
char **argv;
{
    register int x, y, xmax, ymax;
    rle_hdr in_globals;
    rle_pixel **rows;
    COLR *scanout;

    bzero((char*)&in_globals, sizeof(rle_hdr));
    in_globals.rle_file = stdin;
    if (rle_get_setup(&in_globals) < 0)
        quiterr("Rle2Ra: can't read rle setup information");
    xmax = in_globals.xmax - in_globals.xmin + 1;
    ymax = in_globals.ymax - in_globals.ymin + 1;
    if (rle_row_alloc(&in_globals, &rows))
        quiterr("Rle2Ra: rle_row_alloc() failed.");

    /* put our header */
    printargs(argc, argv, stdout);
    fputformat(COLRFMT, stdout);
    putchar('\n');
    fprtresolu(xmax, ymax, stdout);
    /* allocate scanline */
    if ((scanout = (COLR *)malloc(xmax*sizeof(COLR))) == NULL)
        quiterr("out of memory in Rle2Ra");
    /* convert image */
    for (y = ymax-1; y >= 0; y--) {
        rle_getrow(&in_globals, rows);
        for (x = 0; x < xmax; x++) {
            scanout[x][RED] = rows[RLE_RED][x];
            scanout[x][GRN] = rows[RLE_GREEN][x];
            scanout[x][BLU] = rows[RLE_BLUE][x];
        }
        if (feof(stdin) || ferror(stdin))
            quiterr("error reading rle image");
        /* undo gam */
        gambs_colrs(scanout, xmax);
        if (bradj)          /* adjust exposure */
            shiftcolrs(scanout, xmax, bradj);
        if (fwritecolrs(scanout, xmax, stdout) < 0)
            quiterr("error writing Radiance picture");
    }
    /* free scanline */
    free((char *)scanout);
    rle_row_free(&in_globals, rows);
    return 1;
}


static int Ra2Rle()     /* convert Radiance data to 24-bit Utah rle */
{
    register int x, y;
    register COLR *scanin;
    rle_pixel **rows;
    rle_hdr out_globals;

    /* allocate scanline */
    if ((scanin = (COLR *)malloc(xmax*sizeof(COLR))) == NULL)
        quiterr("out of memory in Ra2Rle");

    /* Intialize and setup rle header */
    bzero(&out_globals, sizeof(rle_hdr));
    out_globals.xmax = xmax - 1;
    out_globals.ymax = ymax - 1;
    out_globals.rle_file = stdout;
    out_globals.ncmap = 0;
    out_globals.ncolors = 3;
    for (x = 0; x < out_globals.ncolors; x++)
        RLE_SET_BIT(out_globals, x);
    out_globals.comments = NULL;
    if (rle_row_alloc(&out_globals, &rows)) {
        quiterr("Ra2Rle: rle_row_alloc failed");
        return 0;
    }
    rle_put_setup(&out_globals);        /* write out the header */

    /* convert image */
    for (y = ymax-1; y >= 0; y--) {
        if (freadcolrs(scanin, xmax, stdin) < 0)
            quiterr("error reading Radiance picture");
        if (bradj)                      /* adjust exposure */
            shiftcolrs(scanin, xmax, bradj);
        colrs_gambs(scanin, xmax);      /* gam correction */
        for (x = 0; x < xmax; x++) {
            rows[RLE_RED][x] = scanin[x][RED];
            rows[RLE_GREEN][x] = scanin[x][GRN];
            rows[RLE_BLUE][x] = scanin[x][BLU];
        }
        rle_putrow(rows, xmax, &out_globals);
        if (ferror(stdout))
            quiterr("error writing skel file");
    }
    rle_puteof(&out_globals);
    rle_row_free(&out_globals, rows);
    if (out_globals.priv.put.brun)
        free((char*)out_globals.priv.put.brun);
    if (out_globals.bg_color)
        free((char*)out_globals.bg_color);
    if (out_globals.cmap)
        free((char*)out_globals.cmap);
    free((char *)scanin);
    return 1;
}


main(argc, argv)
int  argc;
char  *argv[];
{
    int  i, reverse = 0;
    
    progname = argv[0];
    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
            switch (argv[i][1]) {
            case 'g':       /* gam correction */
                gam = atof(argv[++i]);
                break;
            case 'e':       /* exposure adjustment */
                if (argv[i+1][0] != '+' && argv[i+1][0] != '-')
                    goto userr;
                bradj = atoi(argv[++i]);
                break;
            case 'r':       /* reverse conversion */
                reverse = 1;
                break;
            default:
                goto userr;
            }
        else
            break;

    if (i < argc-2)
        goto userr;
    if (i <= argc-1 && freopen(argv[i], "r", stdin) == NULL) {
        fprintf(stderr, "%s: can't open input \"%s\"\n",
                progname, argv[i]);
        exit(1);
    }
    if (i == argc-2 && freopen(argv[i+1], "w", stdout) == NULL) {
        fprintf(stderr, "can't open output \"%s\"\n",
                progname, argv[i+1]);
        exit(1);
    }
    setcolrgam(gam);        /* set up gam correction */
    if (reverse) {
        /* convert file */
        Rle2Ra(i, argv);
    } else {
        /* get our header */
        if (checkheader(stdin, COLRFMT, NULL) < 0 ||
                fgetresolu(&xmax, &ymax, stdin) < 0)
            quiterr("bad picture format");
        /* convert file */
        Ra2Rle();
    }
    exit(0);
userr:
    fprintf(stderr,
        "Usage: %s [-r][-g gam][-e +/-stops] [input [output]]\n",
            progname);
    exit(1);
}

/*** end ra_rle.c ***/
From phils@Athena.MIT.EDU Thu Apr 29 14:52:59 1993
Return-Path: <phils@Athena.MIT.EDU>
From: phils@Athena.MIT.EDU
Date: Thu, 29 Apr 93 17:52:50 -0400
To: greg@hobbes.lbl.gov
Subject: Radiance to Utah Raster Toolkit
Cc: phils@Athena.MIT.EDU
Status: R

Hi Greg,

Here is code that reads/writes rle files for interfacing with the Utah
Raster Toolkit.  We find it useful for animations. Unfortunately,
images come out upsidedown, so they have to be passed through rleflip.
Its a quick hack and comments don't get translated amoung the files.
Maybe later.  Hope you find it useful (if you have the toolkit).

Philip

-------------
/* Copyright (c) 1992 Regents of the University of California */
#ifndef lint
static char SCCSid[] = "@(#)ra_skel.c 2.4 12/17/92 LBL";
#endif
/*  Philip R. Thompson, 4/93
 *  Computer Resource Lab.
 *  School of Architecture and Planning, MIT
 *  Quick an dirty jof of converting Radiance images to the
 *  Utah Raster Toolkit format (rle).
 *  Note: No support for comments although both file formats support
 *  them.
 */
#define RLELIB
#include  <stdio.h>
#include  "color.h"
#include  "resolu.h"
#ifdef RLELIB
#include "rle.h"
#endif
#include "standard.h"

static double  gam = 2.2;           /* gam correction */
static int  bradj = 0;              /* brightness adjustment */
static char  *progname = NULL;
static int  xmax, ymax;


static void quiterr(err)        /* print message and exit */
char  *err;
{
    if (err != NULL)
        fprintf(stderr, "%s: %s\n", progname, err);
    exit(1);
}

/* convert 24-bit scanlines to Radiance pic */
static int Rle2Ra(argc, argv)
int argc;
char **argv;
{
    register int x, y, xmax, ymax;
    rle_hdr in_globals;
    rle_pixel **rows;
    COLR *scanout;

    bzero((char*)&in_globals, sizeof(rle_hdr));
    in_globals.rle_file = stdin;
    if (rle_get_setup(&in_globals) < 0)
        quiterr("Rle2Ra: can't read rle setup information");
    xmax = in_globals.xmax - in_globals.xmin + 1;
    ymax = in_globals.ymax - in_globals.ymin + 1;
    if (rle_row_alloc(&in_globals, &rows))
        quiterr("Rle2Ra: rle_row_alloc() failed.");

    /* put our header */
    printargs(argc, argv, stdout);
    fputformat(COLRFMT, stdout);
    putchar('\n');
    fprtresolu(xmax, ymax, stdout);
    /* allocate scanline */
    if ((scanout = (COLR *)malloc(xmax*sizeof(COLR))) == NULL)
        quiterr("out of memory in Rle2Ra");
    /* convert image */
    for (y = ymax-1; y >= 0; y--) {
        rle_getrow(&in_globals, rows);
        for (x = 0; x < xmax; x++) {
            scanout[x][RED] = rows[RLE_RED][x];
            scanout[x][GRN] = rows[RLE_GREEN][x];
            scanout[x][BLU] = rows[RLE_BLUE][x];
        }
        if (feof(stdin) || ferror(stdin))
            quiterr("error reading rle image");
        /* undo gam */
        gambs_colrs(scanout, xmax);
        if (bradj)          /* adjust exposure */
            shiftcolrs(scanout, xmax, bradj);
        if (fwritecolrs(scanout, xmax, stdout) < 0)
            quiterr("error writing Radiance picture");
    }
    /* free scanline */
    free((char *)scanout);
    rle_row_free(&in_globals, rows);
    return 1;
}


static int Ra2Rle()     /* convert Radiance data to 24-bit Utah rle */
{
    register int x, y;
    register COLR *scanin;
    rle_pixel **rows;
    rle_hdr out_globals;

    /* allocate scanline */
    if ((scanin = (COLR *)malloc(xmax*sizeof(COLR))) == NULL)
        quiterr("out of memory in Ra2Rle");

    /* Intialize and setup rle header */
    bzero(&out_globals, sizeof(rle_hdr));
    out_globals.xmax = xmax - 1;
    out_globals.ymax = ymax - 1;
    out_globals.rle_file = stdout;
    out_globals.ncmap = 0;
    out_globals.ncolors = 3;
    for (x = 0; x < out_globals.ncolors; x++)
        RLE_SET_BIT(out_globals, x);
    out_globals.comments = NULL;
    if (rle_row_alloc(&out_globals, &rows)) {
        quiterr("Ra2Rle: rle_row_alloc failed");
        return 0;
    }
    rle_put_setup(&out_globals);        /* write out the header */

    /* convert image */
    for (y = ymax-1; y >= 0; y--) {
        if (freadcolrs(scanin, xmax, stdin) < 0)
            quiterr("error reading Radiance picture");
        if (bradj)                      /* adjust exposure */
            shiftcolrs(scanin, xmax, bradj);
        colrs_gambs(scanin, xmax);      /* gam correction */
        for (x = 0; x < xmax; x++) {
            rows[RLE_RED][x] = scanin[x][RED];
            rows[RLE_GREEN][x] = scanin[x][GRN];
            rows[RLE_BLUE][x] = scanin[x][BLU];
        }
        rle_putrow(rows, xmax, &out_globals);
        if (ferror(stdout))
            quiterr("error writing skel file");
    }
    rle_puteof(&out_globals);
    rle_row_free(&out_globals, rows);
    if (out_globals.priv.put.brun)
        free((char*)out_globals.priv.put.brun);
    if (out_globals.bg_color)
        free((char*)out_globals.bg_color);
    if (out_globals.cmap)
        free((char*)out_globals.cmap);
    free((char *)scanin);
    return 1;
}


main(argc, argv)
int  argc;
char  *argv[];
{
    int  i, reverse = 0;
    
    progname = argv[0];
    for (i = 1; i < argc; i++)
        if (argv[i][0] == '-')
            switch (argv[i][1]) {
            case 'g':       /* gam correction */
                gam = atof(argv[++i]);
                break;
            case 'e':       /* exposure adjustment */
                if (argv[i+1][0] != '+' && argv[i+1][0] != '-')
                    goto userr;
                bradj = atoi(argv[++i]);
                break;
            case 'r':       /* reverse conversion */
                reverse = 1;
                break;
            default:
                goto userr;
            }
        else
            break;

    if (i < argc-2)
        goto userr;
    if (i <= argc-1 && freopen(argv[i], "r", stdin) == NULL) {
        fprintf(stderr, "%s: can't open input \"%s\"\n",
                progname, argv[i]);
        exit(1);
    }
    if (i == argc-2 && freopen(argv[i+1], "w", stdout) == NULL) {
        fprintf(stderr, "can't open output \"%s\"\n",
                progname, argv[i+1]);
        exit(1);
    }
    setcolrgam(gam);        /* set up gam correction */
    if (reverse) {
        /* convert file */
        Rle2Ra(i, argv);
    } else {
        /* get our header */
        if (checkheader(stdin, COLRFMT, NULL) < 0 ||
                fgetresolu(&xmax, &ymax, stdin) < 0)
            quiterr("bad picture format");
        /* convert file */
        Ra2Rle();
    }
    exit(0);
userr:
    fprintf(stderr,
        "Usage: %s [-r][-g gam][-e +/-stops] [input [output]]\n",
            progname);
    exit(1);
}

/*** end ra_rle.c ***/

From greg Thu Apr 29 16:38:15 1993
Return-Path: <greg>
Date: Thu, 29 Apr 93 16:38:12 PDT
From: greg (Gregory J. Ward)
To: phils@Athena.MIT.EDU
Subject: Re:  Radiance to Utah Raster Toolkit
Status: R

Hi Philip,

I don't use the RLE toolkit myself, but I'm sure there are Radiance users
out there who do.  I assume they convert to RLE via some intermediate format
like Targa or PPM.  Not as convenient, I admit.

I actually downloaded the RLE toolkit at one point because I wanted to try
and support some of the commonly used formats, but including this library
in the Radiance distribution would have required a lot of extra work on
the part of the administrator during compilation.  The RLE library just
doesn't compile that easily.  I also looked at writing the format manually,
but the format itself is quite complicated, like TIFF in many respects.
(ra_tiff uses Sam Leffler's very robust library -- I couldn't have written
this myself!)

I assume from glancing at it that ra_rle.c requires linking with the RLE
library, doesn't it?  If so, then I suggest that I put it in the translators
directory on our anonymous ftp account, where people with the library may
pick it up.

Thanks very much!
-Greg

From phils@Athena.MIT.EDU Thu Apr 29 17:07:48 1993
Return-Path: <phils@Athena.MIT.EDU>
To: greg@hobbes.lbl.gov (Gregory J. Ward)
Subject: Re: Radiance to Utah Raster Toolkit 
Date: Thu, 29 Apr 93 20:07:27 EDT
From: Philip  Thompson <phils@Athena.MIT.EDU>
Status: R


Greg,

You may want to grab the latest URT (version3.0 + patches),
since it really has compiled without any problems around here.
Its supported on:
        Sun 3 (SunOS 4) with cc (config/sun3) and gcc
        Sun 4 (SunOS 4) (config/sun4)
        DEC 3100 (Ultrix 3.1) (config/dec)
        IBM RT (AIX ??) (config/ibm-rt)
        SGI Iris 4D (IRIX 3.2) (config/iris4d)
        Apollo (SR 10.2) (config/apollo)
        Stardent GS1000 (config/stellar)
        HP 9000/3xx,8xx (HP-UX 7.03) (config/hpux300 config/hpux800)
        Macintosh (A/UX) [note - getmac program does not work on A/UX]
        Macintosh (MacOS) with MPW [at least library and getmac
program]
        Cray 2 (UNICOS) (config/cray)
and available from freebie.engin.umich.edu.

Anyway go ahead and put ra_rle.c in translators.  If you have any
ideas on ways to avoid a flipped image, I'd appreciate suggestions.
I don't suppose there's an easy way to read scanlines in reverse
order?  Or calls to get/put comments from radiance files?  It's
a shame to loose that information.

bye,
Philip


From greg Thu Apr 29 19:22:48 1993
Return-Path: <greg>
Date: Thu, 29 Apr 93 19:22:44 PDT
From: greg (Gregory J. Ward)
To: phils@Athena.MIT.EDU
Subject: Re: Radiance to Utah Raster Toolkit
Status: R

Hi Philip,

I didn't mean to say that RLE didn't compile, only that it was difficult
and required the user to answer a lot of questions.  Has this changed?
I couldn't figure out how to integrate their installation into mine
without making mine take twice as long.  (I'm not saying that my
installation is better, only different.  It would be better if both
used imake or something.)

As for the flipped images, you can either load the whole thing into
memory, or call an image flipper before or after.  If you don't want
to do either, you can look at pflip.c for how to read a Radiance image
from bottom to top.  Basically, you make one pass on the file to figure
out where each scanline starts, then use fseek to get them in reverse
order.  Writing the image out, you can write out a flattened image by
calling fwrite in place of fwritecolrs (see ra_rgbe for example), again
using fseek to go to the appropriate locations in reverse.  This has
the unfortunate problem of doubling or even tripling the picture size,
however.  Provided temporary disk space is not a problem, you can always
call ra_rgbe -r to fix this problem afterwards, which is a very fast program.

-Greg

