
/*
 * (c) 1988 by George Kyriazis
 */

/*
 * read the input file of the ray-tracer
 */

#include	<stdio.h>
#include	<math.h>
#include	"ray.h"

readfile(fname)
char	*fname;
{
	FILE	*f;
	int	i, j;
	int	nos, nosq;
	char	s[10];

	f = fopen(fname,"r");
	if(f == NULL) {
		perror("fopen");
		exit(1);
	}

/* file format is:
 *	<fov> field of view
 *	<eyex eyey eyez> position of the eye
 *	<dirx diry dirz> dorection of view
 *	<upx upy upz> up vector
 *	<time1 time2> time limits
 *	<#> background cuing
 *	<iter> number of iterations per pixel
 *	<x y z angle> coordinates and angle of the light source
 *	number or spheres  number of squares
 * 	<x y z r [ambient] [diff] [spec] refl r g b refr r g b
 *		width index refl_diffuse refr_diffuse tx ty tz> 
 *		for every sphere
 *	<x y z x y z x y z [ambient] [diff] [spec]
 *		refl r g b refr r g b with index 
 *		refl_diffuse refr_diffuse tx ty tz>
 *		  for every square
 */

/* viewing transform */
	fscanf(f, "%lf", &fov);
	fov = tan( fov * M_PI / 180 ) / sqrt(2.0);
	fscanf(f, "%lf %lf %lf", &eye.x, &eye.y, &eye.z);
	fscanf(f, "%lf %lf %lf", &eye_dir.x, &eye_dir.y, &eye_dir.z);
	fscanf(f, "%lf %lf %lf", &up.x, &up.y, &up.z);

/* time information */
	fscanf(f, "%lf %lf", &time1, &time2);

/* the background flag */
	fscanf(f, "%s", s);
	if( *s == 'n' ) bgflag = NONE;
	if( *s == 'x' ) bgflag = X;
	if( *s == 'y' ) bgflag = Y;
	if( *s == 'z' ) bgflag = Z;

/* how many samples per pixel? */
	fscanf(f, "%d", &tries);

/* now the light source */
	fscanf(f, "%lf %lf %lf %lf", &light.org.x, &light.org.y,
		&light.org.z, &light.angle);
	light.angle *= M_PI/180;

	fscanf(f, "%d %d", &nos, &nosq);
	noo = nos + nosq;

	obj = (struct obj *)malloc(noo * sizeof(struct obj) );
	if(obj == NULL) {
		perror("malloc");
		exit(1);
	}

	i = 0;
	for(j = 0; j < nos; j++) {
		obj[i].type = SPHERE;
		fscanf(f, "%lf %lf %lf %lf", &obj[i].data.sphere.center.x,
			&obj[i].data.sphere.center.y,
			&obj[i].data.sphere.center.z,
			&obj[i].data.sphere.radius );
		fscanf(f, "%lf %lf %lf", &obj[i].ambient.r,
			&obj[i].ambient.g,
			&obj[i].ambient.b);
		fscanf(f, "%lf %lf %lf", &obj[i].diffuse.r,
			&obj[i].diffuse.g,
			&obj[i].diffuse.b);
		fscanf(f, "%lf %lf %lf", &obj[i].specular.r,
			&obj[i].specular.g,
			&obj[i].specular.b);
		fscanf(f, "%lf %lf %lf %lf", &obj[i].reflection,
			&obj[i].refl_color.r,
			&obj[i].refl_color.g,
			&obj[i].refl_color.b);
		fscanf(f, "%lf %lf %lf %lf", &obj[i].refraction,
			&obj[i].refr_color.r,
			&obj[i].refr_color.g,
			&obj[i].refr_color.b);
		fscanf(f, "%lf %lf", &obj[i].width, &obj[i].index);
		fscanf(f, "%lf %lf", &obj[i].refl_diffuse,
				&obj[i].refr_diffuse);
			obj[i].refl_diffuse *= M_PI / 180;
			obj[i].refr_diffuse *= M_PI / 180;
		fscanf(f, "%lf %lf %lf", &obj[i].time.x,
			&obj[i].time.y, &obj[i].time.z);

		i++;
	}

	for( j = 0; j < nosq; j++) {
		obj[i].type = SQUARE;
		fscanf(f, "%lf %lf %lf", &obj[i].data.quad.p1.x,
			&obj[i].data.quad.p1.y,
			&obj[i].data.quad.p1.z);
		fscanf(f, "%lf %lf %lf", &obj[i].data.quad.p2.x,
			&obj[i].data.quad.p2.y,
			&obj[i].data.quad.p2.z);
		fscanf(f, "%lf %lf %lf", &obj[i].data.quad.p3.x,
			&obj[i].data.quad.p3.y,
			&obj[i].data.quad.p3.z);
		fscanf(f, "%lf %lf %lf", &obj[i].ambient.r,
			&obj[i].ambient.g,
			&obj[i].ambient.b);
		fscanf(f, "%lf %lf %lf", &obj[i].diffuse.r,
			&obj[i].diffuse.g,
			&obj[i].diffuse.b);
		fscanf(f, "%lf %lf %lf", &obj[i].specular.r,
			&obj[i].specular.g,
			&obj[i].specular.b);
		fscanf(f, "%lf %lf %lf %lf", &obj[i].reflection,
			&obj[i].refl_color.r,
			&obj[i].refl_color.g,
			&obj[i].refl_color.b);
		fscanf(f, "%lf %lf %lf %lf", &obj[i].refraction,
			&obj[i].refr_color.r,
			&obj[i].refr_color.g,
			&obj[i].refr_color.b);
		fscanf(f, "%lf %lf", &obj[i].width, &obj[i].index);
		fscanf(f, "%lf %lf", &obj[i].refl_diffuse,
				&obj[i].refr_diffuse);
			obj[i].refl_diffuse *= M_PI / 180;
			obj[i].refr_diffuse *= M_PI / 180;
		fscanf(f, "%lf %lf %lf", &obj[i].time.x,
			&obj[i].time.y, &obj[i].time.z);

		i++;
	}

}
