#ifndef lint
static       char    rcsid[] = "$Header: matrix.c,v 1.1 90/03/13 23:24:22 zhang Exp $";
#endif

/*
 * $Log:	matrix.c,v $
 * 
 * Revision 1.1  90/03/13  23:24:22  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * set-up a pair of unit matrics
 */

VOID	MatrixUnit(matrix)
MATRIX	matrix[2];
{
	INT	i, j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			matrix[0][i][j] = matrix[1][i][j] = (i == j) ? 1.0 : 0.0;
}

/*
 * set-up a pair of matrics for counter-clockwise rotation
 * about vector (x, y, z) by theta radians.
 */

VOID	MatrixRotate(matrix, vector, theta)
MATRIX	matrix[2];
FLOAT	vector[3];
FLOAT	theta;
{
	FLOAT	length;
	FLOAT	n1, n2, n3;
	FLOAT	sintheta, costheta;

	MatrixUnit(matrix);
	length = VecLength(vector);

	if (length < TOE)
		GENERR("cannot setup rotation matrix %s", "\n");

	length = 1.0 / length;
	n1 = vector[0] * length;
	n2 = vector[1] * length;
	n3 = vector[2] * length;

	sintheta = sin(theta);
	costheta = cos(theta);

	matrix[0][0][0] = (FLOAT) (n1 * n1 + (1. - n1 * n1) * costheta);
	matrix[0][0][1] = (FLOAT) (n1 * n2 * (1 - costheta) + n3 *sintheta);
	matrix[0][0][2] = (FLOAT) (n1 * n3 * (1 - costheta) - n2 *sintheta);
	matrix[0][1][0] = (FLOAT) (n1 * n2 * (1 - costheta) - n3 *sintheta);
	matrix[0][1][1] = (FLOAT) (n2 * n2 + (1. - n2 * n2) * costheta);
	matrix[0][1][2] = (FLOAT) (n2 * n3 * (1 - costheta) + n1 *sintheta);
	matrix[0][2][0] = (FLOAT) (n1 * n3 * (1 - costheta) + n2 *sintheta);
	matrix[0][2][1] = (FLOAT) (n2 * n3 * (1 - costheta) - n1 *sintheta);
	matrix[0][2][2] = (FLOAT) (n3 * n3 + (1. - n3 * n3) * costheta);

	sintheta = sin(-theta);
	costheta = cos(-theta);

	matrix[1][0][0] = (FLOAT) (n1 * n1 + (1. - n1 * n1) * costheta);
	matrix[1][0][1] = (FLOAT) (n1 * n2 * (1 - costheta) + n3 *sintheta);
	matrix[1][0][2] = (FLOAT) (n1 * n3 * (1 - costheta) - n2 *sintheta);
	matrix[1][1][0] = (FLOAT) (n1 * n2 * (1 - costheta) - n3 *sintheta);
	matrix[1][1][1] = (FLOAT) (n2 * n2 + (1. - n2 * n2) * costheta);
	matrix[1][1][2] = (FLOAT) (n2 * n3 * (1 - costheta) + n1 *sintheta);
	matrix[1][2][0] = (FLOAT) (n1 * n3 * (1 - costheta) + n2 *sintheta);
	matrix[1][2][1] = (FLOAT) (n2 * n3 * (1 - costheta) - n1 *sintheta);
	matrix[1][2][2] = (FLOAT) (n3 * n3 + (1. - n3 * n3) * costheta);
}

/*
 * set-up a pair of matrics for translation
 */

VOID	MatrixTranslate(matrix, deltax, deltay, deltaz)
MATRIX	matrix[2];
FLOAT	deltax, deltay, deltaz;
{
	MatrixUnit(matrix);

	matrix[0][0][3] = deltax;
	matrix[0][1][3] = deltay;
	matrix[0][2][3] = deltaz;

	matrix[1][0][3] = - deltax;
	matrix[1][1][3] = - deltay;
	matrix[1][2][3] = - deltaz;
}

/*
 * set-up a pair of matrics for scaling
 */

VOID	MatrixScale(matrix, xscale, yscale, zscale)
MATRIX	matrix[2];
FLOAT	xscale, yscale, zscale;
{
	if (fabs(xscale) < TOE || fabs(yscale) < TOE || fabs(zscale) < TOE)
		GENERR("cannot setup scaling matrix %s", "\n");

	MatrixUnit(matrix);

	matrix[0][0][0] = xscale;
	matrix[0][1][1] = yscale;
	matrix[0][2][2] = zscale;

	matrix[1][0][0] = 1.0 / xscale;
	matrix[1][1][1] = 1.0 / yscale;
	matrix[1][2][2] = 1.0 / zscale;
}

/*
 * set a pair of matrics for transforming the Z axis of the
 * coordinate system into the extrusion direction
 */

VOID	MatrixExtrusion(matrix, extrusion)
MATRIX	matrix[2];
FLOAT	extrusion[3];
{
	FLOAT	xaxis[3];
	FLOAT	yaxis[3];
	FLOAT	zaxis[3];

	VecCopy(extrusion, zaxis);
	if (VecNormalize(zaxis) < TOE)
		GENERR("cannot setup extrusion matrix %s", "\n");

	ArbitraryAxis(xaxis, yaxis, zaxis);

	MatrixUnit(matrix);
	matrix[0][0][0] = matrix[1][0][0] = xaxis[0];
	matrix[0][0][1] = matrix[1][1][0] = xaxis[1];
	matrix[0][0][2] = matrix[1][2][0] = xaxis[2];
	matrix[0][1][0] = matrix[1][0][1] = yaxis[0];
	matrix[0][1][1] = matrix[1][1][1] = yaxis[1];
	matrix[0][1][2] = matrix[1][2][1] = yaxis[2];
	matrix[0][2][0] = matrix[1][0][2] = zaxis[0];
	matrix[0][2][1] = matrix[1][1][2] = zaxis[1];
	matrix[0][2][2] = matrix[1][2][2] = zaxis[2];
}

/*
 * Multiply matrics m1 and m2 and copy the result into m.
 */

VOID	MatrixMultiply(m1, m2, m)
MATRIX	m1[2];
MATRIX	m2[2];
MATRIX	m[2];
{
	INT	i, j, k;
	MATRIX	temp[2];

	for(i = 0; i < 4; i++)
		for(j = 0; j < 4;j++) {
			temp[0][i][j] = temp[1][i][j] = 0.0;
			for(k = 0; k < 4; k++) {
				temp[0][i][j] += m1[0][i][k] * m2[0][k][j];
				temp[1][i][j] += m2[1][i][k] * m1[1][k][j];
			}
		}
	(VOID) bcopy(temp, m, 2 * sizeof(MATRIX));
}

/*
 * Apply a transformation to a point (translation affects the point).
 */

VOID	XformPoint(m, p, q)
MATRIX	m;
FLOAT	p[3];
FLOAT	q[3];
{
	q[0] = p[0] * m[0][0] + p[1] * m[0][1] + p[2] * m[0][2] + m[0][3];
	q[1] = p[0] * m[1][0] + p[1] * m[1][1] + p[2] * m[1][2] + m[1][3];
	q[2] = p[0] * m[2][0] + p[1] * m[2][1] + p[2] * m[2][2] + m[2][3];
}

/*
 * Apply transformation to a vector (translations have no effect).
 */

VOID	XformVector(m, p, q)
MATRIX	m;
FLOAT	p[3];
FLOAT	q[3];
{
	q[0] = p[0] * m[0][0] + p[1] * m[0][1] + p[2] * m[0][2];
	q[1] = p[0] * m[1][0] + p[1] * m[1][1] + p[2] * m[1][2];
	q[2] = p[0] * m[2][0] + p[1] * m[2][1] + p[2] * m[2][2];
}

/*
 * print contents of a matrix
 */

VOID	MatrixPrint(m)
MATRIX	m;
{
	INT	i, j;

	for (i = 0; i < 4; i++) {
		for (j = 0; j < 4; j++)
			fprintf(stderr, "%g ", m[i][j]);
		fprintf(stderr, "\n");
	}
}
