#ifndef lint
static       char    rcsid[] = "$Header: main.c,v 1.2 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	main.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

/*
 * define some stuff for time accounting. on unix machines, the times(3)
 * time function is used. for single-user machines, such as IBM-PCs, the
 * time(2) function is adequate to measure elapse time. if the times(3)
 * function is used, be sure that the HERTZ constant, the granularity of
 * your times(2) function is correctly defined, otherwise wrong time
 * accounting results will generated. on most unix machines, the value
 * of HERTZ is 60, however, on some other unix systems, such as HP-UX,
 * it should be 100. if you are not sure of the exact value of HERTZ,
 * please refer the manual of the times(3) function or check the definition
 * of the HZ constant in the "sys/parma.h" include file.
 *
 */

#ifdef	UNIX
#include <sys/types.h>
#include <sys/times.h>
#endif

#ifdef	MSDOS
#include <ctype.h>
extern	long	time();
static	long	starttime;	/* starting time on IBM-PC running MS-DOS */
#endif

/*
 * print statistics about execute time, etc.
 */

VOID	PrintStatistics(fd, progname)
FILE	*fd;
CHAR	*progname;
{
#ifdef	UNIX
	struct tms buf;

        (VOID) times(&buf);
	fprintf(fd, "%s: time spent in user code:   %-6d seconds\n", progname, buf.tms_utime / HERTZ);
	fprintf(fd, "%s: time spent in system code: %-6d seconds\n", progname, buf.tms_stime / HERTZ);
#endif

#ifdef	MSDOS
	fprintf(fd, "%s: time spent: %d seconds\n", progname, (long) time((long *) 0) - starttime);
#endif
}

/*
 * usage about the program
 */

static	CHAR	*helpmsg[] = {
	"\n",
	"-odef outfile: convert a DXF file into DEF format\n",
	"               the output files are outfile.obj and outfile.def\n",
	"-onff outfile: convert a DXF file into NFF format\n",
	"               the output files are outfile.sur and outfile.nff\n",
	"-odxf outfile: convert a DXF file into a DXF file which has no\n",
	"               only 3DFACE entities\n",
	"               the output file are outfile.lay and outfile.ent\n",
	"-orad outfile: convert a DXF file into RADIANCE input format\n",
	"               the output files are outfile.mod and outfile.rad\n",
	"-l libdxffile: specify a set of library DXF files defining BLOCKs\n",
	"               their ENTITIES sections are also included\n",
	"-i inputfile : specify a set of input DXF files defining objects\n",
	"               both BLOCKS and ENTITIES sections of them are used\n",
	"-m minradius : specify a minimum value of circle radius for\n",
	"               tesselate CIRCLEs and ARCs. its default value is 10\n",
	"-s string    : string linking block name and layer name. default is '_'\n",
	"-p string    : string as a prefix for a name starting with non-alpha\n",
	"               char. default is '_'\n",
	"-n layer     : change default 'block name + layer' name mode into\n",
	"               'layer name' only mode\n",

			
	"\n",
	"note: if none of the -odef, -onff, -odxf and -orad options is specified,\n",
	"      only the syntax of the library DXF files and/or the input DXF\n",
	"      files are checked, and there is no file created\n",
	"      at least, either the -l option or the -i option should be\n",
	"      supplied\n",
	NULL
};

VOID	Usage()
{
	INT	i;
	INT	length;
	CHAR	*space;

	fprintf(stderr, "usage: %s [-o[def|nff|dxf|rad] outfile] [-l libdxffile...] [-i indxffile...]\n", ProgName);

	length = strlen(ProgName) + 7;
	space = Malloc(CHAR, length + 1);

	i = 0;
	while (i < length)
		space[i++] = ' ';
	space[i] = '\0';

	fprintf(stderr, "%s [-m radius] [-s joinstr] [-p prefix] [-l layer]\n", space);

	for (i = 0; helpmsg[i] != NULL; i++)
		fprintf(stderr, "       %s", helpmsg[i]);

	exit(-1);
}

/*
 * main program
 */

VOID	main(argc, argv)
INT	argc;
CHAR	*argv[];
{
	INT	i;
	INT	MinFlag = 0;
	INT	LibFlag = 0;
	INT	PrefixStrFlag = 0;
	INT	JoinStrFlag = 0;
	INT	JoinModeFlag = 0;
	INT	LibBegin;
	INT	LibEnd;
	INT	InputFlag = 0;
	INT	InputBegin;
	INT	InputEnd;
	CHAR 	*OutFileName = NULL;

#ifdef	MSDOS
	starttime = (long) time((long *) 0);
#endif

#ifdef	UNIX
	if ((ProgName = (CHAR *) rindex(argv[0], '/')) == NULL)
#endif

#ifdef	MSDOS
	if ((ProgName = (CHAR *) rindex(argv[0], '\\')) == NULL)
#endif
		ProgName = argv[0];
	else 
		ProgName++;

#ifdef	MSDOS
	for (i = 0; ProgName[i] != '\0'; i++) {
		if (isupper(ProgName[i]))
			ProgName[i] += ('a' - 'A');
		if (ProgName[i] == '.') {
			ProgName[i] = '\0';
			break;
		}
	}
	argv[0] = ProgName;
#endif

	if (argc == 1)
		Usage();

	i = 1;
	while (i < argc) {
		if (strcmp(argv[i], "-odef") &&
		    strcmp(argv[i], "-onff") &&
		    strcmp(argv[i], "-odxf") &&
		    strcmp(argv[i], "-orad") &&
		    strcmp(argv[i], "-i") &&
		    strcmp(argv[i], "-l") &&
		    strcmp(argv[i], "-s") &&
		    strcmp(argv[i], "-n") &&
		    strcmp(argv[i], "-p") &&
		    strcmp(argv[i], "-m"))
			Usage();
		switch(argv[i][1]) {
		case 'o':
			switch(argv[i][3]) {
			case 'e':
				if (OutFileType != -1)
					Usage();
				OutFileType = FILE_DEF;
				i++;
				if (i >= argc)
					Usage();
				OutFileName = argv[i];
				i++;
				break;
			case 'f':
				if (OutFileType != -1)
					Usage();
				OutFileType = FILE_NFF;
				i++;
				if (i >= argc)
					Usage();
				OutFileName = argv[i];
				i++;
				break;
			case 'x':
				if (OutFileType != -1)
					Usage();
				OutFileType = FILE_DXF;
				i++;
				if (i >= argc)
					Usage();
				OutFileName = argv[i];
				i++;
				break;
			case 'a':
				if (OutFileType != -1)
					Usage();
				OutFileType = FILE_RAD;
				i++;
				if (i >= argc)
					Usage();
				OutFileName = argv[i];
				i++;
				break;
			default:
				Usage();
			}
			break;
		case 'l':
			if (LibFlag != 0)
				Usage();
			LibFlag = 1;
			i++;
			if (i >= argc)
				Usage();
			LibBegin = i;
			i++;
			while (i < argc &&
				strcmp(argv[i], "-odef") &&
				strcmp(argv[i], "-onff") &&
				strcmp(argv[i], "-odxf") &&
		    		strcmp(argv[i], "-orad") &&
				strcmp(argv[i], "-i") &&
				strcmp(argv[i], "-l") &&
		    		strcmp(argv[i], "-s") &&
				strcmp(argv[i], "-n") &&
		    		strcmp(argv[i], "-p") &&
				strcmp(argv[i], "-m"))
				i++;
			LibEnd = i - 1;
			break;
		case 'i':
			if (InputFlag != 0)
				Usage();
			InputFlag = 1;
			i++;
			if (i >= argc)
				Usage();
			InputBegin = i;
			i++;
			while (i < argc &&
				strcmp(argv[i], "-odef") &&
				strcmp(argv[i], "-onff") &&
				strcmp(argv[i], "-odxf") &&
		    		strcmp(argv[i], "-orad") &&
				strcmp(argv[i], "-i") &&
				strcmp(argv[i], "-l") &&
		    		strcmp(argv[i], "-s") &&
				strcmp(argv[i], "-n") &&
		    		strcmp(argv[i], "-p") &&
				strcmp(argv[i], "-m"))
				i++;
			InputEnd = i - 1;
			break;
		case 'm':
			if (MinFlag != 0)
				Usage();
			MinFlag = 1;
			i++;
			if (i >= argc)
				Usage();
			MinCircleRadius = atof(argv[i]);
			if (MinCircleRadius < TOE)
				Usage();
			i++;
			break;
		case 's':
			if (JoinStrFlag != 0)
				Usage();
			i++;
			if (i >= argc)
				Usage();
			JoinStr = argv[i];
			JoinStrFlag = 1;
			i++;
			break;
		case 'n':
			if (JoinModeFlag != 0)
				Usage();
			i++;
			if (i >= argc)
				Usage();
			if (strcmp(argv[i], "layer") != 0)
				Usage();
			JoinModeFlag = 1;
			JoinMode = 0;
			i++;
			break;
		case 'p':
			if (PrefixStrFlag != 0)
				Usage();
			i++;
			if (i >= argc)
				Usage();
			PrefixStr = argv[i];
			PrefixStrFlag = 1;
			i++;
			break;
		default:
			Usage();
		}
	}

	if (InputFlag == 0 && OutFileType != -1)
		Usage();

	fprintf(stderr, "%s: AutoCAD 10.0 DXF ", ProgName);
	if (OutFileType == -1)
		fprintf(stderr, "File Testing\n");
	else
	if (OutFileType == FILE_DEF) {
		fprintf(stderr, "File To DEF File\n");
		fprintf(stderr, "%s: Output DEF File is %s\n",
				ProgName, OutFileName);
	}
	else
	if (OutFileType == FILE_NFF) {
		fprintf(stderr, "File To NFF File\n");
		fprintf(stderr, "%s: Output NFF File is %s\n",
				ProgName, OutFileName);
	}
	else
	if (OutFileType == FILE_DXF) {
		fprintf(stderr, "File To Exploded DXF File\n");
		fprintf(stderr, "%s: Output DXF File is %s\n",
				ProgName, OutFileName);
	}
	else
	if (OutFileType == FILE_RAD) {
		fprintf(stderr, "File To RAD File\n");
		fprintf(stderr, "%s: Output RAD File is %s\n",
				ProgName, OutFileName);
	}

	if (LibFlag != 0)
		for (i = LibBegin; i <= LibEnd; i++) {
			fprintf(stderr, "%s: parsing libary DXF file %s ... ",
					ProgName, argv[i]);
			ParseDxfFile(argv[i]);
			fprintf(stderr, "done\n");
		}
	
	if (InputFlag != 0)
		for (i = InputBegin; i <= InputEnd; i++) {
			fprintf(stderr, "%s: parsing input  DXF file %s ... ",
					ProgName, argv[i]);
			ParseDxfFile(argv[i]);
			fprintf(stderr, "done\n");
		}
	
	if (OutFileType != -1)
		OutputFile(OutFileName);

	PrintStatistics(stderr, ProgName);

	exit(0);

	/*NOTREACHED*/
}
