/****** Normal.c **********************************************
 *
 *
 *
 * PURPOSE:
 * 	Calculate the normals to a planer polygon 
 * RETURNS: 0 for OK or error number
 * GLOBALS:
 * CALLED BY:  System
 * FUNCTIONS CALLED:
 * INPUT FILES: OFF format *.geom
 * OUTPUT FILES: *.vnorm, *.pnorm
 * PROCESS/ALGORITHM:
 * CAVEATS:
 *
 *              AUTHOR                  DATE            PROJECT LEADER
 *    ORIGINAL: Foley and vanDam
 *            : P. Bryan Heidorn       9-13-94                                        
 *    ALTERED : P. Bryan Heidorn       9-26-94
 *    REASON: Correct indexing bug in Vertex normal Calculations
 *            Add pnorm write function
 *    ALTERED :                       10-2-94
 *    REASON: Reverse the sign of the coefficents. (clockwise rotation)
 *    ALTERED :
 *    REASON:
 *
 **************************************************************************/

#include "stdio.h"

struct polygon {
    int nvert;          /* Number of vertices in this polygon */
    int *verts;         /* Vertices in this polygon */
    double Normals[4];  /* Coefficients for this polygon */
};

struct object {
    int npts;           /* The number of points */
    int npolys;         /* The number of polygons */

    int nsegs;          /* The number of segments */
    float *point_x,*point_y,*point_z;
    double *VCoefA, *VCoefB, *VCoefC, *VCoefD;
    struct polygon *polys;
};
#define NOTFOUND -1
#define ENDIF }
#define ENDELSE }
#define ENDWHILE }
#define ENDFOR }
/****************************************************************************/
main(int argc, char *argv[])
{
        int     num_verts, i;
	float A, B, C, D;
	struct object obj;
	char Usage[] = "Usage: Normal FileName\nWhere 'File' is the stem of the name of the input and output files.";
	char GeomFileName[40];
	char VNormFileName[40];
	char PNormFileName[40];
	FILE *pf, *vf;
	
   if (argc != 2 ) {
      fprintf (stderr, "%s", Usage );
      return -1;
   ENDIF  
   strcpy(GeomFileName,argv[1]);
   strcat(GeomFileName,".geom");
   strcpy(VNormFileName,argv[1]);
   strcat(VNormFileName,".vnorm");
   strcpy(PNormFileName,argv[1]);
   strcat(PNormFileName,".pnorm");

if ( read_geom_file( GeomFileName, &obj ) < 0 ) 
	return -1;

/* A = B = C = D = 0.0; */
num_verts = 4;

CalcPolygonNormals (&obj);
pf = fopen (PNormFileName, "w");
WritePolygonNormals (pf, &obj);
fclose (pf );

CalcVertexNormals (&obj);
vf = fopen (VNormFileName, "w");
WriteVNorm(vf, &obj);
fclose (vf );
}


/****************************************************************************/
CalcPolygonNormals (struct object *obj)
{
int i, j, k;
int CoefA=0, CoefB=1, CoefC=2, CoefD=3;
double A, B, C, D;
double Length;

for (i = 0; i < obj->npolys; i++ ) {
	A = B = C = 0.0;
	obj->polys[i].Normals[CoefA] = 0.0;
	obj->polys[i].Normals[CoefB] = 0.0;
	obj->polys[i].Normals[CoefC] = 0.0;
/*		printf("i j k jj kk   xj       xk       zj       zk B\n"); */
	for (j = 0; j < obj->polys[i].nvert; j++ ) {
		/* k points to the next vertex rolling to the start when needed */
        	k = (j + 1)%obj->polys[i].nvert; 
        	A += (  obj->point_z[obj->polys[i].verts[j]-1] 
			 + obj->point_z[obj->polys[i].verts[k]-1] ) 
		     * 
		     (  obj->point_y[obj->polys[i].verts[k]-1] 
			 - obj->point_y[obj->polys[i].verts[j]-1]);
		/* Removed the (-) from the equasion */
        	B += (  obj->point_x[obj->polys[i].verts[j]-1] 
			  + obj->point_x[obj->polys[i].verts[k]-1]
			 ) 
		     * 
		     (  obj->point_z[obj->polys[i].verts[k]-1] 
			 - obj->point_z[obj->polys[i].verts[j]-1]);
        	C += (  obj->point_y[obj->polys[i].verts[j]-1] 
			 + obj->point_y[obj->polys[i].verts[k]-1]) 
		     * 
		     (  obj->point_x[obj->polys[i].verts[k]-1] 
			 - obj->point_x[obj->polys[i].verts[j]-1]);
/*		printf("%d %d %d %d %d %lf %lf %lf %lf %lf\n", i, j, k,obj->polys[i].verts[j]-1,  obj->polys[i].verts[k]-1,
		 obj->point_x[obj->polys[i].verts[j]-1], obj->point_x[obj->polys[i].verts[k]-1], 
		 obj->point_z[obj->polys[i].verts[j]-1], obj->point_z[obj->polys[i].verts[k]-1], B);
*/
	}
/* Unitize */
	/****
   obj->polys[i].Normals[CoefD] = 
		-(A * obj->point_x[obj->polys[i].verts[0]] 
		+ B * obj->point_y[obj->polys[i].verts[0]] 
		+ C * obj->point_z[obj->polys[i].verts[0]]); 
	obj->polys[i].Normals[CoefA] = -(A /= 2.0); 
	obj->polys[i].Normals[CoefB] = -(B /= 2.0); 
	obj->polys[i].Normals[CoefC] = -(C /= 2.0);
	****/
	Length = A*A + B*B + C*C;
	Length = sqrt(Length);
	A *= 1/Length; B *= 1/Length; C *= 1/Length;
	obj->polys[i].Normals[CoefA] = -A; 
	obj->polys[i].Normals[CoefB] = -B; 
	obj->polys[i].Normals[CoefC] = -C;
}
}
/****************************************************************************/
CalcVertexNormals (struct object *obj)
{
int FocusVertex, j;
int CoefA=0, CoefB=1, CoefC=2, CoefD=3;
int NumPolysHit, PolyCount;
double A, B, C, D;
struct polygon *CurrentPoly;

/* Scan through all verticies in the object */
for (FocusVertex = 1; FocusVertex <= obj->npts; FocusVertex++ ) {
     A = B = C = 0.0; 
	NumPolysHit = 0;
	PolyCount = 0;
	/* Each vertex will be part of some number of polygons 
	 * Search the polygons one at a time looking at each point to see  
	 * if it is the current focus 
	 * if it is the focus add the normal coefficients of this polygon
	 * to the accumulators A, B and C 
	 */
	CurrentPoly = obj->polys;
	do {
		for( j = 0; j < CurrentPoly->nvert; j++ ) {
		if ( CurrentPoly->verts[j] == FocusVertex ) {
			/* Add it and move to next polygon */
			A += CurrentPoly->Normals[CoefA];
			B += CurrentPoly->Normals[CoefB];
			C += CurrentPoly->Normals[CoefC];
			/*D += CurrentPoly->Normals[CoefD];*/
			NumPolysHit++;
			break; /* the vertex can not occure twice in the same polygon */
		}}
		CurrentPoly++;
	} while ( ++PolyCount < obj->npolys );
	obj->VCoefA[FocusVertex-1] = A / NumPolysHit; 
	obj->VCoefB[FocusVertex-1] = B / NumPolysHit; 
	obj->VCoefC[FocusVertex-1] = C / NumPolysHit; 
	/*obj->VCoefD[FocusVertex-1] = D / NumPolysHit;*/ 
} /* Next FocusVertex */
}
/****************************************************************************/
WritePolygonNormals (FILE *f, struct object *obj)
{
int CoefA=0, CoefB=1, CoefC=2, CoefD=4;
int i, j;

fprintf(f, "%d\n", obj->npolys);
for (i = 0; i < obj->npolys; i++ ) {
	fprintf(f, "%lf\t%lf\t%lf\n", obj->polys[i].Normals[CoefA] , 
		obj->polys[i].Normals[CoefB], obj->polys[i].Normals[CoefC] /*,
		obj->polys[i].Normals[CoefD]*/);
}  
}
/****************************************************************************/
PrintPolygonNormals (struct object *obj)
{
int CoefA=0, CoefB=1, CoefC=2, CoefD=4;
int i, j;

printf("%d\n", obj->npolys);
for (i = 0; i < obj->npolys; i++ ) {
	printf("%i %lf %lf %lf %lf\n", i, obj->polys[i].Normals[CoefA] , 
		obj->polys[i].Normals[CoefB], obj->polys[i].Normals[CoefC],
		obj->polys[i].Normals[CoefD]);
}  
}
/****************************************************************************/
FindPlaneCoefficients(float x[], float y[], float z[], int num_verts, 
			float *a, float *b, float *c, float *d)
{
float A, B, C, D;
int i, j;
A = B = C = 0.0;
for (i = 0; i < num_verts; i++ ) {
	j = (i + 1)%num_verts; 
	A += (z[i] + z[j]) * (y[j] - y[i]);
	B += -(x[i] + x[j]) * (z[j] - z[i]);
	C += (y[i] + y[j]) * (x[i] - x[j]);
}
A /= 2.0; B /= 2.0; C /= 2.0;
D = -(A * x[0] + B * y[0] + C * z[0]);
*a = A; *b = B; *c = C; *d = D;
}

/****************************************************************************/
int read_geom_file( char *geom_file, struct object *obj )
{
    FILE *fp;
    int i,j;

    /* printf("Before open\n"); getchar(); */
    if (!(fp = fopen(geom_file,"r")))           /* Open the .geom file */
        return -1;

                                                /* Get header information */
    /*  printf("Before scan of line 1\n"); getchar(); */
    fscanf(fp,"%d %d %d",&obj->npts,&obj->npolys,&obj->nsegs);
    /*  printf("npts %d npolys %d nsegs %d\n",obj->npts,obj->npolys,obj->nsegs); */

        /*
        ** Allocate room for the points.
        */
    /*  printf("Before Allocate point space\n"); getchar(); */
    obj->point_x = (float *)malloc(obj->npts*sizeof(float));
    obj->point_y = (float *)malloc(obj->npts*sizeof(float));
    obj->point_z = (float *)malloc(obj->npts*sizeof(float));
	/* Save space for normals to vertex */
    obj->VCoefA = (double *)malloc(obj->npts*sizeof(double));
    obj->VCoefB = (double *)malloc(obj->npts*sizeof(double));
    obj->VCoefC = (double *)malloc(obj->npts*sizeof(double));
    obj->VCoefD = (double *)malloc(obj->npts*sizeof(double));

    /* printf("Before Scan Points\n"); getchar(); */
    for (i=0;i<obj->npts;++i) {
        /* printf("Before scan point %d\n",i); getchar(); */
        fscanf(fp,"%f %f %f",&obj->point_x[i],
                                &obj->point_y[i],
                                &obj->point_z[i]);
        /* printf ("%f %f %f\n", obj->point_x[i], obj->point_y[i], obj->point_z[i]); */
	}

    /* printf("Before Allocate polygons\n"); getchar(); */
    /* Allocate room for the polygons.  */
    obj->polys = (struct polygon *)malloc(obj->npolys*sizeof(struct polygon));

    for (i=0;i<obj->npolys;++i) {
        /* See how many vertices this has */
        /* printf("\nBefore scan polygon %d\n",i); getchar(); */
        fscanf(fp,"%d",&obj->polys[i].nvert);
        /* printf("Num verts for Polygon %d = %d\n",i, obj->polys[i].nvert); */
            /* Allocate room for vertices */
        obj->polys[i].verts = (int *)malloc(obj->polys[i].nvert*sizeof(int));

            /* Get each vertex */
        for (j=0;j<obj->polys[i].nvert;++j) {
            fscanf(fp,"%d",&obj->polys[i].verts[j]);
            /* printf("%d ",obj->polys[i].verts[j]); */
		}
    }
    /* printf("The end of the reads and return\n"); */
return 0;
}

/****************************************************************************/
PrintPolygon(struct object *obj)
{
int i, j;

    printf("npts %d npolys %d nsegs %d\n",obj->npts,obj->npolys,obj->nsegs); 
    for (i=0;i<obj->npts;++i) {
        printf ("%f %f %f\n", obj->point_x[i], obj->point_y[i], obj->point_z[i]); 
     }
    for (i=0;i<obj->npolys;++i) {
        /* See how many vertices this has */
        printf("Num verts for Polygon %d = %d\n",i, obj->polys[i].nvert); 

        for (j=0;j<obj->polys[i].nvert;++j) {
            printf("%d ",obj->polys[i].verts[j]); 
          }
		printf("\n");
    }
	/* PrintPolygonNormals( obj ); */
}

/****************************************************************************/
/* Print a vnorm file */
WriteVNorm(FILE *f, struct object *obj)
{
int i, j;

    fprintf(f, "%d\t%d\t%d\n",obj->npts, obj->npolys, obj->nsegs); 
    for (i=0;i<obj->npts;++i) {
        fprintf (f, "%f\t%f\t%f\n", obj->VCoefA[i], obj->VCoefB[i], obj->VCoefC[i]); 
     }
    for (i=0;i<obj->npolys;++i) {
        /* See how many vertices this has */
        fprintf(f, "%d\t", obj->polys[i].nvert); 

        for (j=0;j<obj->polys[i].nvert;++j) {
            fprintf(f, "%d\t",obj->polys[i].verts[j]); 
          }
		fprintf(f, "\n");
    }
}

/****************************************************************************/

