#!/bin/sh
#\
exec ${GOOD_ROOT_DIR}/packages/deltabl/dbsh -file $0 $*

# Fahrenheit to Celsius converter, analog to longtest.C

Variable celsius "set CC" "set CC"
set CC 100.0

Variable fahrenheit "set FF" "set FF"
set FF 0.0

Variable t1 "set T1" "set T1" 
set T1 1.

Variable t2 "set T2" "set T2" 
set T2 1.

Constant nine "" "set {} 9"
Constant five "" "set {} 5"
Constant thirtytwo "" "set {} 32"

Constraint mul1 { celsius nine t1 } {\
    case $whichMethod \
	0 {celsius -set [expr [t1 -get]/[nine -get]]} \
	1 {nine -set [expr [t1 -get]/[celsius -get]]} \
	2 {t1 -set [expr [celsius -get]*[nine -get]]} \
    } required

Constraint mul2 { t1 five t2 } {\
    case $whichMethod \
	0 {t1 -set [expr [t2 -get]*[five -get]]} \
	1 {five -set [expr [t1 -get]/[t2 -get]]} \
	2 {t2 -set [expr [t1 -get]/[five -get]]} \
    } required

Constraint add { t2 thirtytwo fahrenheit } { \
    case $whichMethod \
	0 {t2 -set [expr [fahrenheit -get]-[thirtytwo -get]]} \
	1 {thirtytwo -set [expr [fahrenheit -get]-[t2 -get]]} \
	2 {fahrenheit -set [expr [t2 -get]+[thirtytwo -get]]} \
    } required


