# master.mk - master make include file
#
# -----------------------------------------------------------------------------
# Copyright 1993 Allan Brighton.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies.  Allan
# Brighton make no representations about the suitability of this software
# for any purpose.  It is provided "as is" without express or implied
# warranty.
# -----------------------------------------------------------------------------
#
# You will need to modify the pathnames below for your system.
#

# --- include dirs ---

# X include files
XINCDIR = /usr/include/X11

# tcl/tk include files
TCLINCDIR = $(GOOD_ROOT_DIR)/require/tcltk/include

# --- link dirs ---

# location of X11 library
XLIBDIR = /usr/lib/X11

# location of tcl libraries
TCLLIBDIR = $(GOOD_ROOT_DIR)/require/tcltk/lib

# --- compiler options ---

# default C compiler flags
CFLAGS = -g

# default C++ compiler flags
CCFLAGS = -g

# C++ compiler
CCC = g++
CCC = CC

# C compiler
CC = cc

# this is usefull for Sun make as an alternative
# to makedepend
.KEEP_STATE:

# default rules

.SUFFIXES: .c .cc .cpp .sc


# C rules
COMPILE.c=$(CC) $(CFLAGS) $(CPPFLAGS) -c
LINK.c=$(CC) $(CFLAGS) $(CPPFLAGS) $(LDFLAGS) 
.c:
	$(LINK.c) -o $@ $< $(LDLIBS)
.c.o:
	$(COMPILE.c) $<

# C++ rules
COMPILE.cc=$(CCC) $(CCINCLUDES) $(CCFLAGS) $(CPPFLAGS) -c
LINK.cc=$(CCC) $(CCFLAGS) $(CPPFLAGS) $(LDFLAGS)
.cc:
	$(LINK.cc) -o $@ $< $(LDLIBS)
.cc.o:
	$(COMPILE.cc) $<


MAKE=make
RANLIB = ranlib
