#ifndef __VR_XDR_COMM_H__
#define __VR_XDR_COMM_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of classes for XDR based communication.                        //  
//  LAST EDIT: Tue Nov 29 18:36:24 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

#include "vr_comm.h"

extern "C" {
    #include "vr_xdrfd.h"
    #include <unistd.h>
    #include <stdlib.h>
    #include <sys/types.h>
    #include <sys/socket.h>
    #include <netinet/in.h>
    #include <arpa/inet.h>
    #include <netdb.h>

#ifdef LINUX
    #include <linux/in.h>
#endif
}

extern const char *VR_COMPRESS;
extern const char *VR_UNCOMPRESS;
// the [un]compress programs we're using for Blobs

class VR_XDRSceneCommunicator: public VR_SceneCommunicator {
    // this class implements the communicator of a scene
    // via an XDR stream
    int sofd; // socket fd
    fd_set rfds;
    int fdMax;
  public:
    VR_XDRSceneCommunicator();

    void sendText2user(VR_User *USR, const char *TXT);
    void sendCmd2user(VR_User *USR, const char *CMD);

    // send a binary large object to the specified user
    // the blob is specified by FILENAME
    void sendBlob2user(VR_User *USR, const char *FILENAME, const char *REMOTE_NAME, int COMPRESS = 0);

    void loop();
    void killUser(VR_User*);
};

class VR_XDRUserCommunicator: public VR_UserCommunicator {
    RT_String scene;
    XDR rxdr, wxdr;
    int sofd; // socket descriptor
    static void readProc(ClientData, int) { vr_UserCommunicator->receive(); }

    static int blobStartCMD(ClientData, Tcl_Interp*, int argc, char *argv[] );
    // should be received before reading a blob
    static int blobPartCMD(ClientData, Tcl_Interp*, int argc, char *argv[] );
    // received before getting a part of a block
    static int blobEndCMD(ClientData, Tcl_Interp*, int argc, char *argv[] );
    // should be received after before reading a blob

    static int blobMode; 
    // 1 if the following blob is compressed, 0 else
    static int blobString; 
    // 1 if we're expecting a blob part, 0 if Tcl code
    static int blobSize;
    // size of next blob part

    static RT_String blobFile; 
    // the name of the current blob file
    static FILE *blobFP;
    // file pointer to the blob file

  public: 
    VR_XDRUserCommunicator( Tcl_Interp *, char *SCENE_NAME );
    virtual ~VR_XDRUserCommunicator();

    void send(char *CMD);
    void receive();
};

class VR_XDRUserData: public VR_UserData {
  public:
    XDR rxdr, wxdr;

    VR_XDRUserData(XDR _rxdr, XDR _wxdr): rxdr(_rxdr), wxdr(_wxdr) {}
    ~VR_XDRUserData() { 
	int fd = rxdr.x_handy;
	xdr_destroy( &rxdr ); 
	xdr_destroy( &wxdr ); 
	close( fd );
    }
};

#endif
