#ifndef __VR_INPUT_H__
#define __VR_INPUT_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of an input class for the YART/VR front end.                   //  
//  LAST EDIT: Wed Oct 12 17:43:34 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART/VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

extern const char *VRN_MANIPULATOR;

class VR_Manipulator: public RT_InputDevice {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:

    double oldx, oldy;
  public:
    void event( RT_Event*);

    //#### Tcl/C++ methods:
    VR_Manipulator(char *n): RT_InputDevice( n ) { oldx = oldy = 0; }

    const char *get_description() const {  return "A special object defined for usage in the YART/VR front end. Left button can be used to identify a guy. Mouse motions are in vertical direction will move you forward or backward in your view direction. Mouse motions in horizontal direction will be interpreted as rotations around the y axis. A mouse motion in vertical direction with a pressed middle button will be interpreted as heigt change. For all motions press right mouse button."; }
    const char *get_class() const { return VRN_MANIPULATOR; } 
    int isA(const char *c) const { return RT_InputDevice::isA( c ) || RTM_isA( VRN_MANIPULATOR, c ); }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
};

#endif
