################################################################################
##  Define an enum button with a value menu.                                  ##  
##  LAST EDIT: Thu Aug  4 13:20:40 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

#####################################################
# enum button 
#####################################################
#
# getCmd is a command witch returns the value of the manipulated object
# setCmd set the value of the manipulated object
# enumVal is the list of enum values  
#
# the value is an integer
#
# the result of the procedure is a command witch must be called to update the button
#

proc enumbutton {name titel getCmd setCmd enumVal {label_width 0}} {
    set path [boxframe $name]
    set info [lowframe $path.info left fill]
    set button [lowframe $path.scales left]

    label $info.label -text "$titel" -width $label_width
    pack append $info $info.label {expand fill}
        
    menubutton $button.val -menu $button.val.m 
    pack append  $button $button.val {fill expand}
    
    menu $button.val.m
    
    set count 0
    set maxValueWidth 0
    foreach val $enumVal {
	if $maxValueWidth<[set tmp [string length $val]] {set maxValueWidth $tmp}
	$button.val.m add command -label $val \
		-command "  $setCmd $count; $button.val configure -text $val "
	incr count
    }
    
    $button.val configure -width $maxValueWidth
    
    append getCommands "if \[string length \[$getCmd\]\] { \n"
    append getCommands "$button.val configure -text \[lindex {$enumVal} \[$getCmd\] \] \n"
    append getCommands "} \n "
    
    return $getCommands
}    
