################################################################################
##  Vertex editor similar to the manipulator                                  ##
##  LAST EDIT: Tue Mar  7 15:18:46 1995 by leinhoss@rz.tu-ilmenau.de
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_CmpTopBox ?

# some utils for float entrys

set ld_privat(lastcont) {}
set ld_privat(entry) {}
set ld_privat(entry_path) {}
set ld_privat(i) 0
set ld_privat(rows) 0
proc GrabEntry {} {global ld_privat ; grab $ld_privat(entry)}
proc ReleaseEntry {} {global ld_privat ; grab release $ld_privat(entry)} 
proc IsEntryGrabed {} {global ld_privat ; return [expr "[lsearch -exact [grab current] $ld_privat(entry)] >= 0"] }
proc Jump {} {
    global ld_privat
    if {[IsEntryGrabed]} { return }
    incr ld_privat(i)
    if {$ld_privat(i) >= $ld_privat(rows)} {
	set ld_privat(i) 0
    }
    regsub {#1} $ld_privat(entry_path) $ld_privat(i) tmp
    focus $tmp
    # focus calls the SetActiveEntry routine
    return
}
proc TraceFloatArray {name idx op} {
    global ld_privat $name
    set cont [set [set name]([set idx])]
    set jump [expr "[string first "\r" $cont] >= 0"]
    set cont [string trim $cont]
    # handle a special case
    if {$cont == {0-}} {set cont -}
    # the regexp for an uncomplete float value
    if {[regexp {^(-?([0-9]*(\.([0-9]*)?)?([0-9][eE](-?([0-9]*)?)?)?)?)?$} $cont]} {
        # remove leading zeros ...
        set cont [string trimleft $cont 0]
        # ... but not the whole number
        if {$cont == {} || [string index $cont 0] == {.}} {set cont 0$cont}
        set ld_privat(lastcont) $cont
    }
    set [set name]([set idx]) $ld_privat(lastcont)
    if {[catch {expr "$ld_privat(lastcont)"}]} {GrabEntry} else {ReleaseEntry} 
    if {$jump} { Jump }
    return
}
proc SetActiveEntry {entry_path i rows} {
    global ld_privat
    set ld_privat(i) $i
    set ld_privat(rows) $rows
    set ld_privat(entry_path) $entry_path
    regsub {#1} $entry_path $i ld_privat(entry)
    set ld_privat(lastcont) [$ld_privat(entry) get]
    return
}
#################################################################################

Tcl_Object IOM_VertexEditor IOM_CmpTopBox {old_cob matrix wmatrix idx surf in_cb} {Name} {String} {Create a new VertexEditor window.} {

    set $THIS->old_cob {}
    set $THIS->in_cb 0
    set $THIS->idx -1
    set $THIS->surf {}

    catch "wm minsize [set $THIS->tkTop] 150 100"
    catch "wm maxsize [set $THIS->tkTop] 1200 1024"
    wm title [set $THIS->tkTop] "IOM.vertex"

    set p [set $THIS->frCenter] 
    frame $p.cam
    pack append $p $p.cam {fill expand}
 
    LookatCamera $THIS-cam {0 0 10} {0 0 0}
    TKCamera $p.cam $THIS-cam

    Scene $THIS.sc
    $THIS.sc -insert [AmbientLight $THIS.al]
    $THIS.al -color {0.2 0.2 0.2}
    $THIS.sc -insert [PointLight $THIS.pl]
    $THIS.pl -origin { 10 10 10 } -color {0.9 0.9 0.9}
    $THIS-cam -scene $THIS.sc 

    [VertexManipulator $THIS.man] -father $THIS-cam
    $THIS.man -addVertexCB "$THIS -vertex_cb"
    set matrix {1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1}
    set wmatrix $matrix
    $THIS -addMenuLeft tools Tools
    # $THIS -addMenuEntry tools {check Scene} "$THIS.man -checkScene"
    $THIS -addMenuEntry tools Spline "IOM_SplineTool $THIS.splinetool ; $THIS.splinetool -object \[$THIS.man -get_currentObject\] ; $THIS.splinetool -callback {$THIS -update}"
    $THIS -addMenuEntry tools Surface "set $THIS->idx -1; IOM_SurfaceTool $THIS.surf ; $THIS.surf -callback {$THIS -update}"

    $THIS -addMenuLeft pick Pick
    $THIS -addMenuEntry pick None "$THIS.man -pick NONE"
    $THIS -addMenuEntry pick All "$THIS.man -pick ALL"
    $THIS -addMenuEntry pick Invert "$THIS.man -pick INVERT"

    $THIS -addMenuLeft edit Edit
    $THIS -addMenuEntry edit Insert "$THIS.man -insert ; set $THIS->idx -1"
    $THIS -addMenuEntry edit Delete "$THIS.man -delete ; set $THIS->idx -1"

    $THIS -addMenuLeft drawstyle Drawstyle
    $THIS -addMenuEntry drawstyle Solid "$THIS.man -drawStyle 0"
    $THIS -addMenuEntry drawstyle Wire "$THIS.man -drawStyle 1"
    $THIS -addMenuSeparator drawstyle
    $THIS -addMenuEntry drawstyle "No Box" "$THIS.man -box 0"
    $THIS -addMenuEntry drawstyle "Obj. Box" "$THIS.man -box 1"
    $THIS -addMenuEntry drawstyle "Hier. Box" "$THIS.man -box 2"

    $THIS -addMenuSeparator help
    $THIS -addMenuEntry help "LookatCamera" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage LookatCamera"	
    $THIS -addMenuEntry help "VertexManipulator" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage VertexManipulator"	

    global $THIS.mc $THIS.wc

    frame [set $THIS->frCenter].mc
    label [set $THIS->frCenter].mc.l -text {Model Coords:} -width 15
    entry [set $THIS->frCenter].mc.e0 -textvariable $THIS.mc(0) -relief sunken -width 10
    entry [set $THIS->frCenter].mc.e1 -textvariable $THIS.mc(1) -relief sunken -width 10
    entry [set $THIS->frCenter].mc.e2 -textvariable $THIS.mc(2) -relief sunken -width 10
    button [set $THIS->frCenter].mc.s -text { set } -command "$THIS.man -VertexCoords \"\[set $THIS.mc(0)\] \[set $THIS.mc(1)\] \[set $THIS.mc(2)\]\""
    pack append [set $THIS->frCenter] [set $THIS->frCenter].mc {fillx top}
    pack append [set $THIS->frCenter].mc [set $THIS->frCenter].mc.l {fillx left}
    pack append [set $THIS->frCenter].mc [set $THIS->frCenter].mc.e0 {expand fillx left}
    pack append [set $THIS->frCenter].mc [set $THIS->frCenter].mc.e1 {expand fillx left}
    pack append [set $THIS->frCenter].mc [set $THIS->frCenter].mc.e2 {expand fillx left}
    pack append [set $THIS->frCenter].mc [set $THIS->frCenter].mc.s {left}

    bind [set $THIS->frCenter].mc.e0 <FocusIn> "SetActiveEntry [set $THIS->frCenter].mc.e#1 0 3"
    bind [set $THIS->frCenter].mc.e1 <FocusIn> "SetActiveEntry [set $THIS->frCenter].mc.e#1 1 3"
    bind [set $THIS->frCenter].mc.e2 <FocusIn> "SetActiveEntry [set $THIS->frCenter].mc.e#1 2 3"    

    trace variable $THIS.mc(0) w TraceFloatArray
    trace variable $THIS.mc(1) w TraceFloatArray
    trace variable $THIS.mc(2) w TraceFloatArray

    frame [set $THIS->frCenter].wc
    label [set $THIS->frCenter].wc.l -text {World Coords:} -width 15
    entry [set $THIS->frCenter].wc.e0 -textvariable $THIS.wc(0) -relief sunken -width 10
    entry [set $THIS->frCenter].wc.e1 -textvariable $THIS.wc(1) -relief sunken -width 10
    entry [set $THIS->frCenter].wc.e2 -textvariable $THIS.wc(2) -relief sunken -width 10
    button [set $THIS->frCenter].wc.s -text { set } -command "$THIS.man -VertexWCoords \"\[set $THIS.wc(0)\] \[set $THIS.wc(1)\] \[set $THIS.wc(2)\]\" \[set $THIS->wmatrix\]"
    pack append [set $THIS->frCenter] [set $THIS->frCenter].wc {fillx top}
    pack append [set $THIS->frCenter].wc [set $THIS->frCenter].wc.l {fillx left}
    pack append [set $THIS->frCenter].wc [set $THIS->frCenter].wc.e0 {expand fillx left}
    pack append [set $THIS->frCenter].wc [set $THIS->frCenter].wc.e1 {expand fillx left}
    pack append [set $THIS->frCenter].wc [set $THIS->frCenter].wc.e2 {expand fillx left}
    pack append [set $THIS->frCenter].wc [set $THIS->frCenter].wc.s {left}
    bind [set $THIS->frCenter].wc.e0 <FocusIn> "SetActiveEntry [set $THIS->frCenter].wc.e#1 0 3"
    bind [set $THIS->frCenter].wc.e1 <FocusIn> "SetActiveEntry [set $THIS->frCenter].wc.e#1 1 3"
    bind [set $THIS->frCenter].wc.e2 <FocusIn> "SetActiveEntry [set $THIS->frCenter].wc.e#1 2 3"

    trace variable $THIS.wc(0) w TraceFloatArray
    trace variable $THIS.wc(1) w TraceFloatArray
    trace variable $THIS.wc(2) w TraceFloatArray

}

Tcl_Method IOM_VertexEditor -vertex_cb {d} {String} {} {
    if {[set $THIS->in_cb]} return
    set $THIS->in_cb 1
    global $THIS.mc $THIS.wc
    set mc [$d -get_VertexCoords]
    set $THIS.mc(0) [expr [lindex $mc 0]]
    set $THIS.mc(1) [expr [lindex $mc 1]]
    set $THIS.mc(2) [expr [lindex $mc 2]]
    set wc [$d -get_VertexWCoords [set $THIS->wmatrix]]
    set $THIS.wc(0) [expr [lindex $wc 0]]
    set $THIS.wc(1) [expr [lindex $wc 1]]
    set $THIS.wc(2) [expr [lindex $wc 2]]

    if {[info commands $THIS.surf] != {}} {
	set idx [$THIS.man -get_idx]
	if {[expr "$idx >= 0"]} {
	    if {[set $THIS->idx] != $idx} {
		set $THIS->idx $idx
		set surf [$THIS.man -get_VertexSurface]
		$THIS.surf -surface $surf
		set $THIS->surf $surf
	    } else {
		set surf [$THIS.surf -get_surface]
		if {$surf != [set $THIS->surf]} {
		    $THIS.man -VertexSurface $surf
		    set $THIS->surf $surf
		}
	    }
	}
    }
    set $THIS->in_cb 0
    return
}

Tcl_Method IOM_VertexEditor -camera {cam} {String} {Copy the parameter of the given camera.} {
    set rp  [$cam -get_refpoint]
    set vp  [$cam -get_viewpoint]
    set twist [$cam -get_twist]
    set angle [$cam -get_angle]
    set zfar [$cam -get_zfar]
    set znear [$cam -get_znear]
    $THIS-cam -refpoint $rp -viewpoint $vp -twist $twist -angle $angle -zfar $zfar -znear $znear
    $THIS -update
    return
}

Tcl_Method IOM_VertexEditor -object {obj} {String} {Set the manipulating object. Only the first call will accept.} {
    if {[set $THIS->old_cob] != {}} {return}
    wm title [set $THIS->tkTop] "IOM.vertex $obj"
    set $THIS->old_cob $obj
    set $THIS->matrix [$obj -get_matrix]
    set $THIS->wmatrix [$obj -get_worldMatrix]
    $THIS.sc -insert $obj
    $THIS.man -currentObject $obj
    $THIS.man -lock
}

Tcl_Method IOM_VertexEditor -update {} {} {} {
    $THIS -object [$THIS -get_currentObject]
    set $THIS->xcurrentObject [$THIS.man -get_currentObject]
    $THIS -vertex_cb $THIS.man    
    $THIS-cam -rendering
}

Tcl_Method IOM_VertexEditor ~IOM_VertexEditor {} {} {Destructor of IOM_VertexEditor} {
    global $THIS.mc $THIS.wc    
    unset $THIS.wc $THIS.mc
    delete $THIS-cam
    set clds [info commands $THIS.*]
    foreach cld $clds {
	delete $cld
    }
    catch {[set $THIS->old_cob] -matrix [set $THIS->matrix]}
}

# SplineTool

Tcl_Object IOM_SplineTool IOM_CmpTopBox {cob cb} {Name} {String} {} {
    set $THIS->cob {}
    set $THIS->cb {}
}

Tcl_Method IOM_SplineTool -callback {cb} {String} {} {
    set $THIS->cb $cb
    return
}

Tcl_Method IOM_SplineTool -object {cob} {String} {} {
    if {[set $THIS->cob] != {}} {return}
    wm title [set $THIS->tkTop] "IOM.vertex.spline $cob"
    if {![$cob -isA Curve]} {
	label [set $THIS->frCenter].info -text { Invalid object class!!! }
	pack [set $THIS->frCenter].info
	return
    }
    set $THIS->cob $cob
    button [set $THIS->frCenter].poly -text "Guid.Poly." -command "\[set $THIS->cob\] -polygon ; $THIS -do_autoUpdate"
    pack append [set $THIS->frCenter] [set $THIS->frCenter].poly {top fillx}
    if {![$cob -isA BSpline]} return
    set num 3
    set num [$cob -get_number]
    set order $num
    set order [$cob -get_order]
    scale [set $THIS->frCenter].order -label Order -from 1 -to $num -showvalue 1 -orient horizontal -sliderlength 10 -command "$THIS -do_autoUpdate ; \[set $THIS->cob\] -order"
    [set $THIS->frCenter].order set $order
    pack append [set $THIS->frCenter] [set $THIS->frCenter].order {top fillx}
    button [set $THIS->frCenter].mode -text Mode -command "\[set $THIS->cob\] -mode \[expr \!\[\[set $THIS->cob\] -get_mode\]\] ; $THIS -do_autoUpdate"
    pack append [set $THIS->frCenter] [set $THIS->frCenter].mode {top fillx}

    return
}

Tcl_Method IOM_SplineTool -update {} {} {Updates the order button.} {
    if {[set $THIS->cob] == {}} return
    if {![[set $THIS->cob] -isA BSpline]} return
    set num [[set $THIS->cob] -get_number]
    [set $THIS->frCenter].order configure -to $num
    set num [[set $THIS->cob] -get_order]
    [set $THIS->frCenter].order set $num
    if {[set $THIS->cb] != {}} {
	if {[catch [set $THIS->cb]]} {
	    set $THIS->cb {}
	}
    }    
    return
}

Tcl_Method IOM_SplineTool -do_autoUpdate {} {} {} {
    if [set $THIS->xautoUpdate] {
	after 1 $THIS -update
    }
    return
}

# SurfaceTool

Tcl_Object IOM_SurfaceTool IOM_CmpTopBox {updateCommands cb ambi diff spec emi trans shin refr _ambi _diff _spec _emi} {Name} {String} {} {
    set $THIS->cb {}
    wm title [set $THIS->tkTop] "IOM.vertex.surface"
    set path [set $THIS->frCenter]
    set $THIS->_ambi {1 1 1}
    set $THIS->_diff {1 1 1} 
    set $THIS->_spec {0 0 0} 
    set $THIS->_emi {0 0 0}
    set $THIS->ambi {{1 1 1}}
    set $THIS->diff {{1 1 1}}
    set $THIS->spec {{0 0 0}}
    set $THIS->emi {{0 0 0}}
    set $THIS->trans 1
    set $THIS->shin 1
    set $THIS->refr 0
    set a [set $THIS->xautoUpdate]
    set $THIS->xautoUpdate 0
    append $THIS->updateCommands [rgb_scale $path.f0 Ambient "set $THIS->_ambi" "$THIS -do_autoUpdate ; set $THIS->ambi"]
    append $THIS->updateCommands [rgb_scale $path.f1 Diffuse "set $THIS->_diff" "$THIS -do_autoUpdate ; set $THIS->diff"]
    append $THIS->updateCommands [rgb_scale $path.f2 Specular "set $THIS->_spec" "$THIS -do_autoUpdate ; set $THIS->spec"]
    append $THIS->updateCommands [rgb_scale $path.f3 Emission "set $THIS->_emi" "$THIS -do_autoUpdate ; set $THIS->emi"]
    append $THIS->updateCommands [s_scale $path.f4 Transmission "set $THIS->trans" "$THIS -do_autoUpdate ; set $THIS->trans"]
    append $THIS->updateCommands [s_scale $path.f6 Refraction "set $THIS->refr" "$THIS -do_autoUpdate ; set $THIS->refr"]
    append $THIS->updateCommands [s_scale $path.f5 Shininess "set $THIS->shin" "$THIS -do_autoUpdate ; set $THIS->shin"]
    eval [set $THIS->updateCommands]
    set $THIS->xautoUpdate $a
}

Tcl_Method IOM_SurfaceTool -surface {surf} {String} {} {
    set $THIS->_ambi [lindex $surf 0]
    set $THIS->_diff [lindex $surf 1]
    set $THIS->_spec [lindex $surf 2]
    set $THIS->_emi [lindex $surf 3]
    set $THIS->trans [lindex $surf 4]	
    set $THIS->refr [lindex $surf 5]	
    set $THIS->shin [lindex $surf 6]	
    set $THIS->ambi [list [set $THIS->_ambi]]
    set $THIS->diff [list [set $THIS->_diff]]
    set $THIS->spec [list [set $THIS->_spec]]
    set $THIS->emi [list [set $THIS->_emi]]
    eval [set $THIS->updateCommands]
    return
}

Tcl_Method IOM_SurfaceTool -get_surface {} {} {} {
    set l "[set $THIS->ambi] [set $THIS->diff] [set $THIS->spec] [set $THIS->emi] [set $THIS->trans] [set $THIS->refr] [set $THIS->shin]"
    return $l
}

Tcl_Method IOM_SurfaceTool -callback {cb} {String} {} {
    set $THIS->cb $cb
}

Tcl_Method IOM_SurfaceTool -do_autoUpdate {} {} {} {
    if {[set $THIS->xautoUpdate]} {
	after 1 $THIS -update
    }
    return
}

Tcl_Method IOM_SurfaceTool -update {} {} {} {
    if {[set $THIS->cb] != {}} {
	if {[catch [set $THIS->cb]]} {
	    set $THIS->cb {}
	}
    }    
    return
}
