################################################################################
##  The father class of all IOM boxes.                                        ##  
##  LAST EDIT: Thu Aug  4 11:03:49 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_InterfaceDevice ?

Tcl_Object IOM_TopBox IOM_InterfaceDevice {tkTop tkPath frTop frCenter frBottom} {Name} {String} \
	{Creates a new box called {ARG 1 Name} with some frame widgets inside the toplevel widged.} \
	{
    # check if the box needs a TOP widget
    global IOM_NEED_TOP
    if !$IOM_NEED_TOP {
	set IOM_NEED_TOP 1
	frame .$Name
	pack append . .$Name {fill expand}
	set $THIS->tkTop .
    } {
	toplevel .$Name
	wm title .$Name " "
	wm minsize .$Name 10 10
	wm maxsize .$Name 1200 1024 
	wm protocol .$Name WM_DELETE_WINDOW "delete $Name"
	set $THIS->tkTop .$Name
    }
    
    frame    .$Name.topBox
    pack append .$Name .$Name.topBox {fill expand}
    set $THIS->tkPath .$Name.topBox

    # create the following widget structure:

    ##########################
    #         frTOP          #
    ##########################
    #        frCenter        #
    ##########################
    #        frBOTTOM        #
    ##########################

    set $THIS->frTop    [nullframe [set $THIS->tkPath].top top fillx]
    set $THIS->frCenter [nullframe [set $THIS->tkPath].frCenter top]
    set $THIS->frBottom [nullframe [set $THIS->tkPath].bottom top fillx]
}

Tcl_Method IOM_TopBox -buildCurrentObjectLabel {} {} {Build the label widget to the current object variable of this box } {
    set top [set $THIS->frTop] 
    label $top.object1 -text "Object:" -anchor e
    label $top.object2 -textvariable $THIS->xcurrentObject -anchor w
    pack append $top \
	    $top.object1  {expand left fill} \
	    $top.object2  {expand right fill}
    
}

Tcl_Method IOM_TopBox ~IOM_TopBox {} {} {The destructor of TopBox} {
    if [string compare  [set $THIS->tkTop] "." ] {
	bind [set $THIS->tkTop] <Destroy> ""
        catch "destroy [set $THIS->tkTop]"
    } exit
}

IOM_TopBox -description {The abstract IOM-InterfaceBox for all toplevel interfaces.}

IOM_TopBox -keywords {IOM User-Interface}

# The advanced top box class.
#
# Create the global variable IOM_userInterfaceMode.
# This variable has 3 values 0 (novice), 1 (normal) and 2 (expert)
 
if ![string length [info vars IOM_userInterfaceMode]] {set IOM_userInterfaceMode 0}

Tcl_Object IOM_CmpTopBox IOM_TopBox {menuFile} {Name} {String} {Creates a new box called {ARG 1 Name}. With a menubar and useful buttons} {
    set top [set $THIS->frTop]
    frame $top.menu -relief raised -border 2
    pack $top.menu -expand 1 -fill both

    # build the options menu:
    $THIS -addMenu options Options
    $THIS -addMenuEntry options "Close" "delete $THIS"
    $THIS -addMenuCheckButton options "Auto Update" $THIS->xautoUpdate

    $THIS -addButton update Update "$THIS -update; $THIS -callCBs"
    $THIS -addButton quit Close "delete $THIS"

    # build the help menu:
    $THIS -addMenu help Help
    $THIS -addMenuEntry help "Help" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage [$THIS -get_class]"
}

# some utility functions to build menus and buttons:

Tcl_Method IOM_CmpTopBox -addButton {Name Text Commands} {String String String} \
	{Bind the {ARG 3 Commands} to a new Button with the name {ARG 1 Name} and the label {ARG 2 Text}} {
    
    button [set $THIS->frBottom].$Name -text "$Text" -command "$Commands"
    pack append [set $THIS->frBottom]  [set $THIS->frBottom].$Name\
	    {left fillx expand}
}

Tcl_Method IOM_CmpTopBox -addMenu {Name Text} {String String} \
	{Create the {ARG 3 Menu} with the label {ARG 2 Text}} {
    set path [set $THIS->frTop].menu
    menubutton $path.$Name -text "$Text" -menu $path.$Name.menu
    
    # rebuild the bindings for the menubar
    
    # get the list of menubuttons an menus 
    set mbuttons [info commands $path.* ]
    
    # kill the menu widgets in the widget list
    regsub -all {[^ ]*\.menu } "$mbuttons " " " mbuttons 
    eval "tk_menuBar $path $mbuttons"
    
    
    menu $path.$Name.menu
    pack append $path  $path.$Name\
	    {left fillx}
    
}

Tcl_Method IOM_CmpTopBox -addMenuLeft {Name Text} {String String} \
	{Create the {ARG 3 Menu} with the label {ARG 2 Text} on the begin of the menubar.} {
    
    set path [set $THIS->frTop].menu
    menubutton $path.$Name -text "$Text" -menu $path.$Name.menu
    
    # rebuild the bindings for the menubar
    
    # get the list of menubuttons an menus 
    set mbuttons [info commands $path.* ]
    
    # kill the menu widgets in the widget list
    regsub -all {[^ ]*\.menu } "$mbuttons " " " mbuttons 
    eval "tk_menuBar $path $mbuttons"
    
    menu $path.$Name.menu
    set firstMenu [lindex [pack info $path] 0]
    
    if {""!="$firstMenu"} {
	pack before $firstMenu $path.$Name\
		{left fillx}
    } {
	pack append $path  $path.$Name\
		{left fillx}
    }
}

Tcl_Method IOM_CmpTopBox -addMenuEntry {Name Text Commands} {String String String} \
	{Bind the {ARG 3 Commands} to a new Menuentry with the label {ARG 2 Text} at the menu {ARG 1 Name} } {
    set menu [set $THIS->frTop].menu.$Name.menu
    $menu add command -label "$Text" -command "$Commands"
}

Tcl_Method IOM_CmpTopBox -addMenuSeparator {Name} {String} \
	{Build a separator in the menu {ARG 1 Name} } {
    
    set menu [set $THIS->frTop].menu.$Name.menu
    $menu add separator
}

Tcl_Method IOM_CmpTopBox -addMenuCheckButton {Name Text Variable} {String String String} \
	{Bind the {ARG 3 Variable} to a new Menuentry from type checkbutton with the label {ARG 2 Text} at the menu {ARG 1 Name} } {
    
    set menu [set $THIS->frTop].menu.$Name.menu
    $menu add checkbutton -label "$Text" -variable $Variable
}

Tcl_Method IOM_CmpTopBox -addMenuRadioButton {Name Text Variable Value} {String String String String} \
	{Bind the {ARG 4 Value} to a new Menuentry from type ratiobutton with the label {ARG 2 Text} and the {ARG 3 Variable} at the menu {ARG 1 Name} } {
    
    set menu [set $THIS->frTop].menu.$Name.menu
    $menu add radiobutton -label "$Text" -variable $Variable -value $Value
}

IOM_CmpTopBox -description {The extended ToplevelBox for IOM-Interfaces, with some menu and action buttons.}

IOM_CmpTopBox -keywords {IOM Userinterface}
