################################################################################
##  A tool for creating primitive objects.                                    ##  
##  LAST EDIT: Thu Aug  4 10:25:04 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_TopBox ?

Tcl_Object IOM_ClassesBox IOM_TopBox {descriptionPath sectionsListPath classesListPath} {Name} {String} \
	{Creates a new Class browser box called {ARG 1 Name}.} {
    wm minsize . 300 300
    wm maxsize . 1024 1024
    wm title [set $THIS->tkTop] "IOM.create"
    
    set path [set $THIS->frCenter]
    frame $path.sectionDescription -border 10
    frame $path.list  -relief raised 
    pack append $path  \
	    $path.sectionDescription {fill}\
	    $path.list {expand fill}

    # build the description field
    text $path.sectionDescription.message -height 4 -wrap word -relief sunken -border 1
    bind $path.sectionDescription.message <Any-Key> { } 
    bind $path.sectionDescription.message <Any-Button> { } 
    
    pack append $path.sectionDescription\
	    $path.sectionDescription.message {fill expand} 
    set $THIS->descriptionPath  $path.sectionDescription.message
    
    ## build the list boxes:                
    # build the sections list:

    frame $path.list.sections  -relief sunken -border 2
    frame $path.list.sections.label  -relief flat -border 4
    frame $path.list.sections.list -relief flat -border 4
    
    label $path.list.sections.label.l -text Sections -border 1
    
    pack append  $path.list.sections.label  $path.list.sections.label.l {fill}
    pack append $path.list  $path.list.sections {expand fill}
    pack append $path.list.sections \
	    $path.list.sections.label {fill} \
	    $path.list.sections.list {expand fill} 
    listbox $path.list.sections.list.box -relief sunken -border 1\
	    -yscrollcommand "$path.list.sections.list.sbar.f.sb set"\
	    -exportselection {false}
    frame  $path.list.sections.list.sbar -relief sunken -border 1
    frame  $path.list.sections.list.sbar.f -borderw 4
    pack $path.list.sections.list.sbar.f -fill both -expand 1 
    scrollbar $path.list.sections.list.sbar.f.sb  -relief raised -width 10\
	    -command "$path.list.sections.list.box yview"
    pack $path.list.sections.list.sbar.f.sb -fill both -expand 1
    
    pack append $path.list.sections.list \
	    $path.list.sections.list.box {fill expand left}\
	    $path.list.sections.list.sbar {filly right}
    
    set $THIS->sectionsListPath $path.list.sections.list.box
    
    # build the classes list:
    
    frame $path.list.classes  -relief sunken -border 2
    frame $path.list.classes.label  -relief flat -border 4
    frame $path.list.classes.list -relief flat -border 4 -width 100
    
    label $path.list.classes.label.l -text Classes -border 1
    
    pack append  $path.list.classes.label  $path.list.classes.label.l {fill}
    pack append $path.list  $path.list.classes {expand fill}
    pack append $path.list.classes \
	    $path.list.classes.label {fill} \
	    $path.list.classes.list {expand fill} 
    
    listbox $path.list.classes.list.box -relief sunken -border 1\
	    -yscrollcommand "$path.list.classes.list.sbar.f.sb set"\
	    -exportselection {false}
    frame  $path.list.classes.list.sbar -relief sunken -border 1
    frame  $path.list.classes.list.sbar.f -borderw 4
    pack $path.list.classes.list.sbar.f -fill both -expand 1 
    scrollbar $path.list.classes.list.sbar.f.sb  -relief raised -width 10\
	    -command "$path.list.classes.list.box yview"
    pack $path.list.classes.list.sbar.f.sb -fill both -expand 1
    
    pack append $path.list.classes.list \
	    $path.list.classes.list.box {fill expand left}\
	    $path.list.classes.list.sbar {filly right}
    set $THIS->classesListPath $path.list.classes.list.box
    
    pack append $path.list\
	    $path.list.sections {left fill expand} \
	    $path.list.classes {left fill expand}
    
    # bind the listboxes:
    
    set sectionPath [set $THIS->sectionsListPath]
    tk_listboxSingleSelect $sectionPath
    bind  $sectionPath <1> "$THIS -sectionsButtonCallback \[$sectionPath  nearest %y\]"
    
    set classPath [set $THIS->classesListPath]
    tk_listboxSingleSelect $classPath
    bind  $classPath <Double-1> "$THIS -classesButtonCallback \[$classPath  nearest %y\]"

    ## build the buttons:
    
    # get the path: 
    set path [set $THIS->frBottom]
    # the rescan button:
    button $path.bRescan -text "Scan" \
	-command "$THIS -scan"
    # the create button:
    button $path.bcObj -text "Create Object" \
	-command "$THIS -createObject" 
    # the manpage button:
    button $path.bcMan -text "Manpage" \
	-command "$THIS -manpage"
    # the quit button:
    button $path.bQuit -text "Close" \
	-command "delete $THIS" 
    pack append $path \
	    $path.bRescan {left fill expand}\
            $path.bcObj {left fill expand}\
            $path.bcMan {left fill expand}\
            $path.bQuit {left fill expand}
    
    catch "$THIS -scan"
}

Tcl_Method IOM_ClassesBox  -scan {} {}  {Scan the files in YART/cls.} { 
    global env
    
    [set $THIS->classesListPath] delete 0 end
    set path [set $THIS->sectionsListPath]
    $path delete 0 end
    
    # the C++ sections:
    set sections [RT_primitiveClasses]
    foreach sec $sections {
	    $path insert end "[lindex $sec 0]" 
    }

    # the Tcl sections:
    set sections [glob -nocomplain $env(GOOD_ROOT_DIR)/classes/*]
    foreach file $sections {
	regsub $env(GOOD_ROOT_DIR)/classes/ $file "" name
	if [file isdirectory $file] {
	    $path insert end "$name"
	}
    }
}

Tcl_Method IOM_ClassesBox  -scanClasses {Section} {String}  {Scan the classes in the section directory.} { 
    global env
    
    set path [set $THIS->classesListPath]
    $path delete 0 end
    
    if [file isdirectory  $env(GOOD_ROOT_DIR)/classes/$Section] {
	if  [file exist \
		$env(GOOD_ROOT_DIR)/classes/$Section/description] {
	    set file \
		    [open  $env(GOOD_ROOT_DIR)/classes/$Section/description]
	    set text  [read $file]
	    close $file
	} { 
	    set text "Sorry there is no file $env(GOOD_ROOT_DIR)/classes/$Section/description"
	}
	
	$THIS -setSectionDescription "$Section:\n\n$text"
	
	set files [glob -nocomplain \
		$env(GOOD_ROOT_DIR)/classes/$Section/*.cls]
	regsub -all {[^/ ]*/} $files "" files
	foreach file $files {
	    if [regsub "\.cls" $file "" name] {
		$path insert end $name
	    }
	}
    } {
	set sections [RT_primitiveClasses]
	foreach sec $sections {
	    if {"[lindex $sec 0]"=="$Section"} {
		$THIS -setSectionDescription "$Section:\n\n[lindex $sec 1]"
		foreach cls [lindex $sec 2] {
		    $path insert end $cls
		}
	    }
	}
	
    }
}

Tcl_Method IOM_ClassesBox  -buildObjectDialog {Section Class} {String String}  {Build a new Object of the {ARG 2 Class} in the {ARG 1 Section}.} { 
    global env
    # if this class is not defined read the definition file
    if [file exist $env(GOOD_ROOT_DIR)/classes/$Section/$Class.cls] {
	set tcl_class 1
	if [catch "source \
		$env(GOOD_ROOT_DIR)/classes/$Section/$Class.cls" out] {
	    ErrorBox $out
	    return
	}
    } { set tcl_class 0}
    
    if [catch "$THIS -call $Class ?" description] {
	if $tcl_class {
	    rt_Output -error "Error in $THIS -buildObjectDialog: There is no class: $Class ! Check your definitions in $env(GOOD_ROOT_DIR)/classes/$Section/$Class.cls." } {rt_Output -error "Error in $THIS -buildObjectDialog: There is no class: $Class ! Check the internal package $Section !"}
	}
	
    regexp "\{\[^\}\]*\}" $description args
    regsub "\{" $args "" args
    regsub "\}" $args "" args
	
    regsub "\{" $description "" description
    regsub "\[^\}\]*\}" $description "" description
    regsub "\{" $description "" description

    regsub "\}\$" $description "" description
    
    # set the default:
    global inputBox
    set inputBox(defaultString) "$Class "
    
    set ret [InputBoxOne "$description\n\n$Class $args" "" ""  "" "IOM.object"  ]
 
    if [string length $ret] {
    # There is no TCL_ERROR if the object creating fails
    # in the class command. Therefore we must check the 
    # object command after creating.
	    
    # TODO:
    # if [catch "$THIS -call $ret" message] {
    #    rt_Output -error $message; return}

        if [catch $ret message] {rt_Output -error $message; return}
	    
        set obj [lindex $ret 1]
	    
        # check if the object is created:
        if ![string length [$THIS -call info commands $obj]]\
	    {rt_Output -error $message; return}
		
        if [catch "$THIS -call $obj -father .i"] { rt_Output -error $out }
    }
}

Tcl_Method IOM_ClassesBox  -sectionsButtonCallback y Integer { This is an internal method. The button action in the sectiones list. The {ARG 1 y} value ist the y-position of the mouse pointer.} {
    set sectionPath [set $THIS->sectionsListPath]
    $sectionPath select from   $y
    $sectionPath select to   $y
    set sectionName [$sectionPath get [$sectionPath curselection]]
    if [string length $sectionName] {$THIS -scanClasses $sectionName}
}

Tcl_Method IOM_ClassesBox  -classesButtonCallback y Integer { This is an internal method. The button action in the classes list. The {ARG 1 y} value ist the y-position of the mouse pointer.} {
    set sectionPath [set $THIS->sectionsListPath]
    set classPath [set $THIS->classesListPath]
    $classPath select from   $y
    $classPath select to   $y
    $THIS -createObject
}

Tcl_Method IOM_ClassesBox  -createObject {} {} {The create object button action.} {
    set sectionPath [set $THIS->sectionsListPath]
    set classPath [set $THIS->classesListPath]
    
    if [catch "$sectionPath get [$sectionPath curselection]" sectionName] {
	ErrorBox "\nPlease select first a section!"
	return
    }
    if [catch "$classPath get [$classPath curselection]" className] {
	ErrorBox "\nPlease select first a class!"
	return
    }
    $THIS -buildObjectDialog $sectionName $className
    
}
Tcl_Method IOM_ClassesBox  -manpage {} {} {Show the object's description in the man page viewer.} {
    set sectionPath [set $THIS->sectionsListPath]
    set classPath [set $THIS->classesListPath]
    
    if [catch "$sectionPath get [$sectionPath curselection]" sectionName] {
	ErrorBox "\nPlease select first a section!"
	return
    }
    if [catch "$classPath get [$classPath curselection]" className] {
	ErrorBox "\nPlease select first a class!"
	return
    }
    $THIS -buildInterfaceDevice IOM_ManualBox _i.man
    _i.man -manpage $className
    
}

Tcl_Method IOM_ClassesBox  -setSectionDescription Text String {Put the contens of the {ARG 1 Text} in the description widget.} {
    set path [set $THIS->descriptionPath]
    $path delete 0.0 end
    $path insert 0.0 $Text
}

IOM_ClassesBox  -description {The interface box to create new objects from YART-Primitv classes, inside the IOM-Interface.}

IOM_ClassesBox  -keywords {IOM Userinterface}
