////////////////////////////////////////////////////////////////////////////////
//  The rtsh clone for stereo camera viewing. Note: the "mono class commands" //
//  will be overloaded to use the stereo version. Thus, YART scene files do   //
//  not have to be changed.                                                   //  
//  LAST EDIT: Fri Aug  5 09:09:22 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "stereo.C"

int fileF;
char *fileV;

RT_ParseEntry ParameterTable[] = {
    { "-file", RTP_STRING, (char*)&fileV, &fileF, "Specify a file for loading.", "FILE" },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int main(int , char *argv[]) {
    RT_init();
    
    RTM_command( RTN_LOOKAT_CAMERA, RT_StereoLookatCamera::classCMD );
    RTM_command( RTN_PIXMAP_DISPLAY, RT_StereoPixmapDisplay::classCMD );

    RT_parseTable( argv, ParameterTable );

    if (fileF && (Tcl_EvalFile ( rt_Ip, fileV ) == TCL_ERROR )) {
	rt_Output->errorVar( "Load Error! ", rt_Ip->result, 0 );
	exit( 1 );
    }

    rt_InputServer->loop();
}

