////////////////////////////////////////////////////////////////////////////////
//  Definitions of stereo classes for usage with SGI GL.                      //  
//  LAST EDIT: Fri Aug  5 08:57:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

class RT_StereoPixmapDisplayData {
  public:
    long id;
    int left, middle, right;
};

extern const char *RTN_STEREO_PIXMAP_DISPLAY;

class RT_StereoPixmapDisplay:public RT_Pixmap  {
    friend class RT_StereoPixmapDisplayData;
    RT_StereoPixmapDisplayData *data;
    int xmaxscreen,ymaxscreen;
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int sglF, dblF;
  protected:
    int sglBuf;  
    int objectCMD(char *[]);
  public:
    void print(FILE *f) const {
	printCon(f);
	fprintf( f, "\n%s %s\n", get_name(), sglBuf ? "-singlebuffer" : "-doublebuffer" );
    }
    //#### public methods:
    RT_StereoPixmapDisplay(char *_name, int , int);
    ~RT_StereoPixmapDisplay();
    const char *get_class() const { return RTN_STEREO_PIXMAP_DISPLAY; }
    int isA(const char*) const;
    const char *get_description() const { return "A pixmap for immediate stereo display." ; }
    void putPixel(int, int, const RT_Color&);
    virtual RT_Color getPixel(int, int);
    void clear(const RT_Color &);
    void singlebuffer();
    void doublebuffer();
    void event();
    void activate();
    void activate_left();
    void activate_right();
    //#### the Tcl methods:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
};

extern const char *RTN_STEREO_LOOKAT_CAMERA;

class RT_StereoLookatCamera:public RT_LookatCamera {
  static RT_ParseEntry table[];
  //#### the statics for parameter parsing:
  static int eyeF, eyeG;
  static double eyeV;
public:
  RT_StereoLookatCamera(char *_n, RT_Vector &_vp, RT_Vector &_rp);
  int objectCMD(char *[]);

  double xconf,xeye;
  void eyeDistance(double v) {xeye=v;}
  double get_eyeDistance() const {return xeye;}

  void shading(); // platform dependend shading/rendering
  void rendering(); 
  //#### the Tcl methods:
  static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
};



