////////////////////////////////////////////////////////////////////////////////
//  Implementation of stereo classes.                                         //  
//  LAST EDIT: Fri Aug  5 09:09:23 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <malloc.h>
#include <math.h>
#include <gl.h>
#include <gl/get.h>
#include <gl/device.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

const char *RTN_STEREO_PIXMAP_DISPLAY = "StereoPixmapDisplay";

// at first some definitions from the libstereo on sgi irix 4.05

// Re-defined in on_stereo; in the future, should be initialized by a
// call to getgdesc().

static int YMAXSTEREO = (-1);
static int YOFFSET = (-1);

static int old_monitor_mode = (-1);

void stereo_on() {
    YMAXSTEREO = 491;
    YOFFSET = 532;

    /* If stereo is supported... */
    if (getgdesc(GD_STEREO))
	{
	    /* save old monitor mode (normally HZ60) */
	    old_monitor_mode = (int) getmonitor();
	    
	    if (old_monitor_mode != STR_RECT)
		{
		    setmonitor(STR_RECT);
		    
		    /* Constrain mouse to lower half of screen while in stereo mode */
		    setvaluator(MOUSEY, YMAXSTEREO/2, 0, YMAXSTEREO);
		}
	}
}

void stereo_off() {
    int mousey;
    
    if (old_monitor_mode != (-1) && old_monitor_mode != STR_RECT) {
	setmonitor(old_monitor_mode);
	mousey = (int) getvaluator(MOUSEY);
	setvaluator(MOUSEY, mousey, 0, (int) getgdesc(GD_YPMAX));
    }
}

void stereopersp(int fovy, float aspect, float near, float far, float conv, float eye) {
    float left, right, top, bottom;
    float gltan;
    
    gltan = tan(fovy/2.0/10.0*M_PI/180.0);
    
    top = gltan * near;
    
    bottom = -top;

    gltan = tan(fovy*aspect/2.0/10.0*M_PI/180.0);

    left = -gltan*near - eye/conv*near;
    right = gltan*near - eye/conv*near;

    window(left, right, bottom, top, near, far);

    translate(-eye, 0.0, 0.0);
}

// YART definitions for stereo viewing:

#include "stereo.h"

// the stereo pixmap: 

RT_StereoPixmapDisplay::RT_StereoPixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {
    xmaxscreen = getgdesc(GD_XPMAX);
    ymaxscreen = getgdesc(GD_YPMAX);
    w=xmaxscreen;
    h=ymaxscreen;

    prefposition(0, xmaxscreen, 0, ymaxscreen);     

    data = new RT_StereoPixmapDisplayData;
    foreground();
    data->id = winopen( _name );
    RGBmode();
    zbuffer( 1 );
    ::doublebuffer();
    sglBuf = 0;
    gconfig();
    concave(1);
    qreset();
    qdevice( ESCKEY );
    qdevice( WINQUIT );

    qdevice( LEFTSHIFTKEY );
    qdevice( RIGHTSHIFTKEY );
    qdevice( CTRLKEY );
    qdevice( LEFTALTKEY );
    qdevice( RIGHTALTKEY );
    
    qdevice( LEFTMOUSE );
    qdevice( MIDDLEMOUSE );
    qdevice( RIGHTMOUSE );
    qdevice( MOUSEX );
    qdevice( MOUSEY );
    qdevice(SBPERIOD);
    qdevice(SBTX);
    qdevice(SBTY);
    qdevice(SBTZ);
    qdevice(SBRX);
    qdevice(SBRY);
    qdevice(SBRZ);
    qdevice(SBBUT1);
    qdevice(SBBUT2);
    qdevice(SBBUT3);
    qdevice(SBBUT4);
    qdevice(SBBUT5);
    qdevice(SBBUT6);
    qdevice(SBBUT7);
    qdevice(SBBUT8);
    qdevice(SBPICK);
    data->left = data->middle = data->right = 0;
    stereo_on();
}

RT_StereoPixmapDisplay::~RT_StereoPixmapDisplay() {
    winclose( data->id ); delete data; stereo_off();
}   

// the activate methodes for the right and left eys
void RT_StereoPixmapDisplay::activate() { 
    winset( data->id ); readsource(SRC_FRONT);
    viewport(0, xmaxscreen, 0,ymaxscreen ); }

void RT_StereoPixmapDisplay::activate_left() { 
    winset( data->id ); readsource(SRC_FRONT); 
    viewport(0, xmaxscreen, YOFFSET,YOFFSET+YMAXSTEREO ); 
    //    viewport(0, xmaxscreen,  ymaxscreen/2,ymaxscreen ); 
}

void RT_StereoPixmapDisplay::activate_right() { 
    winset( data->id ); readsource(SRC_FRONT);
    viewport(0, xmaxscreen, 0, YMAXSTEREO);
    //    viewport(0, xmaxscreen, 0, ymaxscreen/2);
}

void RT_StereoPixmapDisplay::clear(const RT_Color &x) { 
    char rgb[4]; 
    rgb[3]=(int)(x.r * 255);
    rgb[2]=(int)(x.g * 255);
    rgb[1]=(int)(x.b * 255);
    rgb[0]=0;
    long *cval = (long*)rgb;
    long zval = getgdesc(GD_ZMAX);
    ::czclear(*cval, zval); zclear(); 
}

void RT_StereoPixmapDisplay::singlebuffer() { 
    ::singlebuffer(); gconfig(); sglBuf = 1; 
}

void RT_StereoPixmapDisplay::doublebuffer() { 
    ::doublebuffer(); gconfig(); sglBuf = 0; 
}

RT_Color RT_StereoPixmapDisplay::getPixel(int _x, int _y) {
    if (!checkIndices( _x, _y)) return RT_Color( 0,0,0);
    unsigned long val[1];
    lrectread(_x, _y, _x, _y, val );
    return RT_Color( *val );
}

void RT_StereoPixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    unsigned long u = (unsigned long)(colr);
    frontbuffer( 1 );
    lrectwrite( x, y, x, y, &u );
    frontbuffer( 0 );
}

void RT_StereoPixmapDisplay::event() {
    short val;
    RT_Event *event = NULL;
    if (qtest()) {
	switch (qread( &val )) {

	  case ESCKEY:
	  case WINQUIT:
	    stereo_off();
	    exit(1);
	    
	    // the point events

	  case LEFTMOUSE:
	  case MIDDLEMOUSE:
	  case RIGHTMOUSE: {
	    RT_ButtonEvent *pev = new RT_ButtonEvent;
	    Device mdev[2];
	    mdev[0] = MOUSEX; mdev[1] = MOUSEY; 
	    pev->left   = (int) getbutton( LEFTMOUSE );
	    pev->middle = (int) getbutton( MIDDLEMOUSE );
	    pev->right  = (int) getbutton( RIGHTMOUSE );
	    pev->shift  = (int) getbutton( LEFTSHIFTKEY	) || getbutton( RIGHTSHIFTKEY  ); 
	    pev->ctrl   = (int) getbutton( CTRLKEY );
	    pev->alt    = (int) getbutton( LEFTALTKEY ) || getbutton( RIGHTALTKEY ); 

	    long ox, oy;
	    short xy[2];
	    getorigin( &ox, &oy );
	    getsize( (long *) &pev->w, (long *) &pev->h );
	    getdev( 2, mdev, xy );
	    pev->x = ( xy[0]-(int)ox);  
	    pev->y = ( xy[1]-(int)oy); 
	    event = (RT_Event*) pev;
	    break; }

	  case MOUSEX:
	  case MOUSEY:
	    {
	    RT_MotionEvent *pev = new RT_MotionEvent;
	    Device mdev[2];
	    mdev[0] = MOUSEX; mdev[1] = MOUSEY; 
	    pev->left   = (int) getbutton( LEFTMOUSE );
	    pev->middle = (int) getbutton( MIDDLEMOUSE );
	    pev->right  = (int) getbutton( RIGHTMOUSE );
	    pev->shift  = (int) getbutton( LEFTSHIFTKEY	) || getbutton( RIGHTSHIFTKEY  ); 
	    pev->ctrl   = (int) getbutton( CTRLKEY );
	    pev->alt    = (int) getbutton( LEFTALTKEY ) || getbutton( RIGHTALTKEY ); 

	    long ox, oy;
	    short xy[2];
	    getorigin( &ox, &oy );
	    getsize( (long *) &pev->w, (long *) &pev->h );
	    getdev( 2, mdev, xy );
	    pev->x = ( xy[0]-(int)ox);  
	    pev->y = ( xy[1]-(int)oy); 
	    event = (RT_Event*) pev;
	    break; }

	  // the spaceball events:
	  case SBTX: {
            /*
	     * The spaceball events are put in the queue in the
	     * following order: SBTX,SBTY,SBTZ,SBRX,SBRY,SBRZ,SBPERIOD.
	     */
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->transX = val/127;
	    qread(&val);
	    sbev->transY = val/127;
	    qread(&val);
	    sbev->transZ = val/127;
	    qread(&val);
	    sbev->twistX = val/127;
	    qread(&val);
	    sbev->twistY = val/127;
	    qread(&val);
	    sbev->twistZ = val/127;
	    qread(&val);
	    sbev->period = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT1: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b1 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT2: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b2 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT3: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b3 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT4: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b4 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT5: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b5 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT6: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b6 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT7: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b7 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBBUT8: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->b8 = val;
	    event = (RT_Event *) sbev;
	    break; }
	  case SBPICK: {
	    RT_SpaceballEvent *sbev = new RT_SpaceballEvent;
	    sbev->pick = val;
	    event = (RT_Event *) sbev;
	    break; }
	};	
	if (event) {
	    if (get_camera()) get_camera()->event( *event );
	    delete event;
	}
    }
}

int RT_StereoPixmapDisplay::sglF, RT_StereoPixmapDisplay::dblF;

RT_ParseEntry RT_StereoPixmapDisplay::table[] = {
    { "-singlebuffer", RTP_NONE, 0, &sglF, "Switch into singlebuffer mode.", RTPS_NONE },
    { "-doublebuffer", RTP_NONE, 0, &dblF, "Switch into doublebuffer mode.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_StereoPixmapDisplay::objectCMD(char *argv[]) { 
    int ret = RT_Pixmap::objectCMD( argv );
    RT_parseTable( argv, table );
    if (sglF) singlebuffer();
    if (dblF) doublebuffer();
    return ret + sglF + dblF;
}

int RT_StereoPixmapDisplay::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res = _classCMD( cd, ip, argc, argv );
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", RTN_STEREO_PIXMAP_DISPLAY, " {String Integer Integer} { Creates a new pixmap. {ARG 1 Name} of the new object, {ARG 2 Width}, {ARG 3 Height}.}}", 0 );
	return TCL_OK;
    }

    if (res == TCL_OK) {
	if (argc != 4) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <width> <height>. ", NULL );
	    return TCL_ERROR;
	}
	int w, h;
	if ( !RT_string2int( argv[2], w ) || !RT_string2int( argv[3], h )) {
	    Tcl_AppendResult( ip, "Bad parameters. <width> <height> must be integers. ", NULL );
	    return TCL_ERROR;
	}
	
	new RT_StereoPixmapDisplay( argv[1], w, h ); 

	return TCL_OK;
    }
    return res; 
}

int RT_StereoPixmapDisplay::isA(const char *_c) const {
    if ( RTM_isA(_c, RTN_STEREO_PIXMAP_DISPLAY )) return 1;
    return RT_Pixmap::isA( _c );
}

// stereo camera:

// GL_LightNumber define the number of the next light
// 0 <= GL_LightNumber < MAXLIGHTS  
extern int GL_LightNumber;

int RT_StereoLookatCamera::eyeF, RT_StereoLookatCamera::eyeG;
double RT_StereoLookatCamera::eyeV;

RT_ParseEntry RT_StereoLookatCamera::table[] = {
    { "-eyeDistance", RTP_DOUBLE , (char*)&eyeV, &eyeF, 
	  "Set the {ARG 1 Value} to the eye distance.", RTPS_DOUBLE },
    { "-get_eyeDistance", RTP_NONE , 0, &eyeG, 
	  "Get the eye distance.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_StereoLookatCamera::objectCMD(char *argv[]) { 
    char resultString[30];
   int ret = RT_LookatCamera::objectCMD( argv );
    RT_parseTable( argv, table );
    if (eyeF) eyeDistance(eyeV);
    if (eyeG) {
	RT_double2string(get_eyeDistance(),resultString);
	RT_Object::result( resultString ); 
    }
    return ret + eyeF + eyeG;
}

RT_StereoLookatCamera::RT_StereoLookatCamera(char *_n, RT_Vector &_vp, RT_Vector &_rp)
:RT_LookatCamera(_n, _vp, _rp) {
    xeye = 0.125;
    xconf= 6.0;
}

void RT_StereoLookatCamera::rendering() {
    computeLookatMatrix();
    switch (xmode) {
      case RTE_LC_SHADING:
	if (!get_pixmap() || !get_scene()) return;
	shading();
	break;
    }
}

void RT_StereoLookatCamera::shading() {
    if (!get_pixmap() || !get_scene()) return;
    float lm[7];
    int i;
    RT_RenderLightFunc lfunc;
    RT_RenderPrimitiveFunc pfunc;
    mmode(MVIEWING);
    blendfunction(BF_ONE,BF_ZERO);
    if (xpixmap) {
	((RT_StereoPixmapDisplay*) xpixmap)->activate(); 
	if (xscene) xpixmap->clear( xscene->get_background() ); } 
    if (xscene) xscene->update();
    feedback->update();
    xconf =  (vp.x-rp.x)*(vp.x-rp.x)
	    +(vp.y-rp.y)*(vp.y-rp.y)
	    +(vp.z-rp.z)*(vp.z-rp.z);
    if (xconf != 0.0) xconf = sqrt(xconf);

    // draw left
    pushmatrix();
    if (xpixmap) {
	((RT_StereoPixmapDisplay*) xpixmap)->activate_left();
	//xpixmap->clear( xscene()->get_background());
    }
    lookat( vp.x, vp.y, vp.z, rp.x, rp.y, rp.z, 10 * xtwist );
    stereopersp( (short)xangle*10, 
		 xpixmap->getW()/(double)xpixmap->getH(), 
		 xnear, xfar, xconf, -xeye );
    //translate(0.0, 0.0, -xconf);
    lm[0] = AMBIENT;
    lm[1] = 0.0;
    lm[2] = 0.0;
    lm[3] = 0.0;
    lm[4] = TWOSIDE;
    lm[5] = 1.0;
    lm[6] = LMNULL;
    lmdef( DEFLMODEL, 1, 7, lm);
    lmbind( LMODEL, 1);
    lmbind( MATERIAL, 0);
    for (i = 0; i<8 ; i++) lmbind(LIGHT0+i,0);
    GL_LightNumber = 0;	

    get_scene()->doWithElements( &lfunc );
    get_scene()->doWithElements( &pfunc );
    feedback->doWithElements( &pfunc );
    popmatrix();
    
    // draw right
    pushmatrix();
    if (xpixmap) { 
	((RT_StereoPixmapDisplay*) xpixmap)->activate_right(); 
	//xpixmap->clear( xscene()->get_background());
    }
    lookat( vp.x, vp.y, vp.z, rp.x, rp.y, rp.z, 10 * xtwist );
    stereopersp ((short)xangle*10, 
		 xpixmap->getW()/(double)xpixmap->getH(), 
		 xnear, xfar, xconf, xeye );
    //translate(0.0, 0.0, -xconf);
    lm[0] = AMBIENT;
    lm[1] = 0.0;
    lm[2] = 0.0;
    lm[3] = 0.0;
    lm[4] = TWOSIDE;
    lm[5] = 1.0;
    lm[6] = LMNULL;
    lmdef( DEFLMODEL, 1, 7, lm);
    lmbind( LMODEL, 1);
    lmbind( MATERIAL, 0);
    for (i = 0; i<8 ; i++) lmbind(LIGHT0+i,0);
    GL_LightNumber = 0;	
    get_scene()->doWithElements( &lfunc );
    get_scene()->doWithElements( &pfunc );
    feedback->doWithElements( &pfunc );
    popmatrix();

    // swap the picture to front
    swapbuffers();
}

const char *RTN_STEREO_LOOKAT_CAMERA = "StereoLookatCamera";

int RT_StereoLookatCamera::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", RTN_STEREO_LOOKAT_CAMERA, " {String Vector Vector} {Creates a new camera called {ARG 1 Name}, {ARG 2 Viewpoint}, {ARG 3 Referencepoint}}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if ( argc != 4 ) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <viewpoint[3]> <referencepoint[3]>! ", NULL );
	    return TCL_ERROR;
	}
	RT_Vector vp, rp; int dum;
	if (RT_getVector( &argv[2], vp, dum ) && RT_getVector( &argv[3], rp, dum )) { 
	    new RT_StereoLookatCamera( argv[1], vp, rp ); 
	    return TCL_OK;
	}
	Tcl_AppendResult( ip, "Bad parameters. <viewpoint[]> <referencepoint[]> must be float vectors! ", NULL );
	return TCL_ERROR;
    }
    return res; 
}




