////////////////////////////////////////////////////////////////////////////////
//  A file for testing inheritence of attributes and recursive  rendering     //
//  and raytracing, showing the implementation of an own class.               //  
//  LAST EDIT: Fri Aug  5 09:09:23 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

RT_Color SN_color1(0.3, 0.4, 0.9 );

const char *RTN_SNOWMAN = "Snowman";

class RT_Snowman: public RT_Primitive {
  public:
    RT_Snowman(char *_name): RT_Primitive( _name) {
	RT_Primitive *p;

	p = new RT_Sphere( 0, 0.3 ); 
	p->father( this );
	p->translate( RT_Vector( 0, 1.2, 0));

	p = new RT_Sphere( 0, 0.5 );
	p->father( this );
	p->translate( RT_Vector( 0, 0.4, 0));

	p = new RT_Sphere( 0, 0.7 );
	p->father( this );
	p->translate( RT_Vector( 0, -0.8, 0));

	p = new RT_Cylinder( 0, 0.2, 0.3 );
	p->father( this );
	p->translate( RT_Vector(0, 1.6, 0));
	p->rotate( RT_Vector(-1.57, 0,0) );
	p->diffuse( SN_color1 );

	p = new RT_Cylinder( 0, 0.25, 0.05 );
	p->father( this );
	p->translate( RT_Vector( 0, 1.45, 0));
	p->rotate( RT_Vector(-1.57, 0,0) );
	p->diffuse( SN_color1 );

	p = new RT_Torus( 0, 0.1, 0.01 );
	p->father( this );
	p->translate( RT_Vector( 0.2, 1.6, 0));
	p->diffuse( SN_color1 );

	p = new RT_Cone( 0, 0.02, 0.2 );
	p->father( this );
	p->translate( RT_Vector( 0, 1.2, 0.45));
	p->rotate( RT_Vector(3.14, 0,0) );
	p->diffuse( RT_Color(1, 0, 0 ));

	p = new RT_Sphere( 0, 0.02 );
	p->father( this );
	p->translate( RT_Vector( -0.05, 1.3, 0.3));
	p->diffuse( RT_Color(1, 1, 0 ));

	p = new RT_Sphere( 0, 0.02 );
	p->father( this );
	p->translate( RT_Vector( 0.05, 1.3, 0.3));
	p->diffuse( RT_Color(1, 1, 0 ));

	diffuse( RT_Color( 1,1,1 ));
	// snowmans are white, I believe
    }
    const char *get_class() const { return RTN_SNOWMAN; }
    const char *get_description() const { return "An implementation of a snowman for demo purposes."; }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA( RTN_SNOWMAN, _c ); }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

int RT_Snowman::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", RTN_SNOWMAN, 
			 " {String} {Creates a new snowman called {ARG 1 Name}.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_Snowman( argv[1] ); 
	return TCL_OK;
    }
    return res; 
} 

class RT_SnowmanCB: public RT_Callback  {
  public:
    void exec(RT_InputDevice *pi) {
	RT_Primitive *p = ((RT_Pick*)pi)->get_pickedObject();
	if ( p && !strcmp( p->get_name(), "snowman" )) 
	    fprintf( stderr, "Hey, you shoudn't pick a snowman!\n" );
    }
};

int main() {
    RT_init();

    RTM_command( (char*)RTN_SNOWMAN, RT_Snowman::classCMD );

    RT_PixmapDisplay *display = new RT_PixmapDisplay( "display", 500, 500 );
    display->doublebuffer();

    RT_LookatCamera *cam = new RT_LookatCamera( "cam", RT_Vector( 5,5,10), RT_Vector( 0,0,0));
    
    RT_Scene *sc = new RT_Scene( "sc" );

    sc->insert( new RT_Snowman( "snowman" ));

    RT_Light *l1 = new RT_PointLight( "l1" );
    l1->color(RT_Color( 0.3,0.3,0.3 ));
    l1->origin( RT_Vector( 10, 0, 10 ));
    sc->insert( l1 );

    RT_Light *l2 = new RT_PointLight( "l2" );
    l2->color(RT_Color( 0.7,0.7,0.7));
    l2->origin( RT_Vector( 10, 2, 5 ));
    sc->insert( l2 );

    cam->angle( 30 ); cam->pixmap( display ); cam->scene( sc );
    cam->rendering();

    RT_Pick *pick = new RT_Pick( "pick" );
    pick->father( cam );
    pick->addCB( new RT_SnowmanCB );
    
    RT_FileDevice *console = new RT_FileDevice( "console", 0, 1 ); 
    console->addCB( new RT_ConsoleInputCB );
    
    rt_InputServer->loop();
}
