////////////////////////////////////////////////////////////////////////////////
//  Math functions mapped to Tcl.                                             //  
//  LAST EDIT: Fri Aug  5 08:55:24 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif
    
#include <math.h>
#include <malloc.h>
#include <stdio.h>
    
#ifndef RTD_CPP_INCLUDES
}
#endif

#include "tclmath.h"

double exp10(double x) {
    return exp( x*log(10));
}

int str2double(char *str,double *d) {
    return sscanf(str,"%lf",d);
}

int double2str(double d,char *str) {
    return (int)sprintf(str,"%lf",d);
}

typedef double (*mathFunc)(double);

int mathCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    double ret, val;
    if (argc != 2) {
	Tcl_AppendResult(ip,argv[0],": wrong # args: should be \"",
			 argv[0]," <double>!\"",
			 (char*)0 );
	return TCL_ERROR;
    }
    if (!(str2double(argv[1], &val))) {
	Tcl_AppendResult(ip,argv[0],": wrong arg #1: should be a double!", (char*)0 );
	return TCL_ERROR; 
    } 
    ret = ((mathFunc)cd)(val);
    static char tmp[20];
    double2str(ret, tmp);
    Tcl_AppendResult(ip,tmp,(char*)0);
    return TCL_OK;
}

void rt_initMathCommands(Tcl_Interp *ip) {
    Tcl_CreateCommand( ip, "acos", mathCMD, (ClientData)acos, 0 );
    Tcl_CreateCommand( ip, "acosh", mathCMD, (ClientData)acosh, 0 );
    Tcl_CreateCommand( ip, "asin", mathCMD, (ClientData)asin, 0 );
    Tcl_CreateCommand( ip, "asinh", mathCMD, (ClientData)asinh, 0 );
    Tcl_CreateCommand( ip, "atan", mathCMD, (ClientData)atan, 0 );
    Tcl_CreateCommand( ip, "atanh", mathCMD, (ClientData)atanh, 0 );
    Tcl_CreateCommand( ip, "cos", mathCMD, (ClientData)cos, 0 );
    Tcl_CreateCommand( ip, "cosh", mathCMD, (ClientData)cosh, 0 );
    Tcl_CreateCommand( ip, "exp", mathCMD, (ClientData)exp, 0 );
    Tcl_CreateCommand( ip, "exp10", mathCMD, (ClientData)exp10, 0 );
    Tcl_CreateCommand( ip, "log", mathCMD, (ClientData)log, 0 );
    Tcl_CreateCommand( ip, "log10", mathCMD, (ClientData)log10, 0 );
    Tcl_CreateCommand( ip, "sin", mathCMD, (ClientData)sin, 0 );
    Tcl_CreateCommand( ip, "sinh", mathCMD, (ClientData)sinh, 0 );
    Tcl_CreateCommand( ip, "sqrt", mathCMD, (ClientData)sqrt, 0 );
    Tcl_CreateCommand( ip, "tan", mathCMD, (ClientData)tan, 0 );
    Tcl_CreateCommand( ip, "tanh", mathCMD, (ClientData)tanh, 0 );
}



