#ifndef __TCLERROR_H__
#define __TCLERROR_H__

////////////////////////////////////////////////////////////////////////////////
// An tcl error device class.                                                 //  
// This class is call the tcl object RT_output with the argument string       //
// of the warning, error, message or fatal message.                           //
//  LAST EDIT: Fri Aug  5 08:55:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdarg.h>
#include <error.h>

class RT_TclOutput: public RT_Output {
  private:
    int inside;
    //call the tcl error object RT_output
    // the method name and the message
    void callTclObject(const char*, const char*);
  public:
    RT_TclOutput() { inside = 0; }

    void special(const char* s) {callTclObject("-special",s);};
    void message(const char* s) {callTclObject("-message",s);};
    void warning(const char* s) {callTclObject("-warning",s);};
    void error(const char*   s) {callTclObject("-error",s);};
    void fatal(const char*   s) {callTclObject("-fatal",s);};

    void specialVar(const char* ...);
    void messageVar(const char* ...);
    void warningVar(const char* ...);
    void errorVar(const char*...);
    void fatalVar(const char*...);
};

#endif

