////////////////////////////////////////////////////////////////////////////////
// Implementation of simple interpretative class system programmed in Tcl and //
// and C++.                                                                   //  
// LAST EDIT: Wed Oct  5 13:03:17 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "tclclass.h"

const char *RTD_TCL_OBJECT = "Tcl_Object";
const char *RTD_TCL_PRIMITIVE = "Tcl_Primitive";
const char *RTD_TCL_INPUT_DEVICE = "Tcl_InputDevice";

void RT_TclClassMethodDescription::help() {
    static RT_String tmp(1000);
    tmp = "{";
    tmp += method; tmp += " {";
    tmp += ptypes; tmp += "} {";
    tmp += desc; tmp += "}}\n";
    RT_Object::result( (char*)tmp );
}

void RT_TclClassClassDescription::help() {
    class LFunctoid: public RT_GeneralListFunctoid {
      public:
	void exec(RT_GeneralListEntry *e, void* = 0) {
	    ((RT_TclClassMethodDescription*)e)->help();
	}
    } func;
    methods.doWithElements( &func );
};

void RT_TclClassMemberList::globalize(char *name, RT_String &s) {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    int frst = 1;
    do 	{
	RT_TclClassMember *mb = (RT_TclClassMember*)tmp->elem;
	if (frst) { frst = 0; s += "global "; }
	s += name; s += "->"; s += mb->getMember(); s += " ";
    }
    while(tmp = tmp->next);
    s += '\n';
}

RT_TclClassMemberList::~RT_TclClassMemberList() {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	delete tmp->elem;
    while(tmp = tmp->next);
}

void RT_TclClassMemberList::setMembers(const char *n) {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	{
	RT_TclClassMember *mb = (RT_TclClassMember*)tmp->elem;
	RT_String tmp(30);
	tmp += n; tmp += "->"; tmp += mb->getMember();
	Tcl_SetVar( rt_Ip, (char*)tmp, mb->getValue(), TCL_GLOBAL_ONLY );
    }
    while(tmp = tmp->next); 
}

void RT_TclClassMemberList::getMembers(const char *n) const {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	{
	RT_TclClassMember *mb = (RT_TclClassMember*)tmp->elem;
	RT_String tmp(30);
	tmp += n; tmp += "->"; tmp += mb->getMember();
	mb->setValue( Tcl_GetVar( rt_Ip, (char*)tmp, TCL_GLOBAL_ONLY ));
    }
    while(tmp = tmp->next); 
}

void RT_TclClassMemberList::set(char *m, char *v) {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	{
	RT_TclClassMember *mb = (RT_TclClassMember*)tmp->elem;
	if (!strcmp( mb->getMember(), m)) {
	    mb->setValue( v );
	    break;
	}
    }
    while(tmp = tmp->next);
}

void RT_TclClassMemberList::add(char *m) {
    RT_GeneralListElem *tmp = root;
    if (tmp) do {
	RT_TclClassMember *mb = (RT_TclClassMember*)tmp->elem;
	if (!strcmp( mb->getMember(), m)) return;
    }
    while(tmp = tmp->next);
    append( new RT_TclClassMember( m, "" ));
}

///////////// some functoid classes:

class RT_TclClassFindClassFunctoid: public RT_GeneralListFunctoid {
    char *cls;
    RT_TclClassClassDescription *result;
  public:
    RT_TclClassFindClassFunctoid(char *_cls) {
	cls = _cls;
	result = 0;
    }
    void exec(RT_GeneralListEntry *,void* = 0);
    RT_TclClassClassDescription *get() { return result; }
};

void RT_TclClassFindClassFunctoid::exec(RT_GeneralListEntry *a,void*) {
    if (a->isA( RTN_TCL_CLASS_CLASS_DESCRIPTION )) {
	RT_TclClassClassDescription *d = (RT_TclClassClassDescription*)a;
	if (!strcmp( cls, d->constr.method)) result = d;
    }
}

class RT_TclClassFindMethodFunctoid: public RT_GeneralListFunctoid {
    char *mthd;
    RT_TclClassMethodDescription *result;
  public:
    RT_TclClassFindMethodFunctoid(char *_mthd) { mthd = _mthd; result = 0; }
    void exec(RT_GeneralListEntry *,void* = 0);
    RT_TclClassMethodDescription *get() { return result; }
};

void RT_TclClassFindMethodFunctoid::exec(RT_GeneralListEntry *a,void*) {
    if (a->isA( RTN_TCL_CLASS_METHOD_DESCRIPTION )) {
	RT_TclClassMethodDescription *d = (RT_TclClassMethodDescription*)a;
	if (!strcmp( mthd, d->method)) result = d;
    }
}

class RT_TclClassPrintMethodFunctoid: public RT_GeneralListFunctoid {
    Tcl_Interp *ip;
  public:
    RT_TclClassPrintMethodFunctoid(Tcl_Interp *_ip) { ip = _ip; }
    void exec(RT_GeneralListEntry *a, void*) {
	if ( a->isA( RTN_TCL_CLASS_METHOD_DESCRIPTION )) 
	    Tcl_AppendResult( ip, ((RT_TclClassMethodDescription*)a)->method, " ", 0 );
    }
};

class RT_TclClassPrintClassFunctoid: public RT_GeneralListFunctoid {
    Tcl_Interp *ip;
  public:
    RT_TclClassPrintClassFunctoid(Tcl_Interp *_ip) { ip = _ip; }
    void exec(RT_GeneralListEntry *a, void*) {
	if ( a->isA( RTN_TCL_CLASS_CLASS_DESCRIPTION )) 
	    Tcl_AppendResult( ip, ((RT_TclClassClassDescription*)a)->cls, "\n", 0 );
    }
};

class RT_TclClassPrintInfoFunctoid: public RT_GeneralListFunctoid {
    Tcl_Interp *ip;
  public:
    RT_TclClassPrintInfoFunctoid( Tcl_Interp *_ip ) { ip = _ip; }
    void exec(RT_GeneralListEntry *a, void*) {
	if ( a->isA( RTN_TCL_CLASS_METHOD_DESCRIPTION )) 
	Tcl_AppendResult( ip, ((RT_TclClassMethodDescription*)a)->desc,"\n", 0 );
    }
};

RT_GeneralList RT_TclClassList::classes;

int RT_TclClassList::objectCMD(char *argv[]) {
    int r = 0;
    int start, diff = 0, xdiff; 
    char *pr;
    if ((start = RT_findString( argv, "-members")) >= 0) {
	r++;
	while ( RT_getString( &argv[ start + diff + 1 ], pr, xdiff) ) {
	    diff += xdiff;
	    int xargc; char **xargv;
	    if (Tcl_SplitList( rt_Ip, pr, &xargc, &xargv) == TCL_OK) {
		if (xargc == 2) {
		    members.set( xargv[0], xargv[1] );
		    members.setMembers( getName() );
		}
		free((char*)xargv);
	    }
	}
    }
    RT_clearArgv( argv, start, diff );

    // ?:
    if (*argv && !strcmp( *argv, "?")) {
	desc->help();
	// get infos of super classes:
	RT_TclClassClassDescription *fdesc;
	char *fclass = desc->father;

	while (1) {
	    RT_TclClassFindClassFunctoid func( fclass );
	    classes.doWithElements( &func );
	    fdesc = func.get();
	    if (fdesc) {
		fclass = fdesc->father;
		fdesc->help();
	    }
	    else break;
	}
	return 1; 
    }

    if (!*argv) return r;
    
    // evaluate arguments:
    if (callMethod( desc, argv )) return 1; 

    // call super class methods:
    RT_TclClassClassDescription *fdesc;
    char *fclass = desc->father;

    while (1) {
	RT_TclClassFindClassFunctoid func( fclass );
	classes.doWithElements( &func );
	fdesc = func.get();
	if (fdesc) {
	    fclass = fdesc->father;
	    if (callMethod( fdesc, argv )) return 1; 
	}
	else break;
    }

    return r;
}

// Tcl class list:

RT_TclClassList::RT_TclClassList(char *_name, RT_TclClassClassDescription *_desc): cName( _name) {
    desc = _desc;
    addMembers( desc->members );
    
    // add recursively super class members:
    RT_TclClassClassDescription *fdesc;
    char *fclass = desc->father;

    while (1) {
	RT_TclClassFindClassFunctoid func( fclass );
	classes.doWithElements( &func );
	fdesc = func.get();
	if (fdesc) {
	    addMembers( fdesc->members );
	    fclass = fdesc->father;
	}
	else break;
    }
}

int RT_TclClassList::callMethod( RT_TclClassClassDescription *desc, char **argv, int co ) {
    static depth = 0;
    RT_TclClassMethodDescription *mdesc;
    if (co) mdesc = &desc->constr;
    else { // find the method: 
	RT_TclClassFindMethodFunctoid func( *argv++ );
	desc->methods.doWithElements( &func );
	if (!(mdesc = func.get())) return 0;
    }
    
    // still remaining arguments:
    int argc = 0; char **tmp = argv; while (*tmp) { argc++; tmp++; }
    
    int xargc; char **xargv;
    if (Tcl_SplitList( rt_Ip, mdesc->parameters, &xargc, &xargv) == TCL_OK) {
	// error message for a method
	// for constructor this already has been done (in classCMD)
	if ( argc < xargc ) {
	    rt_Output->errorVar( getName(), ": Need following arguments for method ",
				mdesc->method, ": ", mdesc->parameters, "!", 0 );
	    free((char*)xargv);
	    return 0;
	}

	RT_String code( 100 );

	{
	    char tmp[10];
	    sprintf( tmp, "%i", ++depth );
	    code = "proc __yart";
	    code += tmp;
	    code += "__ {} {\n";
	}
	
	// set THIS:
	code += "set THIS "; code += getName(); code += "\n";

	// set temporary values as arguments:
	char **tmp = xargv;
	while (*tmp) {
	    code += "set "; code += *tmp++;  code += " {"; code += *argv++; code += "}\n";
	}
	free((char*)xargv);

	// put the parameter which are not bound to variables in a parameter list 
	if (xargc < argc) {
	    code += "set argv {";
	    while (*argv) { code += *argv++; code += " "; }
	    code += "} \n";
	    char count[20];
	    sprintf(count,"set argc %d\n",argc-xargc);
	    code += count;
	} else code += "set argv {}\nset argc 0\n";
	
	// set the member variables:
	members.globalize( getName(), code );
	
	if (co) { // merge recursively super classes code into this code:

	    RT_TclClassClassDescription *fdesc;
	    char *fclass = desc->father;

	    RT_String tmp1( 100 ),tmp2( 100 );
	    while (1) {
		RT_TclClassFindClassFunctoid func( fclass );
		classes.doWithElements( &func );
		fdesc = func.get();
		if (fdesc) {
		    fclass = fdesc->father;
		    tmp1 = fdesc->constr.body ;
		    tmp1 += tmp2;
		    tmp1 += "\n";
		    tmp2 = tmp1;
		}
		else {
		    code += tmp1;
		    break;
		}
	    }
	}
	
	// write the code:
	code += mdesc->body;

	code += "\n}";

	//	fprintf(stderr, "%s\n", (char*)code ); 

	if (Tcl_GlobalEval( rt_Ip, (char*)code ) != TCL_OK) 
	    rt_Output->errorVar( getName(), ": Error in function body: ", rt_Ip->result, 0);
	else {
	    char tmp[20];
	    sprintf( tmp, "__yart%i__", depth );
	    if (Tcl_GlobalEval( rt_Ip, tmp ) != TCL_OK) 
		rt_Output->errorVar( getName(), ".", co ? "constructor" : mdesc->method, ": Error when evaluating! ", rt_Ip->result, 0);
	    else {
		// reset former results:
		RT_Object::resResult();
		RT_Object::result( rt_Ip->result );
		depth--;
		return 1;
	    }
	    depth--;
	}
    }
    return 0;
}

void RT_TclClassList::addMembers( char *mbs ) {
    int xargc; char **xargv;
    if (Tcl_SplitList( rt_Ip, mbs, &xargc, &xargv) == TCL_OK) {
	for (int i = 0; i < xargc; i++) members.add( xargv[i] );
	free((char*)xargv);
    }
}

int RT_TclClassList::getClassesCMD(ClientData, Tcl_Interp *ip, int, char *[]) {
    RT_TclClassPrintClassFunctoid func( ip );
    classes.doWithElements( &func );
    return TCL_OK;
}

int RT_TclClassList::getMethodsCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 2 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname>\"", 0 );
	return TCL_ERROR;
    }
    RT_TclClassFindClassFunctoid func( argv[1] );
    classes.doWithElements( &func );
    RT_TclClassClassDescription *desc = func.get();
    if ( !desc ) {
	Tcl_AppendResult(ip, argv[0], ": There is no class ", argv[1], 0 );
	return TCL_ERROR;
    }
    Tcl_AppendResult ( ip, desc->constr.method, " ", 0 );
    RT_TclClassPrintMethodFunctoid func1( ip );
    desc->methods.doWithElements( &func1 );
    return TCL_OK;
}

int RT_TclClassList::getFatherCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 2 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname>\"", 0 );
	return TCL_ERROR;
    }
    RT_TclClassFindClassFunctoid func( argv[1] );
    classes.doWithElements( &func );
    RT_TclClassClassDescription *desc = func.get();
    if ( !desc ) {
	Tcl_AppendResult(ip, argv[0], ": there is no class ", argv[1], 0 );
	return TCL_ERROR;
    }
    Tcl_AppendResult ( ip, desc->get_father(), 0 );
    return TCL_OK;
}

int RT_TclClassList::getParameterCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    RT_TclClassMethodDescription *rec;
    if (rec = find( ip, argc, argv )) {
	Tcl_AppendResult(ip, rec->parameters, 0 );
	return TCL_OK;   
    }
    return TCL_ERROR;
}

int RT_TclClassList::getDescriptionCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    RT_TclClassMethodDescription *rec;
    if (rec = find( ip, argc, argv )) {
	Tcl_AppendResult(ip, rec->desc, 0 );
	return TCL_OK;   
    }
    return TCL_ERROR;
}

int RT_TclClassList::getBodyCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    RT_TclClassMethodDescription *rec;
    if (rec = find( ip, argc, argv )) {
	Tcl_AppendResult(ip, rec->body, 0 );
	return TCL_OK;   
    }
    return TCL_ERROR;
}

int RT_TclClassList::addClassCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 8 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname> <father> <members> <parameters> <parametertypes> <description> <body>\"", 0 );
	return TCL_ERROR;
    }
     { // check the father class:
	if (strcmp( argv[2], "" )) {
	    RT_TclClassFindClassFunctoid func( argv[2] );
	    classes.doWithElements( &func );
	    if (!func.get()) {
		Tcl_AppendResult(ip, argv[0], ": No father class ", argv[2], " found.", 0 );
		return TCL_ERROR;
	    }
	}
    }
    RT_TclClassFindClassFunctoid func( argv[1] );
    classes.doWithElements( &func );
    RT_TclClassClassDescription *desc = func.get();

    if ( !desc ) {
	// no such class found - must be a new class
	desc = new RT_TclClassClassDescription( argv[2], argv[3] );
	desc->constr.method = new char[ strlen( argv[1] ) + 1];
	strcpy( desc->constr.method, argv[1] );
	desc->cls = desc->constr.method;
	classes.append( desc );
    } 
    else desc->constr.clear();
    RT_TclClassMethodDescription *tmp = &desc->constr;
    
    // put the new values into the record:
    
    tmp->parameters = new char[ strlen( argv[4] ) + 1 ]; 
    strcpy( tmp->parameters, argv[4] );
    
    tmp->ptypes = new char[ strlen( argv[5] ) + 1 ]; 
    strcpy( tmp->ptypes, argv[5] );
    
    tmp->desc = new char[ strlen( argv[6] ) + 1 ]; 
    strcpy( tmp->desc, argv[6] );
    
    tmp->body = new char[ strlen( argv[7] ) + 1 ]; 
    strcpy( tmp->body, argv[7] );

    return TCL_OK;
}

int RT_TclClassList::addMethodCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 7 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname> <methodname> <parameters> <parametertypes> <description> <body>\"", 0 );
	return TCL_ERROR;
    }
    // find the class:
    RT_TclClassFindClassFunctoid cfunc( argv[1] );
    classes.doWithElements( &cfunc );
    RT_TclClassClassDescription *cdesc = cfunc.get();
    if ( !cdesc) {
	Tcl_AppendResult(ip, argv[0], ": There is no class ", argv[1], " ", 0 );
	return TCL_ERROR;
    }
    
    // find the method:
    RT_TclClassFindMethodFunctoid mfunc( argv[2] );
    cdesc->methods.doWithElements( &mfunc );
    RT_TclClassMethodDescription *mdesc = mfunc.get();
    
    if ( !mdesc ) {
	mdesc = new RT_TclClassMethodDescription;
	mdesc->method = new char[ strlen( argv[2] ) + 1];
	strcpy( mdesc->method, argv[2] );
	cdesc->methods.append( mdesc );
    } 
    else mdesc->clear();
    RT_TclClassMethodDescription *tmp = mdesc;
    
    // put the new values into the record:
    
    mdesc->cls = cdesc->cls;

    tmp->parameters = new char[ strlen( argv[3] ) + 1 ]; 
    strcpy( tmp->parameters, argv[3] );
    
    tmp->ptypes = new char[ strlen( argv[4] ) + 1 ]; 
    strcpy( tmp->ptypes, argv[4] );
    
    tmp->desc = new char[ strlen( argv[5] ) + 1 ]; 
    strcpy( tmp->desc, argv[5] );
    
    tmp->body = new char[ strlen( argv[6] ) + 1 ]; 
    strcpy( tmp->body, argv[6] );
    
    return TCL_OK;
}

int RT_TclClassList::deleteClassCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 2 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname>\"", 0 );
	return TCL_ERROR;
    }
    RT_TclClassFindClassFunctoid func( argv[1] );
    classes.doWithElements( &func );
    RT_TclClassClassDescription *desc = func.get();
    if (desc) classes.remove( desc );
    else {
	Tcl_AppendResult(ip, argv[0], ": there is no class ", argv[1], " ", 0 );
	return TCL_ERROR;
    }
    return TCL_OK;
}

int RT_TclClassList::deleteMethodCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 3 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname> <method>\"", 0 );
	return TCL_ERROR;
    }
    // first find the class:
    RT_TclClassFindClassFunctoid cfunc( argv[1] );
    classes.doWithElements( &cfunc );
    RT_TclClassClassDescription *cdesc = cfunc.get();
    if ( !cdesc) {
	Tcl_AppendResult(ip, argv[0], ": there is no class ", argv[1], " ", 0 );
	return TCL_ERROR;
    }
    
    // then find the method:
    if ( !strcmp( cdesc->constr.method, argv[2] )) {
	Tcl_AppendResult(ip, argv[0], ": you cannot delete the constructor separately.", 0 );
	return TCL_ERROR;
    }
    RT_TclClassFindMethodFunctoid mfunc( argv[2] );
    cdesc->methods.doWithElements( &mfunc );
    RT_TclClassMethodDescription *mdesc = mfunc.get();
    if ( !mdesc) {
	Tcl_AppendResult(ip, argv[0], ": There is no method ", argv[2], " in class ", argv[1], " ", 0 );
	return TCL_ERROR;
    }
    else cdesc->methods.remove( mdesc );
    return TCL_OK;
}

int RT_TclClassList::printClassesCMD(ClientData, Tcl_Interp*, int, char *[]) {
    classes.print( stdout );
    return TCL_OK;
}

RT_TclClassMethodDescription *RT_TclClassList::find(Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc != 3 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0], " <classname> <method>\"", 0 );
	return NULL;
    }
    // first find the class:
    RT_TclClassFindClassFunctoid cfunc( argv[1] );
    classes.doWithElements( &cfunc );
    RT_TclClassClassDescription *cdesc = cfunc.get();
    if ( !cdesc) {
	Tcl_AppendResult(ip, argv[0], ": There is no class ", argv[1], " ", 0 );
	return NULL;
    }
    
    // then find the method:
    if ( !strcmp( cdesc->constr.method, argv[2] )) return &cdesc->constr;
    RT_TclClassFindMethodFunctoid *mfunc = new RT_TclClassFindMethodFunctoid( argv[2] );
    cdesc->methods.doWithElements( mfunc );
    RT_TclClassMethodDescription *mdesc = mfunc->get();
    delete mfunc;
    return mdesc;
}

class RT_TclClassGetAClassFunctoid: public RT_GeneralListFunctoid {
    // the functoid returns the last class in the list
    // NULL if there isnt one
    // sorry for parsing the complete list each time!
    RT_TclClassClassDescription *result;
  public:
    RT_TclClassGetAClassFunctoid() { result = NULL; }
    void exec(RT_GeneralListEntry *a,void*) {
	if ( a->isA( RTN_TCL_CLASS_CLASS_DESCRIPTION )) result = (RT_TclClassClassDescription *)a;
    }
    RT_TclClassClassDescription *get() { return result; }
};

void RT_TclClassList::clearClasses() {
    RT_TclClassClassDescription *desc;
    while (1) {
	RT_TclClassGetAClassFunctoid f;
	classes.doWithElements( &f );
	desc = f.get();
	if (desc) classes.remove( desc );
	else break;
    }
}

void rt_initTclClassCommands( Tcl_Interp *ip ) {
    // general access to interpretative classes:
    Tcl_CreateCommand( ip, (char*)RTD_TCL_OBJECT, RT_TclObject::addClassCMD, 0, 0);
    Tcl_CreateCommand( ip, (char*)RTD_TCL_PRIMITIVE, RT_TclPrimitive::addClassCMD, 0, 0);
    Tcl_CreateCommand( ip, (char*)RTD_TCL_INPUT_DEVICE, RT_TclInputDevice::addClassCMD, 0, 0);

    Tcl_CreateCommand( ip, "RT_include", RT_TclClassList::includeClassCMD, 0, 0);

    // interface to class browser:
    Tcl_CreateCommand( ip, "TclClass.getClasses", RT_TclClassList::getClassesCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.printClasses", RT_TclClassList::printClassesCMD, 0, 0); 

    // access to a class:
    Tcl_CreateCommand( ip, "Tcl_Method", RT_TclClassList::addMethodCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.getMethods", RT_TclClassList::getMethodsCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.getFather", RT_TclClassList::getFatherCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.deleteClass", RT_TclClassList::deleteClassCMD, 0, 0);

    // access to a method:
    Tcl_CreateCommand( ip, "TclClass.getParameter", RT_TclClassList::getParameterCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.getDescription", RT_TclClassList::getDescriptionCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.getBody", RT_TclClassList::getBodyCMD, 0, 0);
    Tcl_CreateCommand( ip, "TclClass.deleteMethod", RT_TclClassList::deleteMethodCMD, 0, 0);
}

int RT_TclClassList::includeClassCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if ( argc < 2 ) {
	Tcl_AppendResult(ip, argv[0], ": Wrong # args: should be \"", argv[0],
			 " <classname> [\"overwrite\"]\"", 0 );
	return TCL_ERROR;
    }
    if (argc == 3 && ! strcmp( argv[2], "overwrite" ) ) {
	char *pth = getenv( RT_GOOD_ROOT_DIR );
	if (pth) return Tcl_VarEval( ip, "RT_source ", argv[1], ".cls {",
				    pth, "/classes ", pth, "/YART/cls}", 0 );
	else return Tcl_VarEval( ip, "RT_source ", argv[1], ".cls", 0 );
    }

    // try to find the class:
    RT_TclClassFindClassFunctoid cfunc( argv[1] );
    classes.doWithElements( &cfunc );
    RT_TclClassClassDescription *cdesc = cfunc.get();
    if ( !cdesc) {
	char *pth = getenv( RT_GOOD_ROOT_DIR );
	if (pth) return Tcl_VarEval( ip, "RT_source ", argv[1], ".cls {",
				    pth, "/classes ", pth, "/YART/cls}", 0 );
	else return Tcl_VarEval( ip, "RT_source ", argv[1], ".cls", 0 );
    }
    // the class already exist and shouldn't be overwritten:
    return TCL_OK;
}

int RT_TclClassList::isA(const char *_c) const {
    if (!strcmp( _c, desc->cls)) return 1;

    RT_TclClassClassDescription *fdesc;
    char *fclass = desc->father;
    
    while (1) {
	RT_TclClassFindClassFunctoid func( fclass );
	classes.doWithElements( &func );
	fdesc = func.get();
	if (fdesc) {
	    fclass = fdesc->father;
	    if (!strcmp( _c, fdesc->cls)) return 1;
	}
	else break;
    }
    return 0;
}

RT_TclClassList::~RT_TclClassList() {
    RT_String code( 100 );
    static depth = 0;
    char tmps[25];
    sprintf( tmps, "proc __yart%i__ {} {\n", ++depth );
    code = tmps;
	
    // set THIS:
    code += "set THIS "; code += getName(); code += "\n";

    // set the member variables:
    members.globalize( getName(), code );
    
    // merge recursively super class destructors into this code:
    RT_TclClassClassDescription *fdesc;
    char *fclass = (char*)get_class();
    while (1) {
	RT_TclClassFindClassFunctoid func( fclass );
	classes.doWithElements( &func );
	fdesc = func.get();
	if (fdesc) {
	    RT_TclClassMethodDescription *mdesc;

	    RT_String tstr( 20 );
	    tstr = "~"; tstr += fclass;

	    fclass = fdesc->father;

	    RT_TclClassFindMethodFunctoid func( tstr );
	    fdesc->methods.doWithElements( &func );
	    if (mdesc = func.get()) { code += mdesc->body; code += '\n'; }
	}
	else break;
    }

    code += "}";

//    fprintf(stderr, "%s\n", (char*)code );

    if (Tcl_GlobalEval( rt_Ip, (char*)code ) != TCL_OK) 
	rt_Output->errorVar( getName(), ": Error in function body: ", rt_Ip->result, 0);
    else {
	char tmp[20];
	sprintf( tmp, "__yart%i__", depth );
	if (Tcl_GlobalEval( rt_Ip, tmp ) != TCL_OK) 
	    rt_Output->errorVar( getName(), ".destructor: Error when evaluating! ", rt_Ip->result, 0);
    }
    depth--;
}

// the Tcl class:

int RT_TclObject::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    if (!cd ) return TCL_OK;
    RT_TclClassClassDescription *desc = (RT_TclClassClassDescription *)cd;

    if (argc == 3) {
	if (!strcmp( argv[1], "-description")) {
	    desc->set_desc( argv[2] );
	    return TCL_OK;
	}
	if (!strcmp( argv[1], "-keywords")) {
	    desc->set_keywords( argv[2] );
	    return TCL_OK;
	}
    }
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", desc->cls, " {", desc->constr.ptypes, "} {", desc->constr.desc, "}}", 0 );
	return TCL_OK;
    } 
    
    if (res != TCL_OK) return res;

    // still remaining arguments:
    int argx = 0; char **tmp = &argv[1]; while (*tmp) { argx++; tmp++; }
    
    if (argv[2] && !strcmp(argv[2], "-ignore" )) {
	new RT_TclObject( argv[1], desc, &argv[1] );
	RTM_classReturn;
    }
    else { // check the args before calling the creation of the C++-object
	int xargc; char **xargv;
	if (Tcl_SplitList( rt_Ip, desc->constr.parameters, &xargc, &xargv) == TCL_OK) {
	    free((char*)xargv);
	    if ( argx == xargc ) {
		new RT_TclObject( argv[1], desc, &argv[1] );
		RTM_classReturn;
	    }
	    else {
		Tcl_AppendResult( ip, desc->cls, ": Need following arguments: ",
				 desc->constr.parameters,"!", 0 );
		return TCL_ERROR;
	    }
	}
	return TCL_ERROR;
    }
}

RT_TclObject::RT_TclObject(char *_name, RT_TclClassClassDescription *_desc, char **args) :
RT_TclClassList( _name, _desc), RT_Object( _name) {
    members.setMembers( get_name() );
    if (!args[1] || strcmp( args[1], "-ignore" )) callMethod( desc, args, 1);
}

int RT_TclObject::addClassCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int ret = RT_TclClassList::addClassCMD(cd, ip, argc, argv);
    if (ret == TCL_OK) {
	// create the new command:
	RT_TclClassFindClassFunctoid func( argv[1] );
	classes.doWithElements( &func );
	RT_TclClassClassDescription *desc = func.get();
	desc->constrCmd = RTD_TCL_OBJECT;
	Tcl_CreateCommand( rt_Ip, argv[1], RT_TclObject::classCMD,
			  (ClientData)desc, (Tcl_CmdDeleteProc*)NULL);
    }
    return ret;
}

// the Tcl Primitive class:

int RT_TclPrimitive::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    if (!cd ) return TCL_OK;
    RT_TclClassClassDescription *desc = (RT_TclClassClassDescription *)cd;

    if (argc == 3) {
	if (!strcmp( argv[1], "-description")) {
	    desc->set_desc( argv[2] );
	    return TCL_OK;
	}
	if (!strcmp( argv[1], "-keywords")) {
	    desc->set_keywords( argv[2] );
	    return TCL_OK;
	}
    }
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", desc->cls, " {", desc->constr.ptypes, "} {", desc->constr.desc, "}}", 0 );
	return TCL_OK;
    } 
    
    if (res != TCL_OK) return res;

    // still remaining arguments:
    int argx = 0; char **tmp = &argv[1]; while (*tmp) { argx++; tmp++; }
    
    if (argv[2] && !strcmp(argv[2], "-ignore" )) {
	new RT_TclPrimitive( argv[1], desc, &argv[1] );
	RTM_classReturn;
    }
    else { // check the args before calling the creation of the C++-object
	int xargc; char **xargv;
	if (Tcl_SplitList( rt_Ip, desc->constr.parameters, &xargc, &xargv) == TCL_OK) {
	    free((char*)xargv);
	    if ( argx == xargc ) {
		new RT_TclPrimitive( argv[1], desc, &argv[1] );
		RTM_classReturn;
	    }
	    else {
		Tcl_AppendResult( ip, desc->cls, ": Need following arguments: ",
				 desc->constr.parameters,"!", 0 );
		return TCL_ERROR;
	    }
	}
	return TCL_ERROR;
    }
}

RT_TclPrimitive::RT_TclPrimitive(char *_name, RT_TclClassClassDescription *_desc, char **args) :
RT_TclClassList( _name, _desc), RT_Primitive( _name) {
    members.setMembers( get_name() );
    if (!args[1] || strcmp( args[1], "-ignore" )) callMethod( desc, args, 1);
}

int RT_TclPrimitive::addClassCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int ret = RT_TclClassList::addClassCMD(cd, ip, argc, argv);
    if (ret == TCL_OK) {
	// create the new command:
	RT_TclClassFindClassFunctoid func( argv[1] );
	classes.doWithElements( &func );
	RT_TclClassClassDescription *desc = func.get();
	desc->constrCmd = RTD_TCL_PRIMITIVE;
	Tcl_CreateCommand( rt_Ip, argv[1], RT_TclPrimitive::classCMD,
			  (ClientData)desc, (Tcl_CmdDeleteProc*)NULL);
    }
    return ret;
}

// the Tcl InputDevice class:

int RT_TclInputDevice::objectCMD(char *args[]) {
    int ret = RT_InputDevice::objectCMD( args) + RT_TclClassList::objectCMD( args);
    RT_parseTable( args, table );
    if (callCBF) callCBs();
    if (callCLDF) callChildren( xevent );
    return ret + callCBF + callCLDF;
}

int RT_TclInputDevice::callCBF, RT_TclInputDevice::callCLDF;

RT_ParseEntry RT_TclInputDevice::table[] = {
    {"-callCBs", RTP_NONE, 0, &callCBF, "Call the callback procedures of the device.", RTPS_NONE },
    {"-callChildren", RTP_NONE, 0, &callCLDF, "Call all childs of the device. The event passed to the event method of this object will be sent to the child objects. Thus, there must no spcified an event here.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
}; 


int RT_TclInputDevice::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    if (!cd ) return TCL_OK;
    RT_TclClassClassDescription *desc = (RT_TclClassClassDescription *)cd;

    if (argc == 3) {
	if (!strcmp( argv[1], "-description")) {
	    desc->set_desc( argv[2] );
	    return TCL_OK;
	}
	if (!strcmp( argv[1], "-keywords")) {
	    desc->set_keywords( argv[2] );
	    return TCL_OK;
	}
    }
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", desc->cls, " {", desc->constr.ptypes, "} {", desc->constr.desc, "}}", 0 );
	return TCL_OK;
    } 
    
    if (res != TCL_OK) return res;

    // still remaining arguments:
    int argx = 0; char **tmp = &argv[1]; while (*tmp) { argx++; tmp++; }
    
    if (argv[2] && !strcmp(argv[2], "-ignore" )) {
	new RT_TclInputDevice( argv[1], desc, &argv[1] );
	RTM_classReturn;
    }
    else { // check the args before calling the creation of the C++-object
	int xargc; char **xargv;
	if (Tcl_SplitList( rt_Ip, desc->constr.parameters, &xargc, &xargv) == TCL_OK) {
	    free((char*)xargv);
	    if ( argx == xargc ) {
		new RT_TclInputDevice( argv[1], desc, &argv[1] );
		RTM_classReturn;
	    }
	    else {
		Tcl_AppendResult( ip, desc->cls, ": Need following arguments: ",
				 desc->constr.parameters,"!", 0 );
		return TCL_ERROR;
	    }
	}
	return TCL_ERROR;
    }
}

RT_TclInputDevice::RT_TclInputDevice(char *_name, RT_TclClassClassDescription *_desc, char **args) :
RT_TclClassList( _name, _desc), RT_InputDevice( _name) {
    members.setMembers( get_name() );
    if (!args[1] || strcmp( args[1], "-ignore" )) callMethod( desc, args, 1);
    xevent = 0;
}

int RT_TclInputDevice::addClassCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) {
    int ret = RT_TclClassList::addClassCMD(cd, ip, argc, argv);
    if (ret == TCL_OK) {
	// create the new command:
	RT_TclClassFindClassFunctoid func( argv[1] );
	classes.doWithElements( &func );
	RT_TclClassClassDescription *desc = func.get();
	desc->constrCmd = RTD_TCL_INPUT_DEVICE;
	Tcl_CreateCommand( rt_Ip, argv[1], RT_TclInputDevice::classCMD,
			  (ClientData)desc, (Tcl_CmdDeleteProc*)NULL);
    }
    return ret;
}

void RT_TclInputDevice::event(RT_Event *ev) {
    xevent = ev;
    char *tmp = "-event"; 
    char *args[3];
    args[0] = tmp; args[1] = ev ? (char*)(ev->getValue()) : ""; args[2] = 0;
    if ( !callMethod(desc,args,0) ) 
	rt_Output->warningVar( get_name(), ": There is no Tcl method -event!", 0 );
    xevent = 0;
}








