////////////////////////////////////////////////////////////////////////////////
// YART interface to VOGL GL (a minimal subset of SGI GL).                    //  
// All lighting and vertex based stuff removed. Only flat shading of wirefra- //
// mes.                                                                       //
// LAST EDIT: Wed Feb  8 17:33:57 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../high/usefligh.h"
#include "../high/lookat.h"
#include "../quadmesh.h"
#include "../pixmap.h"
#include "../poly.h"
#include "../polyhdrn.h"

#include "vogl.h"
#include "fdither.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

extern "C" {
int vo_xt_window(Display*, Window, int, int);
int vo_xt_set_win(Display*, Drawable, int, int);
}

// set [VO]GL color:

void VG_color( const RT_Color &c) {
    RT_Color pc = c * 5.0;
    pc.correct();
    color( RT_ditherRGB(1, 1, pc ));
}

// low level display list functions:

void RT_dlOpen(long id) {
    if (isobj((Object)id)) delobj( (Object)id );
    makeobj( (Object)id );
}

void RT_dlClose(long) { closeobj(); }

void RT_dlDelete(long id) {
    if (isobj((Object)id)) delobj( (Object)id );
}

void RT_dlMatrix(const RT_Matrix &mat) {
    Matrix m;
    for (int i = 0; i < 4; i++)
	for (int j = 0; j < 4; j++)
	    m[i][j] = mat.get(j, i);
    pushmatrix();
    multmatrix( m );
}

void RT_dlUnMatrix() {
    popmatrix();
}

void RT_dlSurface(const RT_Surface &) {}

void RT_dlCall(long id) {
    callobj( (Object) id );
}

#ifndef RTD_TK

class RT_PixmapDisplayData {
  public:
    Window window;
    Display *display;
    GC gc;
    int screen;
};

RT_PixmapDisplay::~RT_PixmapDisplay() { 
    if (data->display != NULL) {
	if (data->gc != None) XFreeGC(data->display, data->gc);
	XCloseDisplay( data->display);
	delete data; 
    }   
}

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {
    data = new RT_PixmapDisplayData;

    static Display *display = 0;

    if (!display && !(display = XOpenDisplay(0))) 
	rt_Output->fatal( "Cannot open display for X Pixmap.");

    data->display = display;
    data->screen = DefaultScreen(data->display) ;
    data->window = XCreateSimpleWindow(data->display,
				       RootWindow(data->display, data->screen),
				       0, 0, w, h, 1, 0, 0 );

    XSizeHints sHints;
    sHints.flags = PSize| PMinSize | PMaxSize;
    sHints.min_width = sHints.max_width = w;
    sHints.min_height = sHints.max_height = h;

    XTextProperty wName;
    if (!XStringListToTextProperty( &_name, 1, &wName)) 
	rt_Output->fatal( "Structure allocation for Window Name of X11 Pixmap failed." );
    XSetWMProperties( data->display, data->window, &wName, &wName, 0, 0,
		     &sHints, 0, 0);
    XFree( (char*)wName.value );

    XMapWindow( data->display, data->window );

    vo_xt_window( data->display, data->window, w, h );

    XSelectInput(data->display, data->window,
		 StructureNotifyMask | ButtonPressMask |
		 ButtonReleaseMask | PointerMotionMask | ExposureMask );

    data->gc = XCreateGC( data->display, data->window, 0, NULL);

    // support for common colormap - Don Libes, NIST
    if (!rt_Cmap) {
	int rIncr = 65536/rt_rMax;
	int gIncr = 65536/rt_gMax;
	int bIncr = 65536/rt_bMax;
	
	XColor color;
	int r, g, b;

	rt_Cmap = new int[ (rt_rMax+1) * (rt_gMax+1) * (rt_bMax+1)];

	for (r = 0, color.red = 0; r <= rt_rMax; r++, color.red += rIncr) {
	    // on last iteration, max it
	    if (r == rt_bMax) color.red = 65535;
	    for (g = 0, color.green = 0; g <= rt_gMax; g++, color.green += gIncr) {
		if (g == rt_gMax) color.green = 65535;
		for (b = 0, color.blue  = 0; b <= rt_bMax; b++, color.blue += bIncr) {
		    if (b == rt_bMax) color.blue = 65535;

		    XAllocColor(data->display,DefaultColormap(data->display,DefaultScreen(data->display)),&color);
		    rt_Cmap[r * rt_rMult + g * rt_gMult + b * rt_bMult] = (int)color.pixel;
		}
	    }
	}

	// for efficient, precompute dither multiplier.
	// 64 is just the size of the dither table.
	rt_rDitherMultiplier = rt_rMax * 64;
	rt_gDitherMultiplier = rt_gMax * 64;
	rt_bDitherMultiplier = rt_bMax * 64;
    }

    ginit();
    singlebuffer(); 
    gconfig();
    concave(1);
    backface(1);
}

RT_Color RT_PixmapDisplay::getPixel(int x, int y) { 
    XColor col;
    XImage *img;
    
    img = XGetImage(data->display, data->window, x, (h - 1) - y,
		    1, 1, AllPlanes, XYPixmap);
    col.pixel = XGetPixel(img, 0, 0);
    XDestroyImage(img);
    XQueryColor(data->display, DefaultColormap(data->display,DefaultScreen(data->display)), &col);
    return (RT_Color(col.red/65535.0, col.green/65535.0, col.blue/65535.0));
}

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    XSetForeground( data->display, data->gc, RT_ditherRGB(x, y, colr) );
    XDrawPoint( data->display, data->window, data->gc, x, (h - 1) - y);
    XFlush(data->display);
}

void RT_PixmapDisplay::event() {
    XEvent ev;
    while ( XPending ( data->display )) {
	XNextEvent( data->display, &ev );
	if( ev.xany.window != data->window) {
	    XPutBackEvent( data->display, &ev);
	    return;
	}

	RT_Event *event = 0;
	switch (ev.type) {
	    
        // the point events
        case ButtonPress: { 
            XButtonEvent *evb = (XButtonEvent *) &ev;
            RT_ButtonEvent *pev = new RT_ButtonEvent;
            if (evb->button == Button1) {pev->left = 1;}
            if (evb->button == Button2) {pev->middle = 1;}
            if (evb->button == Button3) {pev->right = 1;}
            pev->w = w;
            pev->h = h;
            pev->x = evb->x;  
            pev->y = h-evb->y;
            event = (RT_Event*) pev; 
          }
          break;
        case MotionNotify: {
	    XPointerMovedEvent *evm = (XPointerMovedEvent *) &ev;
	    RT_MotionEvent *pev = new RT_MotionEvent;
	    if (evm->state & Button1Mask) {pev->left = 1;}
	    if (evm->state & Button2Mask) {pev->middle = 1;}
	    if (evm->state & Button3Mask) {pev->right = 1;}
	    pev->w = w;
	    pev->h = h;
	    pev->x = evm->x;  
	    pev->y = h-evm->y;
	    event = (RT_Event*) pev;
	}
        break; 
        case Expose: event = new RT_UpdateEvent;
    }
    if (event && xcamera) {
      xcamera->event( *event );
      delete event;
    }

  }
}

#endif

void RT_PixmapDisplay::clear(const RT_Color &c) { 
    VG_color( c );
    ::clear();
}

void RT_PixmapDisplay::activate() {
    vo_xt_set_win( data->display, data->window, w, h );
    reshapeviewport();
}

void RT_PixmapDisplay::singlebuffer() { ::singlebuffer(); sglBuf = 1; }

void RT_PixmapDisplay::doublebuffer() { ::doublebuffer(); sglBuf = 0; }

// class LookatCamera:

void RT_LookatCamera::shading() {
    if (!get_pixmap() || !get_scene()) return;
    if (xpixmap) { xpixmap->activate(); xpixmap->clear( get_scene()->get_background() ); } 
    pushmatrix();

    perspective( (short)xangle*10, xpixmap->getW()/(double)xpixmap->getH(), xnear, xfar );
    lookat( vp.x, vp.y, vp.z, rp.x, rp.y, rp.z, 10 * xtwist );

    RT_RenderPrimitiveFunc func;
    get_scene()->doWithElements( &func );

    feedback->doWithElements( &func );
    swapbuffers();
    popmatrix();
}

///// the primitives:

void RT_Polymarker::render() {
    VG_color( get_diffuse() );
    int nr = 0; 
    float f[4];
    RT_Vertex *v;
    bgnpoint();
    while ( v = get( nr++ ) ) {
	v->getPoint().get( f );
	v3f( f );
    }
    endpoint();
}

void RT_Polyline::render() {
    VG_color( get_diffuse() );
    int nr = 0; 
    float f[4];
    RT_Vertex *v;
    bgnline();
    while ( v = get( nr++ ) ) {
	v->getPoint().get( f );
	v3f( f );
    }
    endline();
}

void RT_Polygon::render() {
    VG_color( get_diffuse() );
    RT_Vertex *v;
    int nr = 0; 
    float f[4];

    bgnclosedline();
    while ( v = get( nr++ ) ) {
	v->getPoint().get( f );
	v3f( f );
    }
    endclosedline();
}

void RT_Quadmesh::render() {
    VG_color( get_diffuse() );
    RT_Vertex *v;    
    float f[4];
    int cols, rows, nr = 0;
    rows = get_x();
    cols = get_y();

    for( int i = 0; i < rows; i++ ) {
	bgnline();
	for ( int j = 0; j < cols; j++ ) {
	    v = get(i,j);  
	    v->getPoint().get( f );
	    v3f( f );
	}
	endline();
    }
    for( int j = 0; j < cols; j++ ) {
	bgnline();
	for ( int i = 0; i < rows; i++ ) {
	    v = get(i,j);  
	    v->getPoint().get( f );
	    v3f( f );
	}
	endline();
    }
}

void RT_Polyhedron::render() {
    VG_color( get_diffuse() );
    RT_Vertex *v;
    int nr = 0;
    float f[4];

    for (int i = 0; i < get_nfacets(); i++) {
   	bgnclosedline();
	for ( int j = 0; j < facets[i].get_number(); j++) {
	    v = get(i, j);
	    v->getPoint().get( f );
	    v3f( f );
	    
	}
    	endclosedline();
    }
}


// the light sources:

void RT_PointLight::render() {}

void RT_AmbientLight::render() {}

#ifdef RTD_RSY
void RT_LookatCamera::RSYshading() {
  float max_rend = -BIGFLOAT;
  RT_RS_Scene* rscene = ((RT_RSYScene*)get_scene())->get_rscene(); //the radiosity scene to render
  long i, cnt,
       a_dcnt = rscene->Areas->get_diffcnt(),      //number of diffuse patches
       a_icnt = rscene->Areas->get_inscnt(),       //number of non-diffuse patches
       p_dcnt = rscene->Points->get_diffcnt(),     //number of diffuse patches
       p_icnt = rscene->Points->get_inscnt();      //number of non-diffuse patches
  int j, k, m, corners;
  int render_nondiff = xmode == RTE_LC_RADIOSITY; //render non-diffuse components ? (if any)
  int wireframe = xmode == RTE_LC_WIREFRAME_RADIOSITY;
  int auto_view_scale = rscene->Points->view_scale < epsilon && !wireframe;
  float max_scale = rscene->Points->max_scale;
  RT_RS_Area* ar;                            //the current patch
  RT_RS_3DVector prp(vp.x, vp.y, vp.z);      //projection reference point
  RT_Vector vv(rp - vp);                     //view vector                                 
  vv = vv.UNITIZE();                         //norm. view vector
  RT_RS_3DVector vdir(vv.x, vv.y, vv.z);
  RT_RS_Vtx *vtx[4],                         //the vertices of the current patch
  view_dir( prp, vdir ); //view direction
  
  RT_RS_DiffRGB xcolr[4];                    //the colors of the vertices

  if (xpixmap) { xpixmap->activate(); xpixmap->clear( get_scene()->get_background() ); } 

  pushmatrix();
  perspective( (short)xangle*10, xpixmap->getW()/(double)xpixmap->getH(), xnear, xfar );
  lookat( vp.x, vp.y, vp.z, rp.x, rp.y, rp.z, 10 * xtwist );

  rscene->Points->reset_vis();
  for(m = 0; m < 2; m++) {  //for all (diffuse + non-diffuse patches)
    cnt = m ? p_icnt : p_dcnt;
    for(i = 0; i < cnt; i++) {
      if(m) *vtx = rscene->Points->get_ins(i);
      else *vtx = rscene->Points->get_diff(i); //get the patch
      if((*vtx)->get_view_val(*xcolr, view_dir, render_nondiff))
        if(auto_view_scale) {
          if(xcolr->r > max_rend && xcolr->r < max_scale) max_rend = xcolr->r;
          if(xcolr->g > max_rend && xcolr->g < max_scale) max_rend = xcolr->g;
          if(xcolr->b > max_rend && xcolr->b < max_scale) max_rend = xcolr->b;
        }
    }
  }
  
  if(auto_view_scale) rscene->Points->view_scale = 1.0 / max_rend;
  rscene->Points->scale_view_vals();

  float crd[4][3], colr[3], Green[3], White[3];
  Green[0] = 0;  Green[1] = 1; Green[2] = 0;
  White[0] = 1;  White[1] = 1; White[2] = 1;

  //render:
  for(k = wireframe ? 0 : 1; k < 2; k++) {
    for(m = 0; m < 2; m++) {  //for all (diffuse + non-diffuse patches)
      cnt = m ? a_icnt : a_dcnt;
      for(i = 0; i < cnt; i++) {
        if(m) ar = rscene->Areas->get_ins(i); else ar = rscene->Areas->get_diff(i); //get the patch
        corners = ar->vidx[2] == ar->vidx[3] ? 3 : 4;
        int xbackface = 0;
        for(j = 0; j < corners; j++) {
          vtx[j] = ar->get_vtx(ar->vidx[j]);   //get the vertices
          //get the vertex intensity in direction to point of view
          if(!vtx[j]->get_view_val(xcolr[j], view_dir, render_nondiff))
            xbackface++;  //this vertex is back-facing 
         }
         xbackface = xbackface == corners;
         if(wireframe && (xbackface && !k || !xbackface && k) || !wireframe && !xbackface) {  //render this patch
         for(j = 0; j < corners; j++) {
           crd[j][0] = vtx[j]->pnt.x; 
           crd[j][1] = vtx[j]->pnt.y; 
           crd[j][2] = vtx[j]->pnt.z;
         }  
         if(wireframe) {    //draw as a wireframe
            bgnclosedline();                             
            if(xbackface) color(GREEN); else color(WHITE); 
            for (j = 0; j < corners; j++) { 
              v3f(crd[j]); 
            }           
            endclosedline();           
          } else {		
            bgnpolygon();
            for (j = 0; j < corners; j++) {
              colr[0] = xcolr[j].r; colr[1] = xcolr[j].g; colr[2] = xcolr[j].b; 
              v3f(crd[j]);
            }            
	    endpolygon(); 
          }
        }
      }
    }
  }
  if(auto_view_scale) rscene->Points->view_scale = 0.;

  swapbuffers();
  popmatrix();
}

#endif

