////////////////////////////////////////////////////////////////////////////////
//  YART interface to Tk and SGI GL 4.0.                                      //  
//  LAST EDIT: Wed Mar  8 15:56:14 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#define RTD_TK

#include <yart.h>

extern "C" {
#include "tk.h"
#include "X11/Xlib.h"
#include "xspbdev.h"

// not needed here, and they conflict with GL defs 
#undef BLACK 
#undef WHITE

#include <gl/gl.h>
#include <gl/glws.h>


int Tk_SetWindowVisual(Tk_Window,Visual *,unsigned int,Colormap);
}

// definitions for Tk - GL pixmaps

#define GLXWIN_BOUND 1

Tk_Window rt_TkWin;

class RT_PixmapDisplayData {
  public:
    RT_PixmapDisplay *px;
    Tk_Window tkwin;	
    int enter;
    Display *display;	
    GLXconfig *glxconfig;
    int rgbmode, doublebuffermode, stencilsize, accumsize, zbuffersize;
    int bound;
    int result;
    int del; 
    // is 1 if the pixmap was already deleted (e.g. via Tcl command)

    SpaceballDeviceInfo *spInfo;
    // variables to hold the event classes of the spaceball
    
    //#### public methods:
    RT_PixmapDisplayData() { 
	spInfo = 0; 
	enter = 0;
	del = 0;
    }
    ~RT_PixmapDisplayData();
    int link_glxwin();
    int unlink_glxwin();
    int get_glxwin_info();
    int fill_glxconfig();
    unsigned long extract_value(int, int, GLXconfig*);
    int set_window(int, Window, GLXconfig*);
    int glxwin_winset();
    
    // callbacks for Tk:
    static void eventProc(ClientData, XEvent*);
    static int gevProc(ClientData, XEvent*);
    static void reset_glxwin(ClientData);
};

RT_PixmapDisplayData::~RT_PixmapDisplayData() {
    Tk_DeleteGenericHandler(RT_PixmapDisplayData::gevProc, (ClientData)this);
    Tk_DestroyWindow( tkwin );
    if (glxconfig != NULL) ckfree(glxconfig);
}

int RT_PixmapDisplayData::get_glxwin_info() {
    XVisualInfo info, *v;
    Colormap cmap;
    int n;
  
    info.screen = Tk_ScreenNumber(tkwin);
    info.visualid = extract_value(GLX_NORMAL, GLX_VISUAL, glxconfig);
    v = XGetVisualInfo (display, 
			VisualScreenMask|VisualIDMask, &info, &n);
    cmap = extract_value(GLX_NORMAL, GLX_COLORMAP, glxconfig);
    Tk_SetWindowVisual(tkwin, v->visual, v->depth, cmap);
    return 0;
}

unsigned long RT_PixmapDisplayData::extract_value(int buffer,int  mode, GLXconfig *conf) {
    int	i;
    for (i = 0; conf[i].buffer; i++)
	if (conf[i].buffer == buffer && conf[i].mode == mode)
	    return conf[i].arg;
    return 0;
}

int RT_PixmapDisplayData::link_glxwin() {
    if(!bound){
	Tk_MakeWindowExist(tkwin);
	set_window(GLX_NORMAL, Tk_WindowId(tkwin), glxconfig);
	
	if(GLXlink(display, glxconfig) != GLWS_NOERROR)
	    return(1);

	if(GLXwinset(display, Tk_WindowId(tkwin)) != GLWS_NOERROR)
	    return(1);

	// init the spaceball as X extension device:
	spInfo = new  SpaceballDeviceInfo;
	if(!rt_spaceballInit(display,Tk_WindowId(tkwin),spInfo)) {
	    rt_Output->warning("Spaceball init error!");
	    delete spInfo;
	    spInfo =0;
	} 
	bound = 1;
	zbuffer( 1 );
    }
    clear();
    return 0;
}

int RT_PixmapDisplayData::unlink_glxwin() {
    if (!bound) return 0; // not linked

    if(tkwin != NULL)
	if(GLXunlink(display, Tk_WindowId(tkwin)) != GLWS_NOERROR)
	    return 1;
    
    bound = 0;
    return 0;
}

int RT_PixmapDisplayData::set_window(int buffer, Window W, GLXconfig *conf) {
    for (int i = 0; conf[i].buffer; i++)
	if (conf[i].buffer == buffer && conf[i].mode == GLX_WINDOW)
	    conf[i].arg = (int) W;
    return 0;
}

int RT_PixmapDisplayData::glxwin_winset() {
    if (!bound) return 1;

    if (GLXwinset(display, Tk_WindowId(tkwin)) != GLWS_NOERROR)
	return 2;

    return 0;
}

// The global event proc is used to handle the spaceball events.
// This is necessary because the spaceball events are not bound to the window.
int RT_PixmapDisplayData::gevProc(ClientData cd, XEvent *eventPtr) {
    if (eventPtr->type == DestroyNotify) return 0;
    
    RT_PixmapDisplayData *d = (RT_PixmapDisplayData *)cd;
    
    // check if the mouse is in the subwindow 
    if (!d->enter) return 0;

    if(d->spInfo) {
	SpaceballData sData;
	if (rt_spaceballEvent(eventPtr, &sData, d->spInfo)) {
	    RT_SpaceballEvent *sev = new RT_SpaceballEvent;
	    sev->transX = sData.transX;
	    sev->transY = sData.transY;
	    sev->transZ = sData.transZ;
	    sev->twistX = sData.twistX;
	    sev->twistY = sData.twistY;
	    sev->twistZ = sData.twistZ;
	    sev->b1    = sData.b1;
	    sev->b2    = sData.b2;
	    sev->b3    = sData.b3;
	    sev->b4    = sData.b4;
	    sev->b5    = sData.b5;
	    sev->b6    = sData.b6;
	    sev->b7    = sData.b7;
	    sev->b8    = sData.b8;
	    sev->pick  = sData.pick;
	    sev->period = sData.period;
	    d->px->xcamera->event( *sev );
	    delete sev;
	    
	    // now delete all other spaceball events
	    // to stop action if the user create not new events
	    XEvent xev,lastxev;
	    int getEvent = 0;
	    while (XCheckTypedEvent(d->display,d->spInfo->eventType[SPACEBALL_BALL_EVENT], &xev)) { 
		getEvent++; 
		lastxev = xev;
	    }
	    // if there are more then 1 events put the last spaceball event in the event loop
	    // to make the interaction faster
	    if (getEvent>1) XPutBackEvent(d->display, &lastxev);
	    return 1;
	}
    }
    return 0;
}

void RT_PixmapDisplayData::eventProc(ClientData cd, XEvent *eventPtr) {
    RT_PixmapDisplayData *d = (RT_PixmapDisplayData*)cd;
    switch (eventPtr->type) {
      case DestroyNotify: 
	d->unlink_glxwin();
	if (!d->del) delete d->px;
	break;
      case MapNotify:
	d->link_glxwin();
	break;
      case Expose:
	if (d->bound ) {
	    if (eventPtr->xexpose.count == 0) 
		// Reset the viewport in the pixmap:
		Tk_DoWhenIdle( RT_PixmapDisplayData::reset_glxwin, (ClientData)d);
	}
      case EnterNotify:
	d->enter=1;
	break;
      case LeaveNotify:
	d->enter=0;
	break;
	// the point events

      case ButtonPress: {
	  XButtonEvent *evb = (XButtonEvent *) eventPtr;
	  RT_ButtonEvent *pev = new RT_ButtonEvent;
	  if (evb->button == Button1) {pev->left = 1;}
	  if (evb->button == Button2) {pev->middle = 1;}
	  if (evb->button == Button3) {pev->right = 1;}
	  if (evb->state & ShiftMask) {pev->shift =1;}
	  if (evb->state & ControlMask) {pev->ctrl =1;}
	  if (evb->state & Mod1Mask) {pev->alt =1;}
	  pev->w = d->px->w;
	  pev->h = d->px->h;
	  pev->x = evb->x;  
	  pev->y = d->px->h-evb->y;
	  if (d->px->xcamera) d->px->xcamera->event( *pev );
	  delete pev;
	  break; 
      }
      case MotionNotify: {
	  XPointerMovedEvent *evm = (XPointerMovedEvent *) eventPtr;
	  RT_MotionEvent *pev = (RT_MotionEvent *) new RT_MotionEvent;
	  if (evm->state & Button1Mask) {pev->left = 1;}
	  if (evm->state & Button2Mask) {pev->middle = 1;}
	  if (evm->state & Button3Mask) {pev->right = 1;}
	  if (evm->state & ShiftMask) {pev->shift =1;}
	  if (evm->state & ControlMask) {pev->ctrl =1;}
	  if (evm->state & Mod1Mask) {pev->alt =1;}
	  pev->w = d->px->w;
	  pev->h = d->px->h;
	  pev->x = evm->x;  
	  pev->y = d->px->h-evm->y;
	  if (d->px->xcamera) d->px->xcamera->event( *pev );
	  delete pev;
	  break; 
      }
      case ConfigureNotify:
	if (d->bound ) {
	    if (!((XConfigureEvent *) eventPtr)->send_event) {
		// Send the Configure Event back to initialize the width and height
		// of the gl-window correct :
		XSendEvent(d->display,Tk_WindowId(d->tkwin), 1, 0, eventPtr);
	    } else {
		// Reset the viewport in the pixmap:
		d->px->w = Tk_Width(d->tkwin);
		d->px->h = Tk_Height(d->tkwin);
		Tk_DoWhenIdle(RT_PixmapDisplayData::reset_glxwin, (ClientData)d);
	    } 
	}
    }
}

void RT_PixmapDisplayData::reset_glxwin(ClientData cd) {
    RT_PixmapDisplayData *d = (RT_PixmapDisplayData *)cd;
    d->glxwin_winset();
    reshapeviewport();
    if (d->px->xcamera) d->px->xcamera->refresh();
}

RT_PixmapDisplay::~RT_PixmapDisplay() { 
    data->del = 1;
    if (data->spInfo) {
	rt_spaceballRemove(data->display, data->spInfo);
	delete data->spInfo;
    }
    delete data;    
}   

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {
    data = new RT_PixmapDisplayData;
    data->tkwin = Tk_CreateWindowFromPath(rt_Ip, rt_TkWin, _name, NULL );
    if (data->tkwin == NULL) {
	data->result = TCL_ERROR;
	return;
    }

    Tk_SetClass(data->tkwin, "TkPixmap");

    data->display = Tk_Display(data->tkwin);
    data->glxconfig = NULL;
    data->bound = 0;
    data->px = this;
    
    Tk_CreateEventHandler(data->tkwin, ButtonPressMask| ButtonReleaseMask| PointerMotionMask| 
			  ButtonMotionMask| StructureNotifyMask | ExposureMask | EnterWindowMask | 
			  LeaveWindowMask, RT_PixmapDisplayData::eventProc, (ClientData)data);
    
    Tk_CreateGenericHandler(RT_PixmapDisplayData::gevProc, (ClientData)data);
    data->glxwin_winset();

    if ((w > 0) && (h > 0)) Tk_GeometryRequest(data->tkwin, w,h);
    
    GLXconfig inconf[4];
    
    inconf[0].buffer = GLX_NORMAL;
    inconf[0].mode = GLX_RGB;
    inconf[0].arg  = 1;

    inconf[1].buffer = GLX_NORMAL;
    inconf[1].mode = GLX_DOUBLE;
    inconf[1].arg  = 1;

    inconf[2].buffer = GLX_NORMAL;
    inconf[2].mode = GLX_ZSIZE;
    inconf[2].arg  = GLX_NOCONFIG;

    inconf[3].buffer = 0;
    inconf[3].mode =   0;
    inconf[3].arg  =   0;

    data->glxconfig = 
    GLXgetconfig(data->display, Tk_ScreenNumber(data->tkwin), inconf);

    if(data->glxconfig == NULL) {
	Tk_DestroyWindow(data->tkwin);
	return;
    }

    data->get_glxwin_info();
}

void RT_PixmapDisplay::activate() { 
   if (data->bound) data->glxwin_winset(); 
   else data->link_glxwin();
}

void RT_PixmapDisplay::singlebuffer() {}

void RT_PixmapDisplay::doublebuffer() {}

// the event handling is done by tk\'s main loop 
void RT_PixmapDisplay::event() {}    


void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    unsigned long u = (unsigned long)(colr);
    frontbuffer( 1 );
    lrectwrite( x, y, x, y, &u ); 
    frontbuffer( 0 );
}

RT_Color RT_PixmapDisplay::getPixel(int _x, int _y) {
    if (!checkIndices( _x, _y)) return RT_Color( 0,0,0);
    unsigned long val[1];
    lrectread(_x, _y, _x, _y, val );
    return RT_Color( *val );
}

void RT_PixmapDisplay::clear(const RT_Color &x) { 
    long c = 0;
    c |= ((long) x.b*255) << 16;
    c |= ((long) x.g*255) << 8;
    c |= ((long) x.r*255) ;
    long zfar;
    zfar = getgdesc(GD_ZMAX);
    czclear(c, zfar);
};

#include "gl.C"
 
