//  LAST EDIT: Fri Aug  6 01:26:52 1993 by ekki(@prakinf.tu-ilmenau.de)
#include "gralphgs.h"
#include "../utils.h"

// structure element read/write functions:

void addNameSetWrite(Pelem_data *data) {
    padd_names_set( &data->names );
}

#ifdef NEVER
papplication_data(Pdata *data);

par_all_struct(Pint archive_id);

par_struct_net(Pint archive_id, Pint_list *struct_ids);

par_struct(Pint archive_id, Pint_list *struct_ids );

#endif

void annoTextRelWrite(Pelem_data *data) {
    panno_text_rel(&data->anno_text_rel.ref_point,
		   &data->anno_text_rel.offset,
		   data->anno_text_rel.char_string
		   );
}

void annoTextRel3Write(Pelem_data *data) {
    panno_text_rel3(&data->anno_text_rel3.ref_point,
		    &data->anno_text_rel3.offset,
		    data->anno_text_rel3.char_string
		    );
}

#ifdef NEVER

pcell_array(Prect *rectangle, Pdim *dim, Pint *colours);

pcell_array3(Pparallelogram *pgram, Pdim *dim, Pint *colours);

pcopy_all_elems_struct(Pint struct_id);

pclose_ar_file(Pint Pfile_id);

pchange_struct_id(Pint orig_struct_id, Pint result_struct_id);

pchange_struct_id_ref(Pint oldsid, Pint newsid );

pchange_struct_ref(Pint orig_struct_id, Pint result_struct_id);

#endif

void executeStructWrite(Pelem_data *data) {
    pexec_struct(data->int_data);
}

void fillarea3Write(Pelem_data *data) {
    pfill_area3( &data->point_list3 );
}

void fillareaWrite(Pelem_data *data) {
    pfill_area( &data->point_list );
}

void fillareaSetWrite(Pelem_data *data) {
    pfill_area_set( &data->point_list_list );
}

void fillareaSet3Write(Pelem_data *data) {
    pfill_area_set3( &data->point_list_list3 );
}

void labelWrite(Pelem_data *data) {
    plabel( data->int_data );
}

void polylineWrite(Pelem_data *data) {
    ppolyline( &data->point_list );
}

void polyline3Write(Pelem_data *data) {
    ppolyline3( &data->point_list3 );
}

void polymarkerWrite(Pelem_data *data) {
    ppolymarker( &data->point_list );
}

void polymarker3Write(Pelem_data *data) {
    ppolymarker3( &data->point_list3 );
}

void removeNameSetWrite(Pelem_data *data) {
    premove_names_set( &data->names );
}

void annoStyleWrite(Pelem_data *data) {
    pset_anno_style(data->int_data);
}

#ifdef NEVER
pset_anno_align(Ptx_align *align);
#endif

void annoCharHeightWrite(Pelem_data *data) {
    pset_anno_char_ht( data->float_data );
}

#ifdef NEVER
pset_anno_char_up_vector(Pvector *up_vect);

pset_anno_path(Ptx_path path);

#endif

void charHeightWrite(Pelem_data *data) {
    pset_char_ht( data->float_data );
}

void charSpaceWrite(Pelem_data *data) {
    pset_char_space( data->float_data );
}

#ifdef NEVER

void pset_char_up_vector(
        Pvector *up_vect);

#endif

void charExpanWrite(Pelem_data *data) {
    pset_char_expan(data->float_data);
}

void edgeColrIndWrite(Pelem_data *data) {
    pset_edge_colr_ind(data->int_data);
}

#ifdef NEVER

void pset_edge_flag(
        Pedge_flag edge_flag);

#endif

void edgeIndWrite(Pelem_data *data) {
    pset_edge_ind(data->int_data);
}

void edgeTypeWrite(Pelem_data *data) {
    pset_edgetype(data->int_data);
}

#ifdef NEVER
void pset_error_hand_mode(
        Perror_mode mode);
#endif

void edgeWidthWrite(Pelem_data *data) {
    pset_edgewidth(data->float_data);
}

void globalTranWrite(Pelem_data *data) {
    pset_global_tran( data->global_tran);
}

void globalTran3Write(Pelem_data *data) {
    pset_global_tran3( data->global_tran3);
}

void hlhsrIdWrite(Pelem_data *data) {
    pset_hlhsr_id( data->int_data );
}

#ifdef NEVER

pset_indiv_asf(Paspect asf_id, Pasf asf_source);

#endif

void intColrIndWrite(Pelem_data *data) { 
    pset_int_colr_ind(data->int_data);
}

void intIndWrite(Pelem_data *data) { 
    pset_int_ind(data->int_data);
}
void intStyleWrite(Pelem_data *data) {
    pset_int_style(data->int_style);
}

void intStyleIndWrite(Pelem_data *data) {
    pset_int_style_ind(data->int_data);
}

void localTranWrite(Pelem_data *data) {
    pset_local_tran( data->local_tran.matrix, data->local_tran.compose_type );
}

void localTran3Write(Pelem_data *data) {
    pset_local_tran3( data->local_tran3.matrix, data->local_tran3.compose_type );
}

void lineTypeWrite(Pelem_data *data) {
    pset_linetype(data->int_data);
}

void lineWidthWrite(Pelem_data *data) {
    pset_linewidth(data->float_data);
}

#ifdef NEVER

pset_model_clip_indicator(Pclip ind);

pset_model_clip_vol(Pint op, Phalf_space_list *half_spaces);

pset_model_clip_vol3(Pint op, Phalf_space_list3 *hf_spaces);

#endif

void markerTypeWrite(Pelem_data *data) {
    pset_marker_type(data->int_data);
}

void markerSizeWrite(Pelem_data *data) {
    pset_marker_size(data->float_data);
}

#ifdef NEVER

pset_pattern_size(Pvector *size);

pset_pattern_ref_pt(Ppoint *ref_pt);

pset_pick_id(Pint pick_id);

#endif

void lineColrIndWrite(Pelem_data *data) {
    pset_line_colr_ind(data->int_data);
}

void lineIndWrite(Pelem_data *data) {
    pset_line_ind(data->int_data);
}

void markerColrIndWrite(Pelem_data *data) {
    pset_marker_colr_ind(data->int_data);
}

void markerIndWrite(Pelem_data *data) {
    pset_marker_ind(data->int_data);
}

#ifdef NEVER

pset_pattern_ref_pt_vector(Ppoint3 *ref_pt, Pvector3 *dx, Pvector3 *dy);

pset_text_align(Ptx_align *align);

#endif

void textColrIndWrite(Pelem_data *data) {
    pset_text_colr_ind( data->int_data );
}

void textFontWrite(Pelem_data *data) {
    pset_text_font( data->int_data );
}

void textIndWrite(Pelem_data *data) {
    pset_text_ind( data->int_data );
}

#ifdef NEVER

pset_text_path(Ptx_path path);

pset_text_prec(Ptx_prec precision);

#endif

void viewIndWrite(Pelem_data *data) {
    pset_view_ind(data->int_data);
}

void textWrite(Pelem_data *data) {
    ptext( &data->text.pos, data->text.char_string );
}

void text3Write(Pelem_data *data) {
    ptext3( &data->text3.pos, data->text3.dir, data->text3.char_string );
}

#ifdef  NEVER

// phigs plus functions

ppolyline_set3_data(Pper_vertex per_vertex, Pint colr_type, Pint num_lists, const Pvertex_list *vertex_data);

pfill_area_set3_data(Pper_facet per_facet, Pper_edge per_edge, Pper_vertex per_vertex, Pint colr_type, const Pfacet *facet_data, Pint num_edge_flag_lists, const  Pedge_flag_list *edge_data, Pint num_vertex_lists, const Pvertex_list *vertex_data );

pcell_array3_plus(const Pparallelogram *paral, Pint colr_type, const Pdim *dim, const Pcolrv **colours);

pset_of_fill_area_set3_data(Pper_facet per_facet, Pper_edge per_edge, Pper_vertex per_vertex, Pint colr_type, const Pfacet_list *facet_data, const Pedge_flag_set_list *edge_flags, const Pvertex_list *vertex_data, const Pcontour_set_list *contour_data);

ptri_strip3_data(Pper_facet per_facet, Pper_edge per_edge, Pper_vertex per_vertex, Pint colr_type, Pint num_vertices, const Pfacet *facet_data, *edge_flags, const Pvertex *vertex_data );

pquad_mesh3_data (Pper_facet per_facet, Pper_edge per_edge, Pper_vertex per_vertex, Pint colr_type, const Pdim *dim, const Pfacet **facet_data, Pedge_flag **edge_flags, const Pvertex **vertex_data );

pnon_uniform_b_spline_curve (Pint order, const Pfloat_list *knots, Pfloat param_range [2], Prationality rationality, const Pctrl_point_list3 *ctrl_points );

pnon_uniform_b_spline_surface (Pint u_order, Pint v_order, const Pfloat_list *u_knots, const Pfloat_list *v_knots, Prationality rationality, const Pctrl_point_array3 *ctrl_points, Pint num_trim_curve_loops, const Ptrim_curve_loop *trim_loops );

pcomp_fill_area_set_geom_norm (Pint num_lists, const Pvertex_list *vertex_lists, Pint *error_ind, Pvector3 *unit_normal );

#endif

void dataMapIndWrite(Pelem_data *data) {
    pset_data_map_ind( data->int_data );
}

void reflIndWrite(Pelem_data *data) {
    pset_refl_ind( data->int_data );
}

void backIntIndWrite(Pelem_data *data) {
    pset_back_int_ind( data->int_data );
}

void backDataMapIndWrite(Pelem_data *data) {
    pset_back_data_map_ind( data->int_data );
}

void backReflIndWrite(Pelem_data *data) {
    pset_back_refl_ind( data->int_data );
}

void paramSurfIndWrite(Pelem_data *data) {
    pset_param_surf_ind( data->int_data );
}

void lineColrWrite(Pelem_data *data) {
    pset_line_colr( &data->colr );
}

void lineShadingMethodWrite(Pelem_data *data) {
    pset_line_shad_method( data->int_data );
}

void markerColrWrite(Pelem_data *data) {
    pset_marker_colr( &data->colr );
}

void textColrWrite(Pelem_data *data) {
    pset_text_colr( &data->colr );
}

#ifdef NEVER

pset_face_disting_mode( Pface_disting_mode mode );

pset_face_cull_mode( Pface_cull_mode mode );

#endif

void intColrWrite(Pelem_data *data) {
    pset_int_colr( &data->colr );
}

void intShadingMethodWrite(Pelem_data *data) {
    pset_int_shad_method( data->int_data );
}

#ifdef NEVER

pset_data_map_method( const Pdata_map_rep *rep );

#endif

void reflPropsWrite(Pelem_data *data) {
    pset_refl_props( data->refl_props.amb_refl_coeff,
		    data->refl_props.diff_refl_coeff,
		    data->refl_props.spec_refl_coeff,
		    &data->refl_props.spec_colr,
		    data->refl_props.spec_exp );
}

void reflModelWrite(Pelem_data *data) {
    pset_refl_model( data->int_data );
}

#ifdef NEVER
pset_refl_chars( Pint refl_chars );

#endif

void backIntStyleWrite(Pelem_data *data) {
    pset_back_int_style( data->int_style );
}

void backIntStyleIndWrite(Pelem_data *data) {
    pset_back_int_style_ind( data->int_style );
}


void backIntColrWrite(Pelem_data *data) {
    pset_back_int_colr( &data->colr );
}

void backIntShadingMethodWrite(Pelem_data *data) {
    pset_back_int_shad_method( data->int_data );
}

#ifdef NEVER
pset_back_data_map_method( const Pdata_map_rep *rep );

pset_back_refl_props( Pfloat amb_coeff, Pfloat diff_coeff, Pfloat spec_coeff, const Pgcolr spec_colr, Pfloat spec_exp );

pset_back_refl_chars( Pint refl_chars );

#endif

void lightSourceStWrite(Pelem_data *data) {
    Pfilter *filter = (Pfilter *)data;
    pset_light_source_st( filter->incl_set.num_ints,
			 filter->incl_set.ints,
			 filter->excl_set.num_ints,
			 filter->excl_set.ints );
}

void edgeColrWrite(Pelem_data *data) {
    pset_edge_colr( &data->colr );
}

#ifdef NEVER

pset_curve_approx_criteria( Pcurve_approx_data *data );

pset_surf_approx_criteria( const Psurf_approx_data *data );

pset_param_surf_chars( const Pparam_surf_data *data );

#endif

void rendColrModelWrite(Pelem_data *data) {
    pset_rend_colr_model( data->int_data );
}

void depthCueIndWrite(Pelem_data *data) {
    pset_depth_cue_ind( data->int_data );
}

void colrMapIndWrite(Pelem_data *data) {
    pset_colr_map_ind( data->int_data );
}

// print out functions:

void labelPrint(Pelem_data *data) {
    printf("\t%i\n", data->int_data );
}

void point3Print(Pelem_data *data) {
    int i = -1;
    while (++i < data->point_list3.num_points)
	printf("\t[%i] (x, y, z) = (%f, %f, %f)\n", i,
	       data->point_list3.points[i].x, 
	       data->point_list3.points[i].y,
	       data->point_list3.points[i].z);
}

void pointPrint(Pelem_data *data) {
    int i = -1;
    while (++i < data->point_list.num_points) printf("\t[%i] (x, y) = (%f, %f)\n", i,
       data->point_list.points[i].x, data->point_list.points[i].y);
}

void intPrint(Pelem_data *data) {
    printf("\t%i\n", data->int_data);
}

void intStylePrint(Pelem_data *data) {
    printf("\t%i\n", data->int_style);
}

void floatPrint(Pelem_data *data) {
    printf("\t%f\n", data->float_data);
}

void globalMatrix3Print(Pelem_data *data) {
    for (int i = 0; i < 4; i++)    
	for (int j = 0; j < 4; j++)
	    printf("\t[%i, %i] = %f\n", i, j, data->global_tran3[i][j]);
}

void globalMatrixPrint(Pelem_data *data) {
    for (int i = 0; i < 3; i++)    
	for (int j = 0; j < 3; j++)
	    printf("\t[%i, %i] = %f\n", i, j, data->global_tran[i][j]);
}

void localMatrix3Print(Pelem_data *data) {
    for (int i = 0; i < 4; i++)    
	for (int j = 0; j < 4; j++)
	    printf("\t[%i, %i] = %f\n", i, j, data->local_tran3.matrix[i][j]);
    switch (data->local_tran3.compose_type) {
      case PTYPE_PRECONCAT:
	printf("\tComposition type: PRECONCATENATE\n");
	break;
      case PTYPE_POSTCONCAT:
	printf("\tComposition type: POSTCONCATENATE\n");
	break;
      case PTYPE_REPLACE:
	printf("\tComposition type: REPLACE\n");
	break;
    }
}

void localMatrixPrint(Pelem_data *data) {
    for (int i = 0; i < 3; i++)    
	for (int j = 0; j < 3; j++)
	    printf("\t[%i, %i] = %f\n", i, j, data->local_tran.matrix[i][j]);
    switch (data->local_tran.compose_type) {
      case PTYPE_PRECONCAT:
	printf("\tComposition type: PRECONCATENATE\n");
	break;
      case PTYPE_POSTCONCAT:
	printf("\tComposition type: POSTCONCATENATE\n");
	break;
      case PTYPE_REPLACE:
	printf("\tComposition type: REPLACE\n");
	break;
    }
}

void colorPrint(Pelem_data *data) {
    switch( data->colr.colr_type) {
      case PMODEL_RGB:
	printf( "\ttype: RGB MODEL\n" );
	printf( "\tred:\t%f\n", data->colr.colr_value.colr_rep.rgb.red );
	printf( "\tgreen:\t%f\n", data->colr.colr_value.colr_rep.rgb.green );
	printf( "\tblue:\t%f\n", data->colr.colr_value.colr_rep.rgb.blue );
	break;
      case PMODEL_HLS:
	printf( "\ttype: HLS MODEL\n" );
	break;
      case PMODEL_CIELUV:
	printf( "\ttype: CIELUV MODEL\n" );
	break;
      case PMODEL_HSV:
	printf( "\ttype: HSV MODEL\n" );
	break;
      default:
	printf( "\twrong color model\n" );
    }
}

void intListPrint( Pelem_data *data) {
    for (int i = 0; i < data->names.num_ints; i++)
	printf("\t[%i]: %i\n", i, data->names.ints[i]);
}


void reflPropsPrint( Pelem_data *data) {
    printf( "\tCoefficients:\n\t\tambient: %f,\n\t\tdiffuse: %f,\n\t\tspecular: %f\n", 
	   data->refl_props.amb_refl_coeff,
	   data->refl_props.diff_refl_coeff,
	   data->refl_props.spec_refl_coeff
	   );
    printf( "\tSpecular Color:\n" );
    switch( data->refl_props.spec_colr.colr_type) {
      case PMODEL_RGB:
	printf( "\ttype: RGB MODEL\n" );
	printf( "\tred:\t%f\n", data->colr.colr_value.colr_rep.rgb.red );
	printf( "\tgreen:\t%f\n", data->colr.colr_value.colr_rep.rgb.green );
	printf( "\tblue:\t%f\n", data->colr.colr_value.colr_rep.rgb.blue );
	break;
      case PMODEL_HLS:
	printf( "\ttype: HLS MODEL\n" );
	break;
      case PMODEL_CIELUV:
	printf( "\ttype: CIELUV MODEL\n" );
	break;
      case PMODEL_HSV:
	printf( "\ttype: HSV MODEL\n" );
	break;
      default:
	printf( "\twrong color model\n" );
    }
}

void text3Print(Pelem_data *data) {
    Ppoint3 pos = data->text3.pos;
    printf( "\tPosition: ( %f, %f, %f )\n", pos.x, pos.y, pos.z );
    Pvec3 *dir = data->text3.dir;
    printf( "\tDirection 1: ( %f, %f, %f )\n", dir[0].delta_x, dir[0].delta_y, dir[0].delta_z );
    printf( "\tDirection 2: ( %f, %f, %f )\n", dir[1].delta_x, dir[1].delta_y, dir[1].delta_z );
    printf( "\tText: %s\n", data->text3.char_string );
}

void lightSourceStPrint(Pelem_data *data) {
    printf( "\tInclusion set ( %i elements):\n\t( ",
	   data->light_source.num_act );
    for ( int i = 0; i < data->light_source.num_act; i++ )
	printf( "%i ", data->light_source.act_list[i] );
    printf( ")\n" );
    printf( "\tExclusion set ( %i elements):\n\t( ",
	   data->light_source.num_deact );
    for ( i = 0; i < data->light_source.num_deact; i++ )
	printf( "%i ", data->light_source.deact_list[i] );
    printf( ")\n" );
}

// the overall table:

typedef void(*RT_GralphigsElemFunPtr)(Pelem_data*); 

typedef struct RT_GralphigsElement {
    char *name;
    RT_GralphigsElemFunPtr print;
    RT_GralphigsElemFunPtr write;
};

RT_GralphigsElement RT_GRALPHIGS_ELEMENTS[] = {
    {"ALL", NULL, NULL},
    {"NIL", NULL, NULL},
    {"POLYLINE3", point3Print, polyline3Write},
    {"POLYLINE", pointPrint, polylineWrite},
    {"POLYMARKER3", point3Print, polymarker3Write},
    {"POLYMARKER", pointPrint, polymarkerWrite},
    {"TEXT3", text3Print, text3Write},
    {"TEXT", NULL, textWrite},
    {"ANNO_TEXT_REL3", NULL, annoTextRel3Write},
    {"ANNO_TEXT_REL", NULL, annoTextRelWrite},
    {"FILL_AREA3", point3Print, fillarea3Write},
    {"FILL_AREA", pointPrint, fillareaWrite},
    {"FILL_AREA_SET3", NULL, fillareaSet3Write},
    {"FILL_AREA_SET", NULL, fillareaSetWrite},
    {"CELL_ARRAY3", NULL, NULL},
    {"CELL_ARRAY", NULL, NULL},
    {"GDP3", NULL, NULL},
    {"GDP", NULL, NULL},
    {"LINE_IND", intPrint, lineIndWrite},
    {"MARKER_IND", intPrint, markerIndWrite},
    {"TEXT_IND", intPrint, textIndWrite},
    {"INT_IND", intPrint, intIndWrite},
    {"EDGE_IND", intPrint, edgeIndWrite},
    {"LINETYPE", intPrint, lineTypeWrite},
    {"LINEWIDTH_SCALE", floatPrint, lineWidthWrite},
    {"LINE_COLR_IND", intPrint, lineColrIndWrite},
    {"MARKER_TYPE", intPrint, markerTypeWrite},
    {"MARKER_SIZE_SCALE", floatPrint, markerSizeWrite},
    {"MARKER_COLR_IND", intPrint, markerColrIndWrite},
    {"TEXT_FONT", intPrint, textFontWrite},
    {"TEXT_PREC", NULL, NULL},
    {"CHAR_EXPAN", floatPrint, charExpanWrite},
    {"CHAR_SPACE", floatPrint, charSpaceWrite},
    {"TEXT_COLR_IND", intPrint, textColrIndWrite},
    {"CHAR_HEIGHT", floatPrint, charHeightWrite},
    {"CHAR_UP_VECTOR", NULL, NULL},
    {"TEXT_PATH", NULL, NULL},
    {"TEXT_ALIGN", NULL, NULL},
    {"ANNO_CHAR_HEIGHT", floatPrint, annoCharHeightWrite},
    {"ANNO_CHAR_UP_VECTOR", NULL, NULL},
    {"ANNO_PATH", NULL, NULL},
    {"ANNO_ALIGN", NULL, NULL},
    {"ANNO_STYLE", intPrint, annoStyleWrite},
    {"INT_STYLE", intStylePrint, intStyleWrite},
    {"INT_STYLE_IND", intPrint, intStyleIndWrite},
    {"INT_COLR_IND", intPrint, intColrIndWrite},
    {"EDGE_FLAG", NULL, NULL},
    {"EDGETYPE", intPrint, edgeTypeWrite},
    {"EDGEWIDTH_SCALE", floatPrint, edgeWidthWrite},
    {"EDGE_COLOR_IND", intPrint, edgeColrIndWrite},
    {"PATTERN_SIZE", NULL, NULL},
    {"PATTERN_REF_PT_VECTOR", NULL, NULL},
    {"PATTERN_REF_PT", NULL, NULL},
    {"ADD_NAME_SET", intListPrint, addNameSetWrite},
    {"REMOVE_NAME_SET", intListPrint, removeNameSetWrite},
    {"INDIV_ASF", NULL, NULL},
    {"HLHSR_ID", intPrint, hlhsrIdWrite},
    {"LOCAL_MODEL_TRAN3", localMatrix3Print, localTran3Write},
    {"LOCAL_MODEL_TRAN", localMatrixPrint, localTranWrite},
    {"GLOBAL_MODEL_TRAN3", globalMatrix3Print, globalTran3Write},
    {"GLOBAL_MODEL_TRAN", globalMatrixPrint, globalTranWrite},
    {"MODEL_CLIP_VOL3", NULL, NULL},
    {"MODEL_CLIP_VOL", NULL, NULL},
    {"MODEL_CLIP_INDICATOR", NULL, NULL},
    {"RESTORE_MODEL_CLIP_VOL", NULL, NULL},
    {"VIEW_IND", intPrint, viewIndWrite},
    {"EXECUTE_STRUCT", intPrint, executeStructWrite},
    {"LABEL", labelPrint, labelWrite},
    {"APPLICATION_DATA", NULL, NULL},
    {"GSE", NULL, NULL},
    {"PICK_ID", intPrint, NULL},
    {"POLYLINE_SET3_DATA", NULL, NULL},
    {"FILL_AREA_SET3_DATA", NULL, NULL},
    {"FILL_AREA_SET_DATA", NULL, NULL},
    {"CELL_ARRAY3_PLUS", NULL, NULL},
    {"CELL_ARRAY_PLUS", NULL, NULL},
    {"SET_OF_FILL_AREA_SET3_PLUS", NULL, NULL},
    {"SET_OF_FILL_AREA_SET_PLUS", NULL, NULL},
    {"TRI_SET3_DATA", NULL, NULL},
    {"TRI_SET_DATA", NULL, NULL},
    {"TRI_STRIP3_DATA", NULL, NULL},
    {"TRI_STRIP_DATA", NULL, NULL},
    {"QUAD_MESH3_DATA", NULL, NULL},
    {"QUAD_MESH_DATA", NULL, NULL},
    {"NON_UNIFORM_B_SPLINE_CURVE", NULL, NULL},
    {"NON_UNIFORM_B_SPLINE_CURVE_COLR", NULL, NULL},
    {"NON_UNIFORM_B_SPLINE_SURF", NULL, NULL},
    {"NON_UNIFORM_B_SPLINE_SURF_DATA", NULL, NULL},
    {"DATA_MAP_IND", intPrint, dataMapIndWrite},
    {"REFL_IND", intPrint, reflIndWrite},
    {"BACK_INT_IND", intPrint, backIntIndWrite},
    {"BACK_DATA_MAP_IND", intPrint, backDataMapIndWrite},
    {"BACK_REFL_IND", intPrint, backReflIndWrite},
    {"PARAM_SURF_IND", intPrint, paramSurfIndWrite},
    {"LINE_COLR", colorPrint, lineColrWrite},
    {"LINE_SHADING_METHOD", intPrint, lineShadingMethodWrite},
    {"MARKER_COLR", colorPrint, markerColrWrite},
    {"TEXT_COLR", colorPrint, textColrWrite},
    {"FACE_DISTING_MODE", NULL, NULL},
    {"FACE_CULLING_MODE", NULL, NULL},
    {"INT_COLR", colorPrint, intColrWrite},
    {"INT_SHADING_METHOD", intPrint, intShadingMethodWrite},
    {"DATA_MAP_METHOD", NULL, NULL},
    {"REFL_PROPERTIES", reflPropsPrint, reflPropsWrite},
    {"REFL_MODEL", intPrint, reflModelWrite },
    {"BACK_INT_STYLE", intPrint, backIntStyleWrite},
    {"BACK_INT_STYLE_IND", intPrint, backIntStyleIndWrite},
    {"BACK_INT_COLR", colorPrint, backIntColrWrite},
    {"BACK_INT_SHADING_METHOD", intPrint, backIntShadingMethodWrite},
    {"BACK_DATA_MAP_METHOD", NULL, NULL},
    {"BACK_REFL_PROPERTIES", NULL, NULL},
    {"BACK_REFL_MODEL", NULL, NULL},
    {"LIGHT_SOURCE_STAT", lightSourceStPrint, lightSourceStWrite},
    {"EDGE_COLR", colorPrint, edgeColrWrite},
    {"CURVE_APPROX_CRITERIA", NULL, NULL},
    {"SURF_APPROX_CRITERIA", NULL, NULL},
    {"PARAM_SURF_CHARS", NULL, NULL},
    {"RENDERING_COLR_MODEL", intPrint, rendColrModelWrite},
    {"DEPTH_CUE_IND", intPrint, depthCueIndWrite},
    {"COLR_MAP_IND", intPrint, colrMapIndWrite}
};

// utility functions:

void RT_gralphigsInit( char *name, int w, int h, int id) {
    int rx =10; int ry = 10;
    RT_String fname( RT_TMP_FILE );
    mktemp( (char*)fname );
    FILE *bsdef;
    bsdef = fopen( (char*)fname,"w");
    fprintf(bsdef,"%%wk %d\n", id);
    fprintf(bsdef,"%%wn %s\n", name);
    fprintf(bsdef,"%%wP %d %d %d %d\n",rx, ry, w, h);
    fprintf(bsdef,"%%cm 3\n");
    fprintf(bsdef,"%%xe yes\n");
    fprintf(bsdef,"%%fp -adobe-courier-bold-o-normal--*-*-*-*-*-*-iso8859-1\n");
    fclose(bsdef);
    Pxndef((char*)fname );
}

void RT_printStructure( Pint sid ) {
    printf( "*** inquiring structure %i ***\n", sid );
    Pint el = 1;
    Pint error = 0;
    Pelem_type type;
    Pelem_data *data;
    Pstore store;
    pcreate_store( &error, &store );
    while ( !error ) {
	int size;
	pinq_elem_type_size( sid, el, &error, &type, &size );
	if ( error) return;
	pinq_elem_content( sid, el, store, &error, &data );
	printf( RT_GRALPHIGS_ELEMENTS[type].name );
	printf( "\n" );
	if ( RT_GRALPHIGS_ELEMENTS[type].print )
	    RT_GRALPHIGS_ELEMENTS[type].print(data);
	else printf( "Sorry, Print function for %s not implemented\n",
		    RT_GRALPHIGS_ELEMENTS[type].name);
	el++;
    }
    pdel_store( &error, &store );
}


