////////////////////////////////////////////////////////////////////////////////
//  The general YART surface property consisting of Phong coefficients +      //
//  emission + bidirectional reflectance function.                            //  
//  LAST EDIT: Wed Mar  8 13:59:42 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __SURFACE_H__
#define __SURFACE_H__

#include "color.h"

class RT_Surface {
  public:
    RT_Color ambi, diff, spec, emmi; 
    double tran, refr, shin;    
    RT_String specfunc;

    // look into primitiv.C -> ParseTable for description 

    RT_Surface(): ambi( 1,1,1), diff(1,1,1), spec(0,0,0), emmi(0,0,0), 
    specfunc( "" ) {
	// initialize with full diffuse and no reflections 
	// without transparency and emmision:
	refr = 1; tran = 0; shin = 1;

	// these are the default surface values 
    }

    RT_Surface(int): specfunc( "" ) {
	// initialize the reference NULL surface
	tran = 3; refr = -3; shin = 4711;
    }

    int set(const char *);
    const char *get() const {
	static RT_String str(250);
	static char tmp[20];
	str = "{";
	str += ambi.get();
	str += diff.get();
	str += spec.get();
	str += emmi.get();
	sprintf( tmp, "%lf ", tran );
	str += tmp;
	sprintf( tmp, "%lf ", refr );
	str += tmp;
	sprintf( tmp, "%lf ", shin );
	str += tmp;
	str += specfunc;
	str += "} ";
	return (char*)str; 
    }
    
    void print(FILE *f, char *n = 0) const {
	fprintf( f, "%s{", n ? n : "" );
	ambi.print( f );
	diff.print( f );
	spec.print( f );
	emmi.print( f );
	fprintf( f, "%lf %lf %lf {%s}} ", tran, refr, shin, (char*)specfunc );
    }
    void get( float f[4]) const {
	// convert into GL like float* (RGBA = diffuse light + transparency)
	f[0] = diff.r; f[1] = diff.g; f[2] = diff.b; f[3] = 1 - tran;
    }

    int operator==(const RT_Surface &) const;

    void operator=(const RT_Surface &s) {
	ambi = s.ambi;
	diff = s.diff;
	spec = s.spec;
	emmi = s.emmi;
	tran = s.tran;
	refr = s.refr;
	shin = s.shin;
	specfunc = s.specfunc;
    }
};

#endif
