#ifndef __STRINGS_H__
#define __STRINGS_H__

////////////////////////////////////////////////////////////////////////////////
//  A dynamically growing string class replacing char*'s. This class was ori- //
//  ginally made by Sebastian Schmidt.                                        //  
//  LAST EDIT: Tue Oct 25 09:35:19 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdio.h>
#include <string.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

class RT_String {
  private:
    char *val;
    int size;
  public:
    RT_String(int len= 10) {
	// create new RT_String with length len
	if ( !len ) len = 10;
	val = new char[len];
	*val = 0;
	size= len;
    }
    RT_String(const char *str);
    // create new RT_String with str as initial value
    RT_String(const RT_String &s);
    // create new RT_String with s as initial value
    ~RT_String() { if (val) delete val; }
    // free used memory

    char *getValue() const { return val; }
    // get value as C-string	
    char *setValue(const char *newval);
    // assign new value

    int length() const { return strlen(val); }
    // the length of the string

    char *operator= (const char *newval) { return setValue(newval); }
    // 	assign new value
    void operator= (const RT_String &str) { setValue(str.val);}	
    // assign new value
    void operator+=(const char *str);
    // append str on the end
    void operator+=(const RT_String &s) { *this += s.val; }
    // append s to the end
    void operator+=(char c);
    // append c on the end

    void insert(const char* str, int pos);
    // insert str at pos
    int pos(const char* str);
    // get first position of str or -1 
    int lastpos(const char* str);
    // get last position of str or -1 
    RT_String substr(int from, int to);
    // get substring of this 
    void del(const char *str, int times = 1);
    // delete first occurrency of substring from this 
    void dellast(const char *str, int times = 1);
    // delete last occurrency of substring from this 
    void del(int from, int to);
    // delete substring of this
    void delWhite();
    // delete all whitespaces of this
    void replace(const char* s1, const char *s2, int times = 1);
    // replace s1 by s2 times times

    char &operator[](int at);
    // get character at position at
    RT_String operator+(const char* s);
    // concat this and s
    RT_String operator+(const RT_String &s) { return *this+(s.val); }
    // concat this and s
    RT_String operator+(char c);
    // concat this and c
    int operator==(const RT_String &str) const;
    // compare values of this and str
    int operator==(const char *str) const;
    int operator!=(const RT_String& str) {return !operator==(str); }
    // compare values of this and str
    int operator!=(const char *str)   {return !operator==(str); }

    //#### comparing:
    int identical (const RT_String&s);
    // check this and s for identity
    int compare (const RT_String&s);
    // lexical compare values of this and s 

    //#### converting:
    char* as_string() { return val; }
    // explicit conversion to C-string
    operator char* () const { return val; }
    // implicit conversion to C-string

    // print it:
    void print(FILE *f) { fprintf( f, "%s ", (char*)this ); }

    //#### LIPS-like methods:

    RT_String car( );
    // return a String with the first word, OK it's lispy

    RT_String cdr( );
    // return a String with all but the first word
};

inline char *strDup(const char *s) {
    char *ret= new char[strlen(s)+1];
    strcpy(ret, s);
    return ret;
}

#endif 




