////////////////////////////////////////////////////////////////////////////////
//                    The intern radiosity scene class.                       //   
//  LAST EDIT: Fri Aug  5 08:55:05 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <string.h>
#include <values.h>
#include "rs_scene.h"
#include "rs_brdf.h"
#include "rs_pnts.h"
#include "rs_areas.h"
#include "rs_io.h"
#include "../global.h"
#include "../error.h"

//////////////////////  THE RT_RS_Scene MEMBER FUNCTIONS /////////////////////////

void RT_RS_Scene::alloch(RT_RS_Points* aPoints, RT_RS_Areas* aAreas, RT_RS_BRDFs* aBRDFs)
{
  Points = aPoints ? aPoints : new RT_RS_Points(this);
  Areas  = aAreas  ? aAreas  : new RT_RS_Areas(this);
  BRDFs  = aBRDFs  ? aBRDFs  : new RT_RS_BRDFs();
}

void RT_RS_Scene::freeh()
{
  if(BRDFs)  { delete BRDFs; BRDFs = NULL; }
  if(Areas)  { delete Areas; Areas = NULL; }
  if(Points) { delete Points; Points = NULL; }
  if(name)   { delete name; name = NULL; }
}

void RT_RS_Scene::clear()
{
#ifdef RS_DEBUG
  if(!Areas || !Points  || !BRDFs)
    rt_Output->fatalVar(get_class(), ":Cannot clear containers!", NULL);
#endif
//save Areas-parameters:
  boolean auto_mesh      = Areas->auto_mesh;
  float diff_min_area    = Areas->diff_min_area,
        ins_min_area     = Areas->ins_min_area,
        edge_min_area    = Areas->edge_min_area,
        shadow_min_area  = Areas->shadow_min_area,
        light_min_area   = Areas->light_min_area,
        grad_min_area    = Areas->grad_min_area,
        grad_max_delta   = Areas->grad_max_delta;
//save Points-parameters:
  boolean cur_eval_ins   = Points->cur_eval_ins,
          fast           = Points->fast;
  int spar_dim           = Points->spar_dim;
  float max_unshoot      = Points->max_unshoot,
        fast_max_unshoot = Points->fast_max_unshoot,
        fast_max_area    = Points->fast_max_area,
        view_scale       = Points->view_scale,
        max_scale        = Points->max_scale;
  //re-allocate:
  delete Areas;
  delete Points;
  delete BRDFs;
  alloch(NULL, NULL, NULL);

//restore Areas-parameters:
  Areas->auto_mesh         = auto_mesh;
  Areas->diff_min_area     = diff_min_area;
  Areas->ins_min_area      = ins_min_area;
  Areas->edge_min_area     = edge_min_area;
  Areas->shadow_min_area   = shadow_min_area;
  Areas->light_min_area    = light_min_area;
  Areas->grad_min_area     = grad_min_area;
  Areas->grad_max_delta    = grad_max_delta;
//restore Points-parameters:
  Points->cur_eval_ins     = cur_eval_ins;
  Points->fast             = fast;
  Points->max_unshoot      = max_unshoot;
  Points->fast_max_unshoot = fast_max_unshoot;
  Points->fast_max_area    = fast_max_area;
  Points->view_scale       = view_scale;
  Points->max_scale        = max_scale;
  Points->spar_dim         = spar_dim;
}

RT_RS_Scene::RT_RS_Scene(char *filename, FILE *fp)
{
  name = NULL;
  BRDFs = NULL; Areas = NULL; Points = NULL;
  if(!read(filename, fp)) freeh();
}

boolean RT_RS_Scene::read(char *filename, FILE *fp)
{
  boolean aln = fp == NULL;
  boolean Ok = TRUE;
  int clmn = 0;

  if(aln) Ok = openfile(filename, fp, "rt");
  if(Ok) Ok = getline(filename, fp, RS_s);
  if(Ok) Ok = getstr(filename, fp, RS_s, RS_s1, clmn);
  if(Ok) Ok = isclass(filename, RS_s1);
  if(Ok) {
    freeh();
    Ok = getline(filename, fp, RS_s); clmn = 0;
  }
  if(Ok) Ok = getlinestr(filename, fp, RS_s, RS_s1, clmn);
  if(Ok) {
    if(strstr(RS_s1, NONAME)) name = NULL;
    else {
      name = new char[strlen(RS_s1) + 1];
      strcpy(name, RS_s1);
    }
    alloch(NULL, NULL, NULL);
  }
  if(Ok) Ok = BRDFs->read(filename, fp);
  if(Ok) Ok = Points->read(filename, fp);
  if(Ok) Ok = Areas->read(filename, fp);

  if(Ok) Points->init_spatpar();

  if(aln) fclose(fp);
  return Ok;
}

boolean RT_RS_Scene::write(char *filename, FILE *fp)
{
  boolean Ok = TRUE;
  boolean aln = fp == NULL;

  if(aln) Ok = openfile(filename, fp, "wt");
  if(Ok) {
     fprintf(fp,"%s\n%s\n", get_class(), get_name());
    Ok = !ferror(fp);
  }
  if(Ok) Ok = BRDFs->write(filename, fp);
  if(Ok) Ok = Points->write(filename, fp);
  if(Ok) Ok = Areas->write(filename, fp);

  if(!Ok) {
    rt_Output->errorVar(get_class(), ":Cannot write ", filename, NULL);
    return FALSE;
  }
  if(aln) fclose(fp);
  return TRUE;
}

#pragma argsused
void RT_RS_Scene::print(FILE *f, char *n, int width, int decimalPlaces)

{
  if(n) fprintf(f, "%s\n", n);
  fprintf(f, "name: %s\n", get_name());

  Points->print(f, "\n---------- point-container ----------", width, decimalPlaces);
  Areas->print(f, "\n---------- area-container ----------", width, decimalPlaces);
  BRDFs->print(f, "\n---------- BRDF-container ----------", width, decimalPlaces);
}




