#ifndef __RS_MATRX_H__
#define __RS_MATRX_H__

////////////////////////////////////////////////////////////////////////////////
//                      Universal matrix class.                               //   
//  LAST EDIT: Fri Aug  5 08:55:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rs_mvgen.h"
#include "rs_vec.h"
#include "rs_io.h"

//a general matrix for several use
class RT_RS_Matrix : public RT_RS_MVGeneral, public RT_RS_IO
{
protected:
  float **m;    // pointer to pointers to the rows
  void freeh(); // free heap memory
  void alloch(int anr, int anc, char atemp); //allocate heap memory
public:
  char *get_class() { return "RS_Matrix"; }

  //constructors
  RT_RS_Matrix(char *filename, FILE *fp = NULL);
  RT_RS_Matrix(int anr, int anc, char atemp = 'n') { alloch(anr, anc, atemp); }
  RT_RS_Matrix(RT_RS_Matrix& a);
  //destructor
  ~RT_RS_Matrix() { freeh(); }

  void set(float f = .0); //set the elements
  boolean invert();        //Inversion, returns TRUE if successful
  RT_RS_Matrix& operator =  (RT_RS_Matrix& a); 
  RT_RS_Matrix  operator ~  ();  // Transposition
  RT_RS_Matrix  operator !  ();  // Inversion
  float&        operator () (int i, int j);  // range checked element
  RT_RS_Matrix  operator +  (RT_RS_Matrix& a);
  RT_RS_Matrix  operator -  (RT_RS_Matrix& a);
  RT_RS_Matrix  operator *  (float f);
  RT_RS_Matrix  operator /  (float f);

  friend RT_RS_Vector operator *  (RT_RS_Vector& a, RT_RS_Matrix& b);
  friend RT_RS_Vector operator *  (RT_RS_Matrix& a, RT_RS_Vector& b);
  friend RT_RS_Matrix operator *  (RT_RS_Vector& a, RT_RS_Vector& b);
  friend RT_RS_Matrix operator *  (RT_RS_Matrix& a, RT_RS_Matrix& b);
  friend int MatEqSys(RT_RS_Matrix& A, RT_RS_Vector& X,
                      RT_RS_Vector& B, int flag ); //simultaneous linear equations
  //in/out functions
  boolean read(char *filename, FILE *fp = NULL);  // Read ASCII file
  boolean write(char *filename, FILE *fp = NULL); // Write ASCII file
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

#endif

