////////////////////////////////////////////////////////////////////////////////
//            File based input/output of radiosity computation.               //   
// LAST EDIT: Fri Aug  5 08:55:06 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "rs_io.h"
#include "../error.h"
#include "../global.h"

//////////////////////  THE _RS_IO MEMBER FUNCTIONS /////////////////////////

char RT_RS_IO::fmt[RS_LINE_LEN];
char RT_RS_IO::RS_s[RS_LINE_LEN];
char RT_RS_IO::RS_s1[RS_LINE_LEN];

int rt_RSYMsg = 0;

boolean RT_RS_IO::getfloat(char* filename, FILE *fp,
                           float& f, char* _s, int& j)
{
  char field[30];

  search: while(!isfloat(_s[j]) && _s[j] != '\n') j++;
  if(_s[j] == '\n') {
    if(!getline(filename, fp, _s))
      return FALSE;
    j = 0;
    goto search;
  }
  int k = 0;
  while(isfloat(_s[j+k])) {
    field[k] = _s[j+k];
    k++;
  }
  field[k] = '\0';
  j += k;
  f = atof(field);
  return TRUE;
}

boolean RT_RS_IO::getlong(char* filename, FILE *fp,
                          long& l, char* _s, int& j)
{
  char field[30];

  search: while(!islong(_s[j]) && _s[j] != '\n') j++;
  if(_s[j] == '\n') {
    if(!getline(filename, fp, _s))
      return FALSE;
    j = 0;
    goto search;
  }
  int k = 0;
  while(islong(_s[j+k])) {
    field[k] = _s[j+k];
    k++;
  }
  field[k] = '\0';
  j += k;
  l = atol(field);
  return TRUE;
}

boolean RT_RS_IO::getint(char* filename, FILE *fp,
                         int& i, char* _s, int& j)
{
  long l;
  int Ok = getlong(filename, fp, l, _s, j);
  i = (int)l;
  return Ok;
}

boolean RT_RS_IO::getstr(char* filename, FILE *fp,
                         char* _s, char* _str, int& j)
{
  search: while(isspace(_s[j]) && _s[j] != '\n') j++;
  if(_s[j] == '\n') {
    if(!getline(filename, fp, _s))
      return FALSE;
    j = 0;
    goto search;
  }
  int k = 0;
  while(!isspace(_s[j+k])) {
    *_str = _s[j+k];
    _str++; k++;
  }
  *_str = '\0';
  j += k;
  return TRUE;
}

boolean RT_RS_IO::getlinestr(char* filename, FILE *fp,
                             char* _s, char* _str, int& j)
{
  while(_s[j] == '\n') {
    if(!getline(filename, fp, _s))
      return FALSE;
    j = 0;
  }
  int k = 0;
  while(_s[j+k] != '\n') {
    *_str = _s[j+k];
    _str++; k++;
  }
  *_str = '\0';
  j += k;
  return TRUE;
}

boolean RT_RS_IO::getline(char* filename, FILE *fp, char *s)
{
  if(fgets(s, 240, fp) == NULL) {
    rt_Output->errorVar(get_class(), ":Unexpected end of file in ", filename, NULL);
    return FALSE;
  }
  return TRUE;
}

boolean RT_RS_IO::isclass(char* filename, char* s)
{
  if(strcmp(s, get_class())) {
    rt_Output->errorVar(get_class(), " expected instead of ", s,
                        " in ", filename, NULL);
    return FALSE;
  }
  return TRUE;
}

boolean RT_RS_IO::checkdim(char* filename, long dim, long min, long max)
{
  if(dim < min || dim > max) {
    rt_Output->errorVar(get_class(), ":Illegal dimension in ", filename, NULL);
    return FALSE;
  }
  return TRUE;
}

boolean RT_RS_IO::openfile(char* filename, FILE*& fp, char* mode)
{
  if((fp = fopen(filename, mode)) == NULL) {
    rt_Output->errorVar(get_class(), ":Cannot open ", filename, NULL);
    return FALSE;
  }
  return TRUE;
}

boolean RT_RS_IO::isfloat(char c)
{
  if (isdigit(c)) return TRUE;
  if(c == '.' || c == '-' || c == '+' ) return TRUE;
  return FALSE;
}

boolean RT_RS_IO::islong(char c)
{
  if (isdigit(c)) return TRUE;
  if(c == '-' || c == '+' ) return TRUE;
  return FALSE;
}


