////////////////////////////////////////////////////////////////////////////////
// Implementation of a small double linked list.                              //  
// LAST EDIT: Tue Mar  7 14:40:32 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rlist.h"

RT_GeneralList::~RT_GeneralList() {
    RT_GeneralListElem *tmp = root;
    RT_GeneralListElem *x;
    if (tmp) do {
	x = tmp;
	tmp = tmp->next;
	delete x;
    }
    while(tmp);
}

void RT_GeneralList::appendAtBegin(RT_GeneralListEntry *element) {
    if (!root) {
	root = new RT_GeneralListElem;
	root->elem = element;
	root->prev = NULL;
	root->next = NULL;
	last = root;
    }
    else {
	RT_GeneralListElem *tmp = new RT_GeneralListElem;
	tmp->elem = element;
	tmp->prev = NULL;
	tmp->next = root;
	root->prev = tmp;
	root = tmp;
    }
}

void RT_GeneralList::appendAtEnd(RT_GeneralListEntry *element) {
    if (!last) {
	last = new RT_GeneralListElem;
	last->elem = element;
	last->prev = NULL;
	last->next = NULL;
	root = last;
    }
    else {
	RT_GeneralListElem *tmp = new RT_GeneralListElem;
	tmp->elem = element;
	tmp->prev = last;
	tmp->next = NULL;
	last->next = tmp;
	last = tmp;
    }
}

void RT_GeneralList::removeFromBegin(RT_GeneralListEntry *element){
   RT_GeneralListElem *tmp = root;
   if (!tmp) return;
   do if (*tmp->elem == *element) {
       if (tmp->prev) tmp->prev->next = tmp->next;
       else root = tmp->next;
       if (tmp->next) tmp->next->prev = tmp->prev;
       else last = tmp->prev;
       delete tmp;
       return;
   }
   while (tmp = tmp->next);
}

void RT_GeneralList::removeFromEnd(RT_GeneralListEntry *element){
   RT_GeneralListElem *tmp = last;
   if (!tmp) return;
   do if (*tmp->elem == *element) {
       if (tmp->prev) tmp->prev->next = tmp->next;
       else root = tmp->next;
       if (tmp->next) tmp->next->prev = tmp->prev;
       else last = tmp->prev;
       delete tmp;
       return;
   }
   while (tmp = tmp->prev);
}

void RT_GeneralList::doWithElements(RT_GeneralListFunctoid *functoid, void *any) const {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do {
	RT_GeneralListEntry *e = tmp->elem;
	tmp = tmp->next;
	functoid->exec(e, any);
    } while(tmp);
}

void RT_GeneralList::print(FILE *f) const {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	tmp->elem->print(f);
    while(tmp = tmp->next);
}

int RT_GeneralList::getNumber() const {
    int i = 0;
    RT_GeneralListElem *tmp = root;
    if (!tmp) return i;
    do 	i++;
    while(tmp = tmp->next);
    return i;
}

void RT_GeneralList::removeAll() {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do delete tmp->elem;
    while(tmp = tmp->next);

    root = last = 0;
}
