////////////////////////////////////////////////////////////////////////////////
//  Predefined attributes in YART                                             //
//  LAST EDIT: Wed Mar  8 14:00:09 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __PREDEFINED_ATTR_H__
#define __PREDEFINED_ATTR_H__

#include "attribut.h"
#include "surface.h"
#include "mapping.h"

///// the attribute class RESOLUTION

extern const char *RTN_RESOLUTION_ATTR;

class RT_ResolutionAttrImpl: public RT_AttrImpl {
  protected:
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static double solV;
    static int solF, solG;
  public:
    //#### interface of RESOLUTION attribute:
    virtual void resolution(double) = 0;
    virtual double get_resolution() const = 0;

    //#### the Tcl commands:
    static int parseCMD(char *[], RT_Primitive*); 
};

class RT_ResolutionAttribute: public RT_Attribute, public RT_ResolutionAttrImpl {
    double sol;
  public:
    static RT_ResolutionAttribute Default;
    RT_ResolutionAttribute( double _sol = 0.1) { sol = _sol;}
    int set (const char *);
    const char *get() const;
    const char *getClass() const { return RTN_RESOLUTION_ATTR;}
    const RT_Attribute *getDefault() { return &Default; }
    // dont check the consistency here
    // assuming that "a" is a RT_ResolutionAttribute reference
    void operator=(const RT_Attribute &a) {
	sol = ((RT_ResolutionAttribute &)a).sol;
	setNamesList( a.getNamesList() );
    }
    int operator!=(const RT_Attribute &a) const {
	return !( sol == ((RT_ResolutionAttribute &)a).sol );
    }

    //#### interface of RESOLUTION attribute:
    void resolution(double s) { if (s < 0) s = 0; if (s > 1) s = 1; sol = s; changed(); }
    double get_resolution() const { return sol; }
};

///// the attribute class SURFACE

extern const char *RTN_SURFACE_ATTR;

class RT_SurfaceAttrImpl: public RT_AttrImpl {
  protected:
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static RT_Surface surfV;
    static char *surfT;
    static double transV, refrV, shinV;
    static int surfF, ambiF, diffF, specF, transF, refrF, emmiF, shinF;
    static int surfG, ambiG, diffG, specG, transG, refrG, emmiG, shinG;
    static RT_Color ambiV, diffV, emmiV, specV;
    static char *sfuncV;
    static int sfuncF, sfuncG;
  public:
    //#### interface of SURFACE attribute:
    virtual void surface(const RT_Surface &) = 0;
    virtual const RT_Surface &get_surface() const = 0;
    virtual void ambient( const RT_Color&) = 0;
    virtual const RT_Color &get_ambient() const = 0;
    virtual void diffuse( const RT_Color&) = 0;
    virtual const RT_Color &get_diffuse() const = 0;
    virtual void specular( const RT_Color&) = 0;
    virtual const RT_Color &get_specular()  const = 0;
    virtual void emission( const RT_Color&) = 0;
    virtual const RT_Color &get_emission() const = 0;
    virtual void transmission( const double) = 0;
    virtual double get_transmission() const = 0;
    virtual void refraction( const double)  = 0;
    virtual double get_refraction() const = 0;
    virtual void shininess( const double) = 0;
    virtual double get_shininess() const = 0;
    virtual void specfunc(const char*) = 0;
    virtual const char *get_specfunc() const = 0;
    //#### the Tcl commands:
    static int parseCMD(char *[], RT_Primitive*); 
};

class RT_SurfaceAttribute: public RT_Attribute, public RT_SurfaceAttrImpl {
    RT_Surface surf;
  public:
    static RT_SurfaceAttribute Default;
    RT_SurfaceAttribute() {}
    RT_SurfaceAttribute(RT_Surface &_s ) { surf = _s; }
    int set (const char *);
    const char *get() const;
    const char *getClass() const { return RTN_SURFACE_ATTR;}
    const RT_Attribute *getDefault() { return &Default; }
    // dont check the consistency here
    // assuming that "a" is a RT_SurfaceAttribute reference
    void operator=(const RT_Attribute &a) {
	surf = ((RT_SurfaceAttribute &)a).surf;
	setNamesList( a.getNamesList() );
    }
    int operator!=(const RT_Attribute &a) const {
	return !(surf == ((RT_SurfaceAttribute &)a).surf);
    }
    //#### interface of SURFACE attribute:
    void surface( const RT_Surface &_surf) { surf = _surf; changed(); }
    const RT_Surface &get_surface() const { return surf; }
    void ambient( const RT_Color &ambi) { surf.ambi = ambi; changed(); }
    const RT_Color &get_ambient() const { return surf.ambi; }
    void diffuse( const RT_Color &diff) { surf.diff = diff; changed(); }
    const RT_Color &get_diffuse() const { return surf.diff; }
    void specular( const RT_Color &spec) { surf.spec = spec; changed(); }
    const RT_Color &get_specular() const { return surf.spec; }
    void emission( const RT_Color &emmi) { surf.emmi = emmi; changed(); }
    const RT_Color &get_emission() const  { return surf.emmi; }
    void transmission( const double tran) { surf.tran = tran; changed(); }
    double get_transmission() const { return surf.tran; }
    void refraction( const double refr)  { surf.refr = refr; changed(); }
    double get_refraction() const { return surf.refr; }
    void shininess( const double shin)  { surf.shin = shin; changed(); }
    double get_shininess() const { return surf.shin; }
    void specfunc(const char *sf) { surf.specfunc = sf; changed(); }
    const char *get_specfunc() const { return (char*)surf.specfunc; }
};

///// the attribute class FILLSTYLE

extern const char *RTN_FILLSTYLE_ATTR;

class RT_FillstyleAttrImpl: public RT_AttrImpl {
  protected:
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int styV, styF, styG;
  public:
    //#### interface of FILLSTYLE attribute:
    virtual void fillstyle(int) = 0;
    virtual int get_fillstyle() const = 0;
    //#### the Tcl commands:
    static int parseCMD(char *[], RT_Primitive*); 
};

class RT_FillstyleAttribute: public RT_Attribute, public RT_FillstyleAttrImpl {
    int xstyle;
  public:
    static RT_FillstyleAttribute Default;
    RT_FillstyleAttribute(int _style = 0) { xstyle = _style;}
    int set (const char *);
    const char *get() const;
    const char *getClass() const { return RTN_FILLSTYLE_ATTR;}
    const RT_Attribute *getDefault() { return &Default; }
    // dont check the consistency here
    // assuming that "a" is a RT_FillstyleAttribute reference
    void operator=(const RT_Attribute &a) {
	xstyle = ((RT_FillstyleAttribute &)a).xstyle;
	setNamesList( a.getNamesList() );
    }
    int operator!=(const RT_Attribute &a) const {
	return !( xstyle == ((RT_FillstyleAttribute &)a).xstyle );
    }
    //#### interface of FILLSTYLE attribute:
    void fillstyle(int s) {
	if (s < 0) s = 0;
	if (s > 1) s = 1;
	changed();
	xstyle = s;
    }
    int get_fillstyle() const { return xstyle; }
};

extern const char *RTN_MAPPING_ATTR;

class RT_MappingAttrImpl: public RT_AttrImpl {
  protected:
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static char *mpV; static int mpF, mpG;
  public:
    //#### interface of MAPPING attribute:
    virtual void mapping( RT_Mapping *) = 0;
    virtual RT_Mapping *get_mapping() const = 0;
    //#### the Tcl commands:
    static int parseCMD(char *[], RT_Primitive*); 
};

class RT_NoMapping;
extern RT_NoMapping rt_NoMapping;

class RT_MappingAttribute: public RT_Attribute {
    RT_Mapping *xmapping;
    // the related mapping object
  public:
    static RT_MappingAttribute Default;
    RT_MappingAttribute(RT_Mapping *_m = (RT_Mapping*)&rt_NoMapping) { 
	xmapping = _m;
	xmapping->ref();
    }
    ~RT_MappingAttribute() { xmapping->deref(); }
    int set(const char *);
    const char *get() const; 
    const char *getClass() const { return RTN_MAPPING; }
    const RT_Attribute *getDefault() { return &Default; }
    operator RT_Mapping* () { return xmapping; }
    // dont check the consistency here
    // assuming that "a" is a RT_MappingAttribute reference
    void operator=(const RT_Attribute &a) {
	mapping( ((RT_MappingAttribute&)a).get_mapping() );
	setNamesList( a.getNamesList() );
    }
    int operator!=(const RT_Attribute &a) const {
	return !( xmapping == ((RT_MappingAttribute &)a).xmapping );
    }
    //#### interface of MAPPING attribute:
    void mapping( RT_Mapping *_xm) {
	xmapping->deref(); xmapping = _xm; xmapping->ref();
    }
    RT_Mapping *get_mapping() const { return xmapping; }
};

#endif


