////////////////////////////////////////////////////////////////////////////////
//  Implementation of the pre-defined attributes (Tcl access, set&get)        //  
//  LAST EDIT: Fri Aug  5 08:55:26 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "predattr.h"
#include "primitiv.h"

///// the Resolution attribute:

const char *RTN_RESOLUTION_ATTR = "Resolution";

double RT_ResolutionAttrImpl::solV;
int RT_ResolutionAttrImpl::solF;
int RT_ResolutionAttrImpl::solG;

RT_ResolutionAttribute RT_ResolutionAttribute::Default( 0.2 );

RT_ParseEntry RT_ResolutionAttrImpl::table[] = {
    { "-resolution", RTP_DOUBLE, (char*)&solV, &solF, "Specify a {ARG 1 Resolution} for the object. The resolution determines how good the representation of this object in terms of lower level objects is. The area is from 0 to 1. 0 means minimal resolution, 1 means highest resolution.", RTPS_DOUBLE },
    { "-get_resolution", RTP_NONE, 0, &solG, "Get the current resolution of the object.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_ResolutionAttrImpl::parseCMD(char *argv[], RT_Primitive *p) { 
    RT_parseTable( argv, table );
    if (solF) {
	RT_ResolutionAttribute *attr = (RT_ResolutionAttribute*)p->get_privAttribute( RTN_RESOLUTION_ATTR );
	if (!attr) {
	    p->attribute( RT_ResolutionAttribute() );
	    attr = (RT_ResolutionAttribute*)p->get_privAttribute( RTN_RESOLUTION_ATTR );
	}
	attr->resolution( solV );
    }
    if (solG) RT_Object::result( p->get_attribute( RTN_RESOLUTION_ATTR ).get() );
    return solF + solG;
}

const char *RT_ResolutionAttribute::get() const {
    static char tmp[20];
    sprintf( tmp, "%lf", sol);
    return tmp;
}

int RT_ResolutionAttribute::set (const char *val) {
    double xs;
    if (RT_string2double( val, xs)) {
	sol = xs;
	changed();
	return 1;
    }
    return 0;
}

///// the surface attribute:

const char *RTN_SURFACE_ATTR = "Surface";

RT_SurfaceAttribute RT_SurfaceAttribute::Default;
RT_Surface RT_SurfaceAttrImpl::surfV;
char *RT_SurfaceAttrImpl::surfT;
int RT_SurfaceAttrImpl::surfF, RT_SurfaceAttrImpl::surfG;
RT_Color RT_SurfaceAttrImpl::ambiV;
int RT_SurfaceAttrImpl::ambiF, RT_SurfaceAttrImpl::ambiG;
RT_Color RT_SurfaceAttrImpl::diffV;
int RT_SurfaceAttrImpl::diffF, RT_SurfaceAttrImpl::diffG;
RT_Color RT_SurfaceAttrImpl::specV;
int RT_SurfaceAttrImpl::specF, RT_SurfaceAttrImpl::specG;
RT_Color RT_SurfaceAttrImpl::emmiV;
int RT_SurfaceAttrImpl::emmiF, RT_SurfaceAttrImpl::emmiG;
double RT_SurfaceAttrImpl::transV;
int RT_SurfaceAttrImpl::transF, RT_SurfaceAttrImpl::transG;
double RT_SurfaceAttrImpl::refrV;
int RT_SurfaceAttrImpl::refrF, RT_SurfaceAttrImpl::refrG;
double RT_SurfaceAttrImpl::shinV;
int RT_SurfaceAttrImpl::shinF, RT_SurfaceAttrImpl::shinG;
char *RT_SurfaceAttrImpl::sfuncV;
int RT_SurfaceAttrImpl::sfuncF, RT_SurfaceAttrImpl::sfuncG;

RT_ParseEntry RT_SurfaceAttrImpl::table[] = {
    { "-surface", RTP_STRING, (char*)&surfT, &surfF, "Set {ARG 1 Surface} for the object.", RTPS_SURFACE },
    { "-get_surface", RTP_NONE, 0, &surfG, "Get the surface parameters of the object.", RTPS_NONE },
    { "-ambient", RTP_COLOR, (char*)&ambiV, &ambiF, "Set {ARG 1 Ambient} coefficient.", RTPS_COLOR },
    { "-get_ambient", RTP_NONE, 0, &ambiG, "Get ambient coefficient.", RTPS_NONE },
    { "-diffuse", RTP_COLOR, (char*)&diffV, &diffF, "Set {ARG 1 Diffuse} coefficient.", RTPS_COLOR },
    { "-get_diffuse", RTP_NONE, 0, &diffG, "Get diffuse coefficient.", RTPS_NONE },
    { "-specular", RTP_COLOR, (char*)&specV, &specF, "Set {ARG 1 Specular} coefficient.", RTPS_COLOR },
    { "-get_specular", RTP_NONE, 0, &specG, "Get specular coefficient.", RTPS_NONE },
    { "-emission", RTP_COLOR, (char*)&emmiV, &emmiF, "Set {ARG 1 Emission} coefficients of the surface.", RTPS_COLOR },
    { "-get_emission", RTP_NONE, 0, &emmiG, "Get emission coefficient.", RTPS_NONE },
    { "-transmission", RTP_DOUBLE, (char*)&transV, &transF, "Set {ARG 1 Transmisson} coefficient. The range is {RANGE 1 \"0 1\"}, 1 means full transmission, 0 stands for no transmission.", RTPS_DOUBLE },
    { "-get_transmission", RTP_NONE, 0, &transG, "Get transmission coefficient.", RTPS_NONE },
    { "-refraction", RTP_DOUBLE, (char*)&refrV, &refrF, "Set {ARG 1 Refraction} coefficient in the {RANGE 1 \"0 3\"}. The refraction of Air is nearly 1, Water 1.33, and 1.52 for crown Glass, for instance.", RTPS_DOUBLE },
    { "-get_refraction", RTP_NONE, 0, &refrG, "Get refraction coefficient.", RTPS_NONE },
    { "-shininess", RTP_DOUBLE, (char*)&shinV, &shinF, "Set {ARG 1 Shininess} coefficient.", RTPS_DOUBLE },
    { "-get_shininess", RTP_NONE, 0, &shinG, "Get shininess coefficient.", RTPS_NONE },
    { "-specfunc", RTP_STRING, (char*)&sfuncV, &sfuncF, "Set the {ARG 1 BRDF} name for the surface. This specifies a file containing a Bidirectional Reflectance Distribution Function", RTPS_STRING },
    { "-get_specfunc", RTP_NONE, 0, &sfuncG, "Get the BRDF name.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_SurfaceAttrImpl::parseCMD(char *argv[], RT_Primitive *p) { 
    RT_parseTable( argv, table );
    int ret = 0;
    if (surfF) surfF = surfV.set( surfT );
    if (surfF || ambiF || diffF || specF || emmiF || transF || refrF || shinF || sfuncF ) {
	RT_SurfaceAttribute *attr = (RT_SurfaceAttribute*)p->get_privAttribute( RTN_SURFACE_ATTR );
	if (!attr)  {
	    p->attribute( RT_SurfaceAttribute() );
	    attr = (RT_SurfaceAttribute*)p->get_privAttribute( RTN_SURFACE_ATTR );
	}
	if (surfF) { attr->surface(surfV); ret++; }
	if (ambiF) { attr->ambient(ambiV); ret++; }
	if (diffF) { attr->diffuse(diffV); ret++; }
	if (specF) { attr->specular(specV); ret++; }
	if (emmiF) { attr->emission(emmiV); ret++; }
	if (transF) { attr->transmission(transV); ret++; }
	if (refrF) { attr->refraction(refrV); ret++; }
	if (shinF) { attr->shininess(shinV); ret++; }
	if (sfuncF) { attr->specfunc(sfuncV); ret++; }
    }
    if (surfG || ambiG || diffG || specG || emmiG || transG || refrG || shinG || sfuncG ) {
	const RT_SurfaceAttribute &attr = (const RT_SurfaceAttribute&)p->get_attribute( RTN_SURFACE_ATTR );
	if (surfG) { RT_Object::result( attr.get_surface().get() ); ret++; }
	if (ambiG) { RT_Object::result( attr.get_ambient().get() ); ret++; }
	if (diffG) { RT_Object::result( attr.get_diffuse().get() ); ret++; }
	if (specG) { RT_Object::result( attr.get_specular().get() ); ret++; }
	if (emmiG) { RT_Object::result( attr.get_emission().get() ); ret++; }
	if (attr.transG) {
	    static char tmp[20];
	    RT_double2string( attr.get_transmission(), tmp );
	    RT_Object::result( tmp );
	    ret++;
	}
	if (attr.refrG) {
	    static char tmp[20];
	    RT_double2string( attr.get_refraction(), tmp );
	    RT_Object::result( tmp );
	    ret++;
	}
	if (attr.shinG) {
	    static char tmp[20];
	    RT_double2string( attr.get_shininess(), tmp );
	    RT_Object::result( tmp );
	    ret++;
	}
	if (attr.sfuncG) { RT_Object::result( attr.get_specfunc() ); ret++; }
    }
    return ret;
}

const char *RT_SurfaceAttribute::get() const {
    return surf.get();
}

int RT_SurfaceAttribute::set(const char *val) {
    int i = surf.set(val);
    if (i) changed();
    return i;
}

///// the fillstyle attribute:

const char *RTN_FILLSTYLE_ATTR = "Fillstyle";

int RT_FillstyleAttrImpl::styV, RT_FillstyleAttrImpl::styF, RT_FillstyleAttrImpl::styG;

RT_FillstyleAttribute RT_FillstyleAttribute::Default( 0 );
// initialize default attribute: fillstyle WIREFRAME!

RT_ParseEntry RT_FillstyleAttrImpl::table[] = {
    { "-fillstyle", RTP_INTEGER, (char*)&styV, &styF, "Specify a {ARG 1 Fillstyle} for the object. Possible integers are {ENUM 1 \"Empty Solid\"}.", RTPS_INTEGER },
    { "-get_fillstyle", RTP_NONE, 0, &styG, "Get the fillstyle of the object.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_FillstyleAttrImpl::parseCMD(char *argv[], RT_Primitive *p) { 
    RT_parseTable( argv, table );
    if (styF) {
	RT_FillstyleAttribute *attr = (RT_FillstyleAttribute*)p->get_privAttribute( RTN_FILLSTYLE_ATTR );
	if (!attr) {
	    p->attribute( RT_FillstyleAttribute() );
	    attr = (RT_FillstyleAttribute*)p->get_privAttribute( RTN_FILLSTYLE_ATTR );
	}
	attr->fillstyle( styV );
    }
    if (styG) RT_Object::result( p->get_attribute( RTN_FILLSTYLE_ATTR ).get() );
    return styF + styG;
}

const char *RT_FillstyleAttribute::get() const {
    static char tmp[20];
    sprintf( tmp, "%i", xstyle );
    return tmp;
}

int RT_FillstyleAttribute::set (const char *val) {
    int xi;
    if (RT_string2int( val, xi)) {
	if (xi < 0) xi = 0;
	if (xi > 1) xi = 1;
	xstyle = xi;
	changed();
	return 1;
    }
    return 0;
}

// mapping attribute:

const char *RTN_MAPPING_ATTR = "Mapping";

class RT_NoMapping: public RT_Mapping {
    // default mapping attribute - nothing happens
  public:
    RT_NoMapping(): RT_Mapping( 0 ) {
	name = new char[ strlen( "<default mapping>" ) + 1 ];
	strcpy( name,  "<default mapping>" );
    }
    ~RT_NoMapping() {
	delete name;
	name = 0;
    } 
    const char *get_class() const { return "Never used!"; }
    const char *get_description() const { return "Never used!"; }
};

RT_MappingAttribute RT_MappingAttribute::Default( &rt_NoMapping );

RT_NoMapping rt_NoMapping;

int RT_MappingAttribute::set(const char *name) { 
    if ( !strcmp( name, "" ) ) {
	mapping( 0 );
	return 1;
    }
    RT_Object *o = RT_Object::getObject( name );
    if ( o && o->isA( RTN_MAPPING )) {
	mapping( (RT_Mapping*)o); return 1; 
    }
    rt_Output->errorVar( "No such mapping object ", name, "!", 0 );
    return 0; 
}

const char *RT_MappingAttribute::get() const { return (char*)xmapping->get_name(); } 

char *RT_MappingAttrImpl::mpV; int RT_MappingAttrImpl::mpF, RT_MappingAttrImpl::mpG;

RT_ParseEntry RT_MappingAttrImpl::table[] = {
    { "-mapping", RTP_STRING, (char*)&mpV, &mpF, "Set the {ARG 1 Mapping} object: texture and/or bump.", "Mapping" },
    { "-get_mapping", RTP_NONE, 0, &mpG, "Return the mapping object.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_MappingAttrImpl::parseCMD(char *argv[], RT_Primitive *p) { 
    RT_parseTable( argv, table );
    int r = 0;
    if (mpF) {
	RT_Object *at = RT_Object::getObject( mpV );
	if (at && at->isA( RTN_MAPPING )) {
	    RT_MappingAttribute *attr = (RT_MappingAttribute*)p->get_privAttribute( RTN_MAPPING_ATTR );
	    if (!attr) {
		p->attribute( RT_MappingAttribute( (RT_Mapping*)at ) );
		attr = (RT_MappingAttribute*)p->get_privAttribute( RTN_MAPPING_ATTR );
	    }
	    else attr->mapping( (RT_Mapping*)at );
	    r++;
	}
	else rt_Output->errorVar( "No such mapping object: ", mpV, 0 );
    }
    if (mpG) {
	RT_Object::result( p->get_attribute( RTN_MAPPING_ATTR ).get());
	r++ ; 
    }
    return r;
}
